/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.internal.core.model;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import org.eclipse.ptp.rm.lml.core.JobStatusData;
import org.eclipse.ptp.rm.lml.core.LMLCorePlugin;
import org.eclipse.ptp.rm.lml.core.listeners.ILguiListener;
import org.eclipse.ptp.rm.lml.core.model.ILguiHandler;
import org.eclipse.ptp.rm.lml.core.model.ILguiItem;
import org.eclipse.ptp.rm.lml.internal.core.elements.CellType;
import org.eclipse.ptp.rm.lml.internal.core.elements.ColumnType;
import org.eclipse.ptp.rm.lml.internal.core.elements.InfoType;
import org.eclipse.ptp.rm.lml.internal.core.elements.InformationType;
import org.eclipse.ptp.rm.lml.internal.core.elements.LguiType;
import org.eclipse.ptp.rm.lml.internal.core.elements.ObjectFactory;
import org.eclipse.ptp.rm.lml.internal.core.elements.RequestType;
import org.eclipse.ptp.rm.lml.internal.core.elements.RowType;
import org.eclipse.ptp.rm.lml.internal.core.elements.TableType;
import org.eclipse.ptp.rm.lml.internal.core.events.LguiUpdatedEvent;
import org.eclipse.ptp.rm.lml.internal.core.model.LayoutAccess;
import org.eclipse.ptp.rm.lml.internal.core.model.NodedisplayAccess;
import org.eclipse.ptp.rm.lml.internal.core.model.OIDToInformation;
import org.eclipse.ptp.rm.lml.internal.core.model.OIDToObject;
import org.eclipse.ptp.rm.lml.internal.core.model.ObjectStatus;
import org.eclipse.ptp.rm.lml.internal.core.model.OverviewAccess;
import org.eclipse.ptp.rm.lml.internal.core.model.TableHandler;

public class LguiItem
implements ILguiItem {
    private String name;
    private volatile LguiType lgui;
    private final List<ILguiListener> listeners = new LinkedList<ILguiListener>();
    private final Map<Class<? extends ILguiHandler>, ILguiHandler> lguiHandlers = Collections.synchronizedMap(new HashMap());
    private final Map<String, JobStatusData> fJobMap = Collections.synchronizedMap(new TreeMap());
    private static String lmlNamespace = "http://www.llview.de";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LguiType parseLML(URI xml) throws MalformedURLException {
        LguiType lml = null;
        try {
            Unmarshaller unmarshaller = LMLCorePlugin.getDefault().getUnmarshaller();
            Class<LguiItem> clazz = LguiItem.class;
            synchronized (LguiItem.class) {
                JAXBElement doc = (JAXBElement)unmarshaller.unmarshal(xml.toURL());
                // ** MonitorExit[var4_4] (shouldn't be in output)
                lml = (LguiType)doc.getValue();
            }
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        return lml;
    }

    public LguiItem(LguiType lgui) {
        this.lgui = lgui;
        this.createLguiHandlers();
    }

    public LguiItem(String name) {
        this.name = name;
    }

    public LguiItem(URI xmlFile) {
        this.name = xmlFile.getPath();
        try {
            this.lgui = LguiItem.parseLML(xmlFile);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        this.createLguiHandlers();
        this.setCid();
    }

    public void addListener(ILguiListener listener) {
        this.listeners.add(listener);
    }

    public void addUserJob(String jobId, JobStatusData status, boolean force) {
        JobStatusData jobStatus = this.fJobMap.get(jobId);
        if (jobStatus == null) {
            TableType table;
            String oid;
            OverviewAccess overview;
            if (force && (overview = this.getOverviewAccess()) != null && (oid = overview.getOIDByJobId(jobId)) == null && (table = this.getTableHandler().getTable(this.getGidFromJobStatus(status))) != null) {
                oid = this.generateOid();
                status.setOid(oid);
                this.addJobToTable(table, oid, status);
            }
            this.fJobMap.put(jobId, status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getCurrentLayout(OutputStream output) throws JAXBException {
        LguiType layoutLgui = null;
        layoutLgui = this.lgui == null ? this.firstRequest() : this.getLayoutAccess().getLayoutFromModel();
        Marshaller marshaller = LMLCorePlugin.getDefault().getMarshaller();
        try {
            marshaller.setProperty("jaxb.schemaLocation", (Object)(String.valueOf(lmlNamespace) + " lgui.xsd"));
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            QName tagname = new QName(lmlNamespace, "lgui", "lml");
            JAXBElement rootElement = new JAXBElement(tagname, LguiType.class, (Object)layoutLgui);
            Class<LguiItem> clazz = LguiItem.class;
            synchronized (LguiItem.class) {
                marshaller.marshal((Object)rootElement, output);
                // ** MonitorExit[var6_8] (shouldn't be in output)
                output.close();
            }
        }
        catch (PropertyException e) {
            LMLCorePlugin.log(e);
        }
        catch (IOException e) {
            LMLCorePlugin.log(e);
        }
    }

    public LayoutAccess getLayoutAccess() {
        if (this.lguiHandlers.get(LayoutAccess.class) == null) {
            return null;
        }
        return (LayoutAccess)this.lguiHandlers.get(LayoutAccess.class);
    }

    public LguiType getLguiType() {
        return this.lgui;
    }

    public NodedisplayAccess getNodedisplayAccess() {
        if (this.lguiHandlers.get(NodedisplayAccess.class) == null) {
            return null;
        }
        return (NodedisplayAccess)this.lguiHandlers.get(NodedisplayAccess.class);
    }

    public ObjectStatus getObjectStatus() {
        if (this.lguiHandlers.get(ObjectStatus.class) == null) {
            return null;
        }
        return (ObjectStatus)this.lguiHandlers.get(ObjectStatus.class);
    }

    public OIDToInformation getOIDToInformation() {
        if (this.lguiHandlers.get(OIDToInformation.class) == null) {
            return null;
        }
        return (OIDToInformation)this.lguiHandlers.get(OIDToInformation.class);
    }

    public OIDToObject getOIDToObject() {
        if (this.lguiHandlers.get(OIDToObject.class) == null) {
            return null;
        }
        return (OIDToObject)this.lguiHandlers.get(OIDToObject.class);
    }

    public OverviewAccess getOverviewAccess() {
        if (this.lguiHandlers.get(OverviewAccess.class) == null) {
            return null;
        }
        return (OverviewAccess)this.lguiHandlers.get(OverviewAccess.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRequestXml(FileOutputStream output) {
        LguiType layoutLgui = null;
        layoutLgui = this.lgui == null ? this.firstRequest() : this.getLayoutAccess().getLayoutFromModel();
        Marshaller marshaller = LMLCorePlugin.getDefault().getMarshaller();
        try {
            marshaller.setProperty("jaxb.schemaLocation", (Object)(String.valueOf(lmlNamespace) + " lgui.xsd"));
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            QName tagname = new QName(lmlNamespace, "lgui", "lml");
            JAXBElement rootElement = new JAXBElement(tagname, LguiType.class, (Object)layoutLgui);
            Class<LguiItem> clazz = LguiItem.class;
            synchronized (LguiItem.class) {
                marshaller.marshal((Object)rootElement, (OutputStream)output);
                // ** MonitorExit[var6_9] (shouldn't be in output)
                output.close();
            }
        }
        catch (PropertyException e) {
            e.printStackTrace();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public TableHandler getTableHandler() {
        if (this.lguiHandlers.get(TableHandler.class) == null) {
            return null;
        }
        return (TableHandler)this.lguiHandlers.get(TableHandler.class);
    }

    public JobStatusData getUserJob(String jobId) {
        JobStatusData status = this.fJobMap.get(jobId);
        if (status != null && !status.isRemoved()) {
            return status;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobStatusData[] getUserJobs() {
        Map<String, JobStatusData> map = this.fJobMap;
        synchronized (map) {
            return this.fJobMap.values().toArray(new JobStatusData[0]);
        }
    }

    public String getVersion() {
        return this.lgui.getVersion();
    }

    public boolean isEmpty() {
        return this.lgui == null;
    }

    public boolean isLayout() {
        return !this.isEmpty() && this.lgui.isLayout();
    }

    public void notifyListeners() {
        LguiUpdatedEvent event = new LguiUpdatedEvent(this, this.lgui);
        for (ILguiListener l : this.listeners) {
            l.handleEvent(event);
        }
    }

    public void removeListener(ILguiListener listener) {
        this.listeners.remove(listener);
    }

    public void removeUserJob(String jobId) {
        JobStatusData status = this.fJobMap.get(jobId);
        if (status != null) {
            TableType table = this.getTableHandler().getTable(this.getGidFromJobStatus(status));
            if (table != null) {
                int index = -1;
                int i = 0;
                while (i < table.getRow().size()) {
                    RowType row = table.getRow().get(i);
                    String rowJobId = this.getTableHandler().getCellValue(table, row, "step");
                    if (rowJobId.equals(jobId)) {
                        index = i;
                        break;
                    }
                    ++i;
                }
                if (index >= 0) {
                    table.getRow().remove(index);
                }
            }
            status.setRemoved();
        }
    }

    public String toString() {
        return this.name;
    }

    public void update(InputStream stream) throws JAXBException {
        this.lgui = this.parseLML(stream);
        if (this.listeners.isEmpty()) {
            this.createLguiHandlers();
        }
        this.fireUpdatedEvent();
        if (!this.cidSet()) {
            this.setCid();
        }
        this.updateJobData();
    }

    public void updateUserJob(String jobId, String status, String detail) {
        JobStatusData jobStatus = this.fJobMap.get(jobId);
        if (jobStatus != null) {
            TableType table = this.getTableHandler().getTable(this.getGidFromJobStatus(jobStatus));
            if (table != null) {
                for (RowType row : table.getRow()) {
                    String rowJobId = this.getTableHandler().getCellValue(table, row, "step");
                    if (!rowJobId.equals(jobId)) continue;
                    this.getTableHandler().setCellValue(table, row, "status", status);
                    break;
                }
            }
            jobStatus.updateState(status, detail);
        }
    }

    private void addCellToRow(RowType row, ColumnType column, String value) {
        CellType cell = new CellType();
        cell.setCid(column.getId());
        cell.setValue(value);
        row.getCell().add(cell);
    }

    private void addJobToTable(TableType table, String oid, JobStatusData status) {
        RowType row = new RowType();
        row.setOid(oid);
        for (ColumnType column : table.getColumn()) {
            if (column.getName().equals("step")) {
                this.addCellToRow(row, column, status.getJobId());
                continue;
            }
            if (column.getName().equals("status")) {
                this.addCellToRow(row, column, status.getState());
                continue;
            }
            if (column.getName().equals("owner")) {
                this.addCellToRow(row, column, status.getOwner());
                continue;
            }
            if (!column.getName().equals("queue")) continue;
            this.addCellToRow(row, column, status.getQueueName());
        }
        table.getRow().add(row);
    }

    private void checkTables() {
        if (this.getTableHandler().getTable("joblistrun") == null) {
            this.getTableHandler().generateDefaultTable("joblistrun");
        }
        if (this.getTableHandler().getTable("joblistwait") == null) {
            this.getTableHandler().generateDefaultTable("joblistwait");
        }
    }

    private boolean cidSet() {
        for (TableType table : this.getTableHandler().getTables()) {
            for (RowType row : table.getRow()) {
                for (CellType cell : row.getCell()) {
                    if (cell.getCid() != null) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void createLguiHandlers() {
        this.lguiHandlers.put(OverviewAccess.class, new OverviewAccess(this, this.lgui));
        this.lguiHandlers.put(LayoutAccess.class, new LayoutAccess(this, this.lgui));
        this.lguiHandlers.put(OIDToObject.class, new OIDToObject(this, this.lgui));
        this.lguiHandlers.put(ObjectStatus.class, new ObjectStatus(this, this.lgui));
        this.lguiHandlers.put(OIDToInformation.class, new OIDToInformation(this, this.lgui));
        this.lguiHandlers.put(TableHandler.class, new TableHandler(this, this.lgui));
        this.lguiHandlers.put(NodedisplayAccess.class, new NodedisplayAccess(this, this.lgui));
    }

    private void fireUpdatedEvent() {
        LguiUpdatedEvent e = new LguiUpdatedEvent(this, this.lgui);
        for (ILguiListener listener : this.listeners) {
            listener.handleEvent(e);
        }
    }

    private LguiType firstRequest() {
        ObjectFactory objectFactory = new ObjectFactory();
        LguiType layoutLgui = objectFactory.createLguiType();
        layoutLgui.setVersion("1");
        layoutLgui.setLayout(true);
        RequestType request = objectFactory.createRequestType();
        request.setGetDefaultData(true);
        layoutLgui.setRequest(request);
        return layoutLgui;
    }

    private String generateOid() {
        return UUID.randomUUID().toString();
    }

    private String getGidFromJobStatus(JobStatusData status) {
        if (status.getState().equals("RUNNING")) {
            return "joblistrun";
        }
        return "joblistwait";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LguiType parseLML(InputStream stream) throws JAXBException {
        Unmarshaller unmarshaller = LMLCorePlugin.getDefault().getUnmarshaller();
        Class<LguiItem> clazz = LguiItem.class;
        synchronized (LguiItem.class) {
            JAXBElement doc = (JAXBElement)unmarshaller.unmarshal(stream);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return (LguiType)doc.getValue();
        }
    }

    private void setCid() {
        for (TableType table : this.getTableHandler().getTables()) {
            for (RowType row : table.getRow()) {
                int cid = 1;
                for (CellType cell : row.getCell()) {
                    if (cell.getCid() == null) {
                        cell.setCid(BigInteger.valueOf(cid));
                    } else {
                        cid = cell.getCid().intValue();
                    }
                    ++cid;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateJobData() {
        TableType table2;
        HashSet<JobStatusData> jobsInTable = new HashSet<JobStatusData>();
        ArrayList<String> oidsToRemove = new ArrayList<String>();
        for (InformationType information : this.getOverviewAccess().getInformations()) {
            for (InfoType info : information.getInfo()) {
                JobStatusData status;
                String jobId = this.getOverviewAccess().getInfodataValue(info, "step");
                if (jobId == null || (status = this.fJobMap.get(jobId)) == null) continue;
                if (!status.isRemoved() && !status.isCompleted()) {
                    status.setOid(info.getOid());
                    status.setState(this.getOverviewAccess().getInfodataValue(info, "status"));
                    jobsInTable.add(status);
                    continue;
                }
                oidsToRemove.add(info.getOid());
            }
        }
        for (TableType table2 : this.getTableHandler().getTables()) {
            for (String row : oidsToRemove) {
                table2.getRow().remove(row);
            }
            oidsToRemove.clear();
        }
        this.checkTables();
        table2 = this.getTableHandler().getTable("joblistwait");
        if (table2 == null) {
            table2 = this.getTableHandler().generateDefaultTable("joblistwait");
        }
        Map<String, JobStatusData> map = this.fJobMap;
        synchronized (map) {
            for (JobStatusData status : this.fJobMap.values()) {
                if (status.isRemoved() || jobsInTable.contains(status)) continue;
                if (!status.isCompleted()) {
                    status.setState("COMPLETED");
                    status.setOid(this.generateOid());
                }
                this.addJobToTable(table2, status.getOid(), status);
            }
        }
    }
}

