/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control.ui.launch;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ptp.core.elements.IPQueue;
import org.eclipse.ptp.launch.ui.extensions.RMLaunchValidation;
import org.eclipse.ptp.rm.jaxb.control.ui.JAXBControlUIConstants;
import org.eclipse.ptp.rm.jaxb.control.ui.JAXBControlUIPlugin;
import org.eclipse.ptp.rm.jaxb.control.ui.launch.AbstractJAXBLaunchConfigurationTab;
import org.eclipse.ptp.rm.jaxb.control.ui.launch.JAXBControllerLaunchConfigurationTab;
import org.eclipse.ptp.rm.jaxb.control.ui.messages.Messages;
import org.eclipse.ptp.rm.jaxb.control.ui.utils.WidgetActionUtils;
import org.eclipse.ptp.rm.jaxb.core.IJAXBResourceManager;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.ptp.rm.jaxb.ui.util.WidgetBuilderUtils;
import org.eclipse.ptp.rmsystem.IResourceManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class JAXBImportedScriptLaunchConfigurationTab
extends AbstractJAXBLaunchConfigurationTab
implements SelectionListener,
ModifyListener {
    private Text choice;
    private Text editor;
    private Text stdoutText;
    private Text stderrText;
    private Button browseWorkspace;
    private Button clear;
    private Button enableFetchStdout;
    private Button enableFetchStderr;
    private String selected;
    private String stdoutPath;
    private String stderrPath;
    private final StringBuffer contents;

    public JAXBImportedScriptLaunchConfigurationTab(IJAXBResourceManager rm, ILaunchConfigurationDialog dialog, String title, JAXBControllerLaunchConfigurationTab parentTab) {
        super(parentTab, dialog);
        if (title != null) {
            this.title = title;
        }
        this.stdoutPath = "";
        this.stderrPath = "";
        this.contents = new StringBuffer();
    }

    public RMLaunchValidation canSave(Control control, IResourceManager rm, IPQueue queue) {
        return new RMLaunchValidation(true, null);
    }

    public void createControl(final Composite parent, IResourceManager rm, IPQueue queue) throws CoreException {
        this.control = WidgetBuilderUtils.createComposite((Composite)parent, (Integer)1);
        GridLayout layout = WidgetBuilderUtils.createGridLayout((Integer)6, (Boolean)false);
        GridData gd = WidgetBuilderUtils.createGridData((Integer)768, (Boolean)false, (Boolean)false, (Integer)600, (Integer)-1, (Integer)6, (Integer)-1);
        Group comp = WidgetBuilderUtils.createGroup((Composite)this.control, (Integer)0, (Layout)layout, (Object)gd);
        this.maybeAddPathControls(this.control, ((IJAXBResourceManager)rm).getControl().getEnvironment());
        WidgetBuilderUtils.createLabel((Composite)comp, (String)Messages.BatchScriptPath, (Integer)16384, (Integer)1);
        WidgetBuilderUtils.createLabel((Composite)comp, (String)"", (Integer)16384, (Integer)1);
        GridData gdsub = WidgetBuilderUtils.createGridData((Integer)768, (Boolean)true, (Boolean)false, (Integer)310, (Integer)-1, (Integer)2, (Integer)-1);
        String s = this.selected == null ? "" : this.selected.toString();
        this.choice = WidgetBuilderUtils.createText((Composite)comp, (Integer)2048, (Object)gdsub, (Boolean)true, (String)s);
        this.browseWorkspace = WidgetBuilderUtils.createPushButton((Composite)comp, (String)Messages.JAXBRMConfigurationSelectionWizardPage_1, (SelectionListener)this);
        this.clear = WidgetBuilderUtils.createPushButton((Composite)comp, (String)Messages.ClearScript, (SelectionListener)this);
        layout = WidgetBuilderUtils.createGridLayout((Integer)1, (Boolean)true);
        Group grp = WidgetBuilderUtils.createGroup((Composite)this.control, (Integer)0, (Layout)layout, null);
        int style = 2818;
        gdsub = WidgetBuilderUtils.createGridDataFill((Integer)600, (Integer)400, (Integer)1);
        this.editor = WidgetBuilderUtils.createText((Composite)grp, (Integer)style, (Object)gdsub, (Boolean)true, (String)"", null, null);
        WidgetBuilderUtils.applyMonospace((Text)this.editor);
        this.editor.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                MessageDialog.openWarning((Shell)parent.getShell(), (String)Messages.ReadOnlyWarning_title, (String)Messages.ReadOnlyWarning);
            }
        });
        this.size = this.control.computeSize(-1, -1, true);
        this.selected = null;
        this.updateControls();
    }

    protected void doRefreshLocal() {
        if (this.selected != null) {
            this.localMap.put("script_path", this.selected);
        }
        this.maybeRefreshPaths();
    }

    public Control getControl() {
        return this.control;
    }

    public Image getImage() {
        return null;
    }

    public String getText() {
        return this.title;
    }

    public RMLaunchValidation initializeFrom(Control control, IResourceManager rm, IPQueue queue, ILaunchConfiguration configuration) {
        try {
            String uriStr = configuration.getAttribute("script_path", "");
            this.selected = !"".equals(uriStr) ? uriStr : null;
            this.uploadScript();
            this.maybeInitializePaths(configuration);
        }
        catch (Throwable t) {
            WidgetActionUtils.errorMessage(control.getShell(), t, Messages.ErrorOnLoadFromStore, Messages.ErrorOnLoadTitle, false);
        }
        return new RMLaunchValidation(true, null);
    }

    public RMLaunchValidation isValid(ILaunchConfiguration launchConfig, IResourceManager rm, IPQueue queue) {
        return new RMLaunchValidation(true, null);
    }

    private void maybeAddPathControls(Composite parent, IVariableMap env) throws CoreException {
        if (env == null) {
            return;
        }
        Object stdout = env.get("stdout_remote_path");
        Object stderr = env.get("stderr_remote_path");
        if (stdout == null && stderr == null) {
            return;
        }
        GridLayout layout = WidgetBuilderUtils.createGridLayout((Integer)4, (Boolean)false);
        GridData data = WidgetBuilderUtils.createGridData((Integer)768, (Boolean)false, (Boolean)false, (Integer)400, (Integer)-1, (Integer)4, (Integer)-1);
        Group group = WidgetBuilderUtils.createGroup((Composite)parent, (Integer)0, (Layout)layout, (Object)data);
        if (stdout != null) {
            Label l = WidgetBuilderUtils.createLabel((Composite)group, (String)Messages.RemoteScriptPath, (Integer)16384, (Integer)1);
            l.setToolTipText(Messages.RemotePathTooltip);
            data = WidgetBuilderUtils.createGridData((Integer)768, (Boolean)true, (Boolean)false, (Integer)175, (Integer)-1, (Integer)2, (Integer)-1);
            this.stdoutText = WidgetBuilderUtils.createText((Composite)group, (Integer)2048, (Object)data, (Boolean)false, (String)"");
            this.stdoutText.addModifyListener((ModifyListener)this);
            this.enableFetchStdout = WidgetBuilderUtils.createCheckButton((Composite)group, (String)Messages.EnableStdoutFetch, (SelectionListener)this);
        }
        if (stderr != null) {
            WidgetBuilderUtils.createLabel((Composite)group, (String)Messages.RemoteScriptPath, (Integer)16384, (Integer)1);
            data = WidgetBuilderUtils.createGridData((Integer)768, (Boolean)true, (Boolean)false, (Integer)175, (Integer)-1, (Integer)2, (Integer)-1);
            this.stderrText = WidgetBuilderUtils.createText((Composite)group, (Integer)2048, (Object)data, (Boolean)false, (String)"");
            this.stderrText.addModifyListener((ModifyListener)this);
            this.enableFetchStderr = WidgetBuilderUtils.createCheckButton((Composite)group, (String)Messages.EnableStderrFetch, (SelectionListener)this);
        }
    }

    private void maybeInitializePaths(ILaunchConfiguration configuration) {
        try {
            if (this.stdoutText != null) {
                this.stdoutPath = configuration.getAttribute("stdout_remote_path", "");
                if ("".equals(this.stdoutPath)) {
                    this.stdoutText.setText("");
                    this.stdoutText.setEnabled(false);
                    this.enableFetchStdout.setSelection(false);
                } else {
                    this.stdoutText.setText(this.stdoutPath);
                    this.stdoutText.setEnabled(true);
                    this.enableFetchStdout.setSelection(true);
                }
            }
            if (this.stderrText != null) {
                this.stderrPath = configuration.getAttribute("stderr_remote_path", "");
                if ("".equals(this.stderrPath)) {
                    this.stderrText.setText("");
                    this.stderrText.setEnabled(false);
                    this.enableFetchStderr.setSelection(false);
                } else {
                    this.stderrText.setText(this.stderrPath);
                    this.stderrText.setEnabled(true);
                    this.enableFetchStderr.setSelection(true);
                }
            }
        }
        catch (CoreException t) {
            JAXBControlUIPlugin.log(t);
        }
    }

    private void maybeRefreshPaths() {
        if ("".equals(this.stdoutPath)) {
            this.localMap.remove("stdout_remote_path");
        } else {
            this.localMap.put("stdout_remote_path", this.stdoutPath);
        }
        if ("".equals(this.stderrPath)) {
            this.localMap.remove("stderr_remote_path");
        } else {
            this.localMap.put("stderr_remote_path", this.stderrPath);
        }
    }

    public void modifyText(ModifyEvent e) {
        try {
            if (this.stdoutText == e.getSource()) {
                this.stdoutPath = this.stdoutText.getText().trim();
            } else if (this.stderrText == e.getSource()) {
                this.stderrPath = this.stderrText.getText().trim();
            }
            this.fireContentsChanged();
        }
        catch (Throwable t) {
            WidgetActionUtils.errorMessage(this.control.getShell(), t, Messages.ModifyError, Messages.ModifyErrorTitle, false);
        }
    }

    public RMLaunchValidation setDefaults(ILaunchConfigurationWorkingCopy configuration, IResourceManager rm, IPQueue queue) {
        return new RMLaunchValidation(true, null);
    }

    private void updateContents() throws Throwable {
        this.uploadScript();
        this.fireContentsChanged();
    }

    private void updateControls() {
        if (this.selected != null) {
            this.choice.setText(this.selected);
        } else {
            this.choice.setText("");
        }
        this.editor.setText(this.contents.toString());
        if ("".equals(this.contents)) {
            this.clear.setEnabled(false);
        } else {
            this.clear.setEnabled(true);
        }
    }

    private void uploadScript() throws Throwable {
        this.contents.setLength(0);
        if (this.selected != null) {
            BufferedReader br = new BufferedReader(new FileReader(new File(this.selected)));
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    this.contents.append(line).append(JAXBControlUIConstants.LINE_SEP);
                }
            }
            catch (EOFException eOFException) {}
        }
        this.updateControls();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        try {
            if (source == this.browseWorkspace) {
                this.selected = WidgetActionUtils.browseWorkspace(this.control.getShell());
                this.updateContents();
            } else if (source == this.clear) {
                this.selected = null;
                this.updateContents();
            } else if (source == this.enableFetchStdout) {
                boolean enabled = this.enableFetchStdout.getSelection();
                if (enabled) {
                    this.stdoutText.setText(this.stdoutPath);
                    this.stdoutText.setEnabled(true);
                } else {
                    this.stdoutText.setText("");
                    this.stdoutText.setEnabled(false);
                }
                this.fireContentsChanged();
            } else if (source == this.enableFetchStderr) {
                boolean enabled = this.enableFetchStderr.getSelection();
                if (enabled) {
                    this.stderrText.setText(this.stderrPath);
                    this.stderrText.setEnabled(true);
                } else {
                    this.stderrText.setText("");
                    this.stderrText.setEnabled(false);
                }
                this.fireContentsChanged();
            }
        }
        catch (Throwable t) {
            WidgetActionUtils.errorMessage(this.control.getShell(), t, Messages.WidgetSelectedError, Messages.WidgetSelectedErrorTitle, false);
        }
    }
}

