/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control.ui.model;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.ptp.rm.jaxb.control.ui.ICellEditorUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.cell.SpinnerCellEditor;
import org.eclipse.ptp.rm.jaxb.control.ui.handlers.ValueUpdateHandler;
import org.eclipse.ptp.rm.jaxb.control.ui.model.AbstractUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.model.ViewerUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.variables.LCVariableMap;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public abstract class CellEditorUpdateModel
extends AbstractUpdateModel
implements ICellEditorUpdateModel {
    protected boolean readOnly;
    protected String tooltip;
    protected String description;
    protected String status;
    protected Color[] foreground;
    protected Color[] background;
    protected Font[] font;
    protected CellEditor editor;
    protected ViewerUpdateModel viewer;
    protected String stringValue;
    protected int index;
    protected String[] items;
    protected boolean booleanValue;
    protected int integerValue;

    protected CellEditorUpdateModel(String name, ValueUpdateHandler handler, CellEditor editor, String[] items, boolean readOnly, String tooltip, String description, String status) {
        super(name, handler);
        this.editor = editor;
        this.readOnly = readOnly;
        this.items = items;
        this.tooltip = tooltip;
        this.description = description;
        this.status = status;
    }

    public boolean canEdit() {
        return this.isChecked() && (!(this.editor instanceof TextCellEditor) || !this.readOnly);
    }

    public Color getBackground(Object element, int columnIndex) {
        if (this.background == null) {
            return null;
        }
        return this.background[columnIndex];
    }

    public CellEditor getCellEditor() {
        return this.editor;
    }

    public Image getColumnImage(String columnName) {
        return null;
    }

    public Object getControl() {
        return this.editor;
    }

    public String getDescription() {
        return this.description;
    }

    public Font getFont(Object element, int columnIndex) {
        if (this.font == null) {
            return null;
        }
        return this.font[columnIndex];
    }

    public Color getForeground(Object element, int columnIndex) {
        if (this.foreground == null) {
            return null;
        }
        return this.foreground[columnIndex];
    }

    public String getReplacedValue(String pattern) {
        if (!this.isChecked()) {
            return "";
        }
        String value = this.getValueAsString();
        if ("".equals(value)) {
            return "";
        }
        String result = CellEditorUpdateModel.replaceAll(pattern, "@name", this.name);
        return CellEditorUpdateModel.replaceAll(result, "@value", value);
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public String getType() {
        if (this.editor instanceof CheckboxCellEditor) {
            return Boolean.TYPE.getCanonicalName();
        }
        if (this.editor instanceof SpinnerCellEditor) {
            return Integer.TYPE.getCanonicalName();
        }
        return "string";
    }

    public Object getValueForEditor() {
        if (this.editor instanceof TextCellEditor) {
            return this.stringValue;
        }
        if (this.editor instanceof CheckboxCellEditor) {
            return this.booleanValue;
        }
        if (this.editor instanceof SpinnerCellEditor) {
            return this.integerValue;
        }
        if (this.editor instanceof ComboBoxCellEditor) {
            return this.index;
        }
        return null;
    }

    public Object getValueFromControl() {
        return this.mapValue;
    }

    public void initialize(LCVariableMap lcMap) {
        super.initialize(lcMap);
        this.lcMap = lcMap;
    }

    public boolean isChecked() {
        return ((ICheckable)this.viewer.getControl()).getChecked((Object)this);
    }

    public void refreshValueFromMap() {
        this.refreshing = true;
        this.mapValue = this.lcMap.get(this.name);
        if (this.editor instanceof TextCellEditor) {
            this.stringValue = "";
            if (this.mapValue != null) {
                this.stringValue = (String)this.mapValue;
            }
        } else if (this.editor instanceof CheckboxCellEditor) {
            this.booleanValue = false;
            if (this.mapValue != null) {
                this.booleanValue = this.mapValue instanceof String ? Boolean.parseBoolean((String)this.mapValue) : (Boolean)this.mapValue;
            }
        } else if (this.editor instanceof SpinnerCellEditor) {
            SpinnerCellEditor e = (SpinnerCellEditor)this.editor;
            this.integerValue = e.getMin();
            if (this.mapValue != null) {
                this.integerValue = this.mapValue instanceof String ? Integer.parseInt((String)this.mapValue) : (Integer)this.mapValue;
            }
        } else if (this.editor instanceof ComboBoxCellEditor) {
            if (this.mapValue == null) {
                this.index = -1;
                this.stringValue = "";
            } else {
                this.stringValue = (String)this.mapValue;
                int i = 0;
                while (i < this.items.length) {
                    if (this.items[i].equals(this.stringValue)) {
                        this.index = i;
                        break;
                    }
                    ++i;
                }
                if (this.index == this.items.length) {
                    this.index = -1;
                    this.stringValue = "";
                }
            }
        }
        this.refreshing = false;
    }

    public void setBackground(Color[] background) {
        this.background = background;
    }

    public void setFont(Font[] font) {
        this.font = font;
    }

    public void setForeground(Color[] foreground) {
        this.foreground = foreground;
    }

    public void setValueFromEditor(Object value) {
        if (this.editor instanceof TextCellEditor) {
            this.stringValue = "";
            if (value != null) {
                this.stringValue = (String)value;
            }
            this.mapValue = this.stringValue;
        } else if (this.editor instanceof CheckboxCellEditor) {
            this.booleanValue = value == null ? false : (Boolean)value;
            this.mapValue = this.booleanValue;
        } else if (this.editor instanceof SpinnerCellEditor) {
            SpinnerCellEditor e = (SpinnerCellEditor)this.editor;
            this.integerValue = value == null ? e.getMin() : ((Integer)value).intValue();
            this.mapValue = this.integerValue;
        } else if (this.editor instanceof ComboBoxCellEditor) {
            if (value == null || (Integer)value == -1) {
                this.index = -1;
                this.stringValue = "";
            } else {
                this.index = (Integer)value;
                this.stringValue = this.items[this.index];
            }
            this.mapValue = this.stringValue;
        }
        Object v = this.storeValue();
        this.viewer.storeValue();
        this.handleUpdate(v);
    }

    public void setViewer(ViewerUpdateModel viewer) {
        this.viewer = viewer;
    }

    protected String getValueAsString() {
        if (this.editor instanceof TextCellEditor || this.editor instanceof ComboBoxCellEditor) {
            return this.stringValue;
        }
        if (this.editor instanceof CheckboxCellEditor) {
            return String.valueOf(this.booleanValue);
        }
        if (this.editor instanceof SpinnerCellEditor) {
            return String.valueOf(this.integerValue);
        }
        return "";
    }

    private static String replaceAll(String sequence, String tag, String with) {
        int i = 0;
        int j = 0;
        int ln = sequence.length();
        StringBuffer buffer = new StringBuffer();
        while (i < ln) {
            j = sequence.indexOf(tag, i);
            if (j < 0) {
                j = ln;
                break;
            }
            buffer.append(sequence.substring(i, j)).append(with);
            i = j + tag.length();
        }
        buffer.append(sequence.substring(i, j));
        return buffer.toString();
    }
}

