/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control.ui.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ptp.rm.jaxb.control.ui.ICellEditorUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.JAXBControlUIPlugin;
import org.eclipse.ptp.rm.jaxb.control.ui.handlers.ValueUpdateHandler;
import org.eclipse.ptp.rm.jaxb.control.ui.model.AbstractUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.model.InfoTreeNodeModel;
import org.eclipse.ptp.rm.jaxb.control.ui.model.ValueTreeNodeUpdateModel;
import org.eclipse.ptp.rm.jaxb.core.data.TemplateType;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewerUpdateModel
extends AbstractUpdateModel
implements ICheckStateListener,
IDoubleClickListener,
SelectionListener {
    private final StringBuffer checked;
    private final StringBuffer templatedValue;
    private final String pattern;
    private final String separator;
    private final ICheckable viewer;
    private final ColumnViewer columnViewer;
    private Button showOnlySelected;
    private final ViewerFilter filter = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof ICellEditorUpdateModel) {
                return ((ICheckable)viewer).getChecked(element);
            }
            if (element instanceof InfoTreeNodeModel) {
                ValueTreeNodeUpdateModel parent = ((InfoTreeNodeModel)element).getParent();
                return ((ICheckable)viewer).getChecked((Object)parent);
            }
            return false;
        }
    };

    public ViewerUpdateModel(String name, ValueUpdateHandler handler, ICheckable viewer, TemplateType template) {
        super(name, handler);
        this.viewer = viewer;
        this.columnViewer = (ColumnViewer)viewer;
        this.pattern = template.getPattern();
        String s = template.getSeparator();
        this.separator = s == null ? "" : s;
        this.checked = new StringBuffer();
        this.templatedValue = new StringBuffer();
        viewer.addCheckStateListener((ICheckStateListener)this);
        this.columnViewer.addDoubleClickListener((IDoubleClickListener)this);
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        Object target = event.getElement();
        if (!(target instanceof ICellEditorUpdateModel)) {
            this.viewer.setChecked(target, false);
        } else if (!this.viewer.getChecked(target)) {
            this.lcMap.remove(((ICellEditorUpdateModel)target).getName());
        }
        this.storeValue();
        this.handleUpdate(null);
    }

    public void doubleClick(DoubleClickEvent event) {
        ArrayList<CheckStateChangedEvent> csEvents = new ArrayList<CheckStateChangedEvent>();
        try {
            IStructuredSelection selection = (IStructuredSelection)((ColumnViewer)this.viewer).getSelection();
            List selected = selection.toList();
            if (!selected.isEmpty()) {
                for (Object o : selected) {
                    boolean checked = this.viewer.getChecked(o);
                    if (o instanceof ICellEditorUpdateModel) {
                        ICellEditorUpdateModel model = (ICellEditorUpdateModel)o;
                        this.viewer.setChecked((Object)model, !checked);
                    } else {
                        this.viewer.setChecked(o, false);
                    }
                    csEvents.add(new CheckStateChangedEvent(this.viewer, o, !checked));
                }
            }
        }
        catch (Throwable t) {
            JAXBControlUIPlugin.log(t);
        }
        for (CheckStateChangedEvent e : csEvents) {
            this.checkStateChanged(e);
        }
    }

    @Override
    public Object getControl() {
        return this.viewer;
    }

    @Override
    public Object getValueFromControl() {
        return this.mapValue;
    }

    public void initializeChecked() throws CoreException {
        Map<String, String> allChecked = this.lcMap.getChecked(this.name);
        Collection input = (Collection)((Viewer)this.viewer).getInput();
        for (Object o : input) {
            boolean checked = false;
            if (o instanceof ICellEditorUpdateModel) {
                ICellEditorUpdateModel model = (ICellEditorUpdateModel)o;
                checked = allChecked.isEmpty() ? true : allChecked.containsKey(model.getName());
                this.viewer.setChecked((Object)model, checked);
                continue;
            }
            this.viewer.setChecked(o, false);
        }
        Boolean b = (Boolean)this.lcMap.get("show_only_checked" + this.name);
        if (b == null) {
            b = false;
        }
        this.showOnlySelected.setSelection(b.booleanValue());
        if (b.booleanValue()) {
            this.columnViewer.addFilter(this.filter);
        }
        this.storeValue();
        this.handleUpdate(null);
    }

    public void putCheckedSettings(Map<String, Object> localMap) {
        this.checked.setLength(0);
        Collection input = (Collection)((Viewer)this.viewer).getInput();
        for (Object o : input) {
            ICellEditorUpdateModel model;
            if (!(o instanceof ICellEditorUpdateModel) || !(model = (ICellEditorUpdateModel)o).isChecked()) continue;
            this.checked.append(model.getName()).append(" ");
        }
        localMap.put("checked_attributes" + this.name, this.checked.toString().trim());
        localMap.put("show_only_checked" + this.name, this.showOnlySelected.getSelection());
    }

    @Override
    public void refreshValueFromMap() {
    }

    public void setShowAll(Button showOnlySelected) {
        this.showOnlySelected = showOnlySelected;
    }

    @Override
    public Object storeValue() {
        this.templatedValue.setLength(0);
        Collection input = (Collection)((Viewer)this.viewer).getInput();
        for (Object o : input) {
            ICellEditorUpdateModel model;
            String replaced;
            if (!(o instanceof ICellEditorUpdateModel) || "".equals(replaced = (model = (ICellEditorUpdateModel)o).getReplacedValue(this.pattern))) continue;
            this.templatedValue.append(this.separator).append(replaced);
        }
        this.templatedValue.delete(0, this.separator.length());
        String t = this.templatedValue.toString().trim();
        if (!"".equals(t)) {
            t = this.lcMap.getString(t);
            this.lcMap.put(this.name, t);
        } else {
            this.lcMap.remove(this.name);
        }
        this.mapValue = t;
        return t;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.showOnlySelected.getSelection()) {
            this.columnViewer.addFilter(this.filter);
        } else {
            this.columnViewer.removeFilter(this.filter);
        }
        this.storeValue();
        this.handleUpdate(null);
    }
}

