/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control.ui.utils;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ptp.remote.core.RemoteServicesDelegate;
import org.eclipse.ptp.remote.ui.RemoteUIServicesUtils;
import org.eclipse.ptp.rm.jaxb.control.ui.ICellEditorUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.IUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.JAXBControlUIPlugin;
import org.eclipse.ptp.rm.jaxb.control.ui.cell.SpinnerCellEditor;
import org.eclipse.ptp.rm.jaxb.control.ui.handlers.ValueUpdateHandler;
import org.eclipse.ptp.rm.jaxb.control.ui.launch.JAXBControllerLaunchConfigurationTab;
import org.eclipse.ptp.rm.jaxb.control.ui.launch.JAXBDynamicLaunchConfigurationTab;
import org.eclipse.ptp.rm.jaxb.control.ui.model.AbstractUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.model.ButtonGroupUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.model.ButtonUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.model.ComboUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.model.SpinnerUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.model.TableRowUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.model.TextUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.model.ValueTreeNodeUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.model.ViewerUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.utils.LaunchTabBuilder;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.ptp.rm.jaxb.core.data.AttributeType;
import org.eclipse.ptp.rm.jaxb.core.data.AttributeViewerType;
import org.eclipse.ptp.rm.jaxb.core.data.ButtonGroupType;
import org.eclipse.ptp.rm.jaxb.core.data.ColumnDataType;
import org.eclipse.ptp.rm.jaxb.core.data.FontType;
import org.eclipse.ptp.rm.jaxb.core.data.LayoutDataType;
import org.eclipse.ptp.rm.jaxb.core.data.PropertyType;
import org.eclipse.ptp.rm.jaxb.core.data.TemplateType;
import org.eclipse.ptp.rm.jaxb.core.data.WidgetType;
import org.eclipse.ptp.rm.jaxb.ui.util.WidgetBuilderUtils;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateModelFactory {
    public static IUpdateModel createModel(ButtonGroupType bGroupDescriptor, Composite bGroup, JAXBDynamicLaunchConfigurationTab tab, IVariableMap rmVarMap) {
        List bWidgets = bGroupDescriptor.getButton();
        ArrayList<Button> buttons = new ArrayList<Button>();
        for (WidgetType widget : bWidgets) {
            ControlDescriptor cd = new ControlDescriptor(widget, rmVarMap);
            Control control = UpdateModelFactory.createControl(bGroup, cd, tab);
            if (!(control instanceof Button)) continue;
            buttons.add((Button)control);
        }
        String name = bGroupDescriptor.getSaveValueTo();
        ValueUpdateHandler handler = tab.getParent().getUpdateHandler();
        return new ButtonGroupUpdateModel(name, handler, bGroup, buttons);
    }

    public static ViewerUpdateModel createModel(ColumnViewer viewer, AttributeViewerType descriptor, JAXBDynamicLaunchConfigurationTab tab) {
        String name = descriptor.getName();
        TemplateType template = descriptor.getValue();
        ValueUpdateHandler handler = tab.getParent().getUpdateHandler();
        return new ViewerUpdateModel(name, handler, (ICheckable)viewer, template);
    }

    public static IUpdateModel createModel(Composite parent, WidgetType widget, JAXBDynamicLaunchConfigurationTab tab, IVariableMap rmVarMap) {
        ControlDescriptor cd = new ControlDescriptor(widget, rmVarMap);
        Control control = UpdateModelFactory.createControl(parent, cd, tab);
        if (control instanceof Label) {
            return null;
        }
        String name = widget.getSaveValueTo();
        List dynamic = null;
        WidgetType.DynamicText dt = widget.getDynamicText();
        if (dt != null) {
            dynamic = dt.getArg();
        }
        ValueUpdateHandler handler = tab.getParent().getUpdateHandler();
        AbstractUpdateModel model = null;
        if (control instanceof Text) {
            if (name != null && !"".equals(name)) {
                model = new TextUpdateModel(name, handler, (Text)control);
            }
            if (dynamic != null) {
                model = new TextUpdateModel(dynamic, handler, (Text)control);
            }
        } else if (control instanceof Combo) {
            model = new ComboUpdateModel(name, handler, (Combo)control);
        } else if (control instanceof Spinner) {
            model = new SpinnerUpdateModel(name, handler, (Spinner)control);
        } else if (control instanceof Button) {
            model = new ButtonUpdateModel(name, handler, (Button)control, widget.getTranslateBooleanAs());
        }
        if (name != null && !"".equals(name)) {
            UpdateModelFactory.maybeAddValidator(model, rmVarMap.get(name), tab.getParent());
        }
        return model;
    }

    public static ICellEditorUpdateModel createModel(Object data, ColumnViewer viewer, List<ColumnDataType> columnData, JAXBDynamicLaunchConfigurationTab tab) {
        ICellEditorUpdateModel model = null;
        model = viewer instanceof TableViewer ? UpdateModelFactory.createModel(data, (TableViewer)viewer, columnData, tab) : UpdateModelFactory.createModel(data, (TreeViewer)viewer, columnData, tab);
        UpdateModelFactory.maybeAddValidator(model, data, tab.getParent());
        return model;
    }

    private static Text createBrowse(final Composite parent, final ControlDescriptor cd, final JAXBDynamicLaunchConfigurationTab tab) {
        final Text t = WidgetBuilderUtils.createText((Composite)parent, (Integer)cd.style, (Object)cd.layoutData, (Boolean)cd.readOnly, (String)"");
        WidgetBuilderUtils.createButton((Composite)parent, (Object)cd.subLayoutData, (String)cd.title, (Integer)8, (SelectionListener)new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                try {
                    String initial = t.getText();
                    URI uri = null;
                    uri = "".equals(initial) ? tab.getParent().getDelegate().getRemoteHome() : new URI(initial);
                    uri = RemoteUIServicesUtils.browse((Shell)parent.getShell(), (URI)uri, (RemoteServicesDelegate)tab.getParent().getDelegate(), (!cd.localOnly ? 1 : 0) != 0, (boolean)cd.readOnly, (boolean)cd.directory);
                    if (uri != null) {
                        if (cd.returnUri) {
                            t.setText(uri.toString());
                        } else {
                            t.setText(uri.getPath());
                        }
                    } else {
                        t.setText("");
                    }
                }
                catch (Throwable t2) {
                    JAXBControlUIPlugin.log(t2);
                }
            }
        });
        return t;
    }

    private static Combo createCombo(Composite parent, ControlDescriptor cd) {
        String[] items = null;
        if (cd.valueList != null) {
            items = cd.valueList.toArray(new String[0]);
        } else if (cd.choice != null) {
            items = cd.choice.split(",");
        }
        if (items == null) {
            items = new String[]{};
        } else if (items.length > 0) {
            items = WidgetBuilderUtils.normalizeComboItems((String[])items);
        }
        return WidgetBuilderUtils.createCombo((Composite)parent, (Integer)cd.style, (Object)cd.layoutData, (String[])items, (String)"", (String)cd.title, (String)cd.tooltip, null);
    }

    private static Control createControl(Composite parent, ControlDescriptor cd, JAXBDynamicLaunchConfigurationTab tab) {
        Text c = null;
        if ("label".equals(cd.widgetType)) {
            c = WidgetBuilderUtils.createLabel((Composite)parent, (String)cd.fixedText, (Integer)cd.style, (Object)cd.layoutData);
        } else if ("text".equals(cd.widgetType)) {
            c = UpdateModelFactory.createText(parent, cd);
        } else if ("radiobutton".equals(cd.widgetType)) {
            if (cd.style == 0) {
                cd.style = 16400;
            }
            c = WidgetBuilderUtils.createRadioButton((Composite)parent, (int)cd.style, (String)cd.title, null, null);
        } else if ("checkbox".equals(cd.widgetType)) {
            c = WidgetBuilderUtils.createCheckButton((Composite)parent, (String)cd.title, null);
        } else if ("spinner".equals(cd.widgetType)) {
            c = WidgetBuilderUtils.createSpinner((Composite)parent, (Object)cd.layoutData, (String)cd.title, (Integer)cd.min, (Integer)cd.max, (Integer)cd.min, null);
        } else if ("combo".equals(cd.widgetType)) {
            c = UpdateModelFactory.createCombo(parent, cd);
        } else if ("browse".equals(cd.widgetType)) {
            c = UpdateModelFactory.createBrowse(parent, cd, tab);
        }
        if (c != null) {
            if (!"".equals(cd.tooltip)) {
                c.setToolTipText(cd.tooltip);
            }
            if (cd.foreground != null) {
                c.setForeground(WidgetBuilderUtils.getColor((String)cd.foreground));
            }
            if (cd.background != null) {
                c.setBackground(WidgetBuilderUtils.getColor((String)cd.background));
            }
            if (cd.font != null) {
                c.setFont(WidgetBuilderUtils.getFont((FontType)cd.font));
            }
        }
        return c;
    }

    private static CellEditor createEditor(CellDescriptor cd, Object data, Composite parent) {
        Object editor = null;
        if (cd.type == CellEditorType.TEXT) {
            editor = new TextCellEditor(parent);
        } else if (cd.type == CellEditorType.CHECK) {
            editor = new CheckboxCellEditor(parent);
        } else if (cd.type == CellEditorType.SPINNER) {
            editor = new SpinnerCellEditor(parent, cd.min, cd.max);
        } else if (cd.type == CellEditorType.COMBO) {
            Object o = null;
            if (data instanceof AttributeType) {
                if (cd.choice != null) {
                    cd.choice = cd.choice.trim();
                    cd.items = cd.choice.split(",");
                } else {
                    o = ((AttributeType)data).getValue();
                }
            } else {
                o = ((PropertyType)data).getValue();
            }
            if (cd.items == null) {
                if (o instanceof Collection) {
                    cd.items = ((Collection)o).toArray(new String[0]);
                } else {
                    cd.items = new String[0];
                }
            }
            editor = new ComboBoxCellEditor(parent, cd.items, 8);
        }
        return editor;
    }

    private static ICellEditorUpdateModel createModel(Object data, TableViewer viewer, List<ColumnDataType> columnData, JAXBDynamicLaunchConfigurationTab tab) {
        CellDescriptor cd = new CellDescriptor(data, columnData);
        CellEditor editor = UpdateModelFactory.createEditor(cd, data, (Composite)viewer.getTable());
        ValueUpdateHandler handler = tab.getParent().getUpdateHandler();
        ICellEditorUpdateModel model = null;
        if (data instanceof AttributeType) {
            model = new TableRowUpdateModel(cd.name, handler, editor, cd.items, cd.readOnly, (AttributeType)data);
        } else if (data instanceof PropertyType) {
            model = new TableRowUpdateModel(cd.name, handler, editor, cd.items, cd.readOnly);
        }
        if (model != null) {
            model.setBackground(cd.background);
            model.setFont(cd.font);
            model.setForeground(cd.foreground);
        }
        return model;
    }

    private static ICellEditorUpdateModel createModel(Object data, TreeViewer viewer, List<ColumnDataType> columnData, JAXBDynamicLaunchConfigurationTab tab) {
        boolean inValueCol;
        CellDescriptor cd = new CellDescriptor(data, columnData);
        CellEditor editor = UpdateModelFactory.createEditor(cd, data, (Composite)viewer.getTree());
        ValueUpdateHandler handler = tab.getParent().getUpdateHandler();
        ICellEditorUpdateModel model = null;
        Object[] properties = viewer.getColumnProperties();
        boolean bl = inValueCol = properties.length == 2;
        if (data instanceof AttributeType) {
            model = new ValueTreeNodeUpdateModel(cd.name, handler, editor, cd.items, cd.readOnly, inValueCol, (AttributeType)data);
        } else if (data instanceof PropertyType) {
            model = new ValueTreeNodeUpdateModel(cd.name, handler, editor, cd.items, cd.readOnly, inValueCol);
        }
        if (model != null) {
            model.setBackground(cd.background);
            model.setFont(cd.font);
            model.setForeground(cd.foreground);
        }
        return model;
    }

    private static Text createText(Composite parent, ControlDescriptor cd) {
        return WidgetBuilderUtils.createText((Composite)parent, (Integer)cd.style, (Object)cd.layoutData, (Boolean)cd.readOnly, (String)"");
    }

    private static void maybeAddValidator(IUpdateModel model, Object data, JAXBControllerLaunchConfigurationTab tab) {
        if (data != null && data instanceof AttributeType) {
            model.setValidator(((AttributeType)data).getValidator(), tab);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CellDescriptor {
        private String name;
        private String tooltip;
        private String description;
        private String choice;
        private Integer min;
        private Integer max;
        private boolean readOnly;
        private final CellEditorType type;
        private String[] items;
        protected Color[] foreground;
        protected Color[] background;
        protected Font[] font;

        private CellDescriptor(Object data, List<ColumnDataType> columnData) {
            this.type = CellEditorType.getType(data);
            if (data instanceof AttributeType) {
                AttributeType a = (AttributeType)data;
                this.name = a.getName();
                this.choice = a.getChoice();
                this.min = a.getMin();
                this.max = a.getMax();
                this.readOnly = a.isReadOnly();
                this.tooltip = a.getTooltip();
                this.tooltip = this.tooltip == null ? "" : WidgetBuilderUtils.removeTabOrLineBreak((String)this.tooltip);
                this.description = a.getDescription();
            } else if (data instanceof PropertyType) {
                PropertyType p = (PropertyType)data;
                this.name = p.getName();
                this.readOnly = p.isReadOnly();
            }
            if (this.description == null) {
                this.description = "";
            }
            int cols = columnData.size();
            this.foreground = new Color[cols];
            this.background = new Color[cols];
            this.font = new Font[cols];
            int i = 0;
            while (i < columnData.size()) {
                String attr = columnData.get(i).getForeground();
                this.foreground[i] = attr != null ? WidgetBuilderUtils.getColor((String)attr) : null;
                attr = columnData.get(i).getBackground();
                this.background[i] = attr != null ? WidgetBuilderUtils.getColor((String)attr) : null;
                FontType fd = columnData.get(i).getFont();
                this.font[i] = fd != null ? WidgetBuilderUtils.getFont((FontType)fd) : null;
                ++i;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CellEditorType {
        TEXT,
        COMBO,
        SPINNER,
        CHECK;


        public static CellEditorType getType(Object object) {
            if (object instanceof PropertyType) {
                PropertyType p = (PropertyType)object;
                Object value = p.getValue();
                String clzz = p.getType();
                if (clzz != null) {
                    return CellEditorType.getTypeFromClass(clzz);
                }
                if (value != null) {
                    return CellEditorType.getType(value);
                }
                return TEXT;
            }
            if (object instanceof AttributeType) {
                AttributeType a = (AttributeType)object;
                if (a.getChoice() != null) {
                    return COMBO;
                }
                String clzz = a.getType();
                if (clzz != null) {
                    return CellEditorType.getTypeFromClass(clzz);
                }
                Object value = a.getValue();
                if (value != null) {
                    return CellEditorType.getType(value);
                }
                return TEXT;
            }
            if (object instanceof Collection) {
                return COMBO;
            }
            if (object instanceof Integer) {
                return SPINNER;
            }
            if (object instanceof Boolean) {
                return CHECK;
            }
            return TEXT;
        }

        private static CellEditorType getTypeFromClass(String clzz) {
            if (clzz.indexOf("nt") > 0) {
                return SPINNER;
            }
            if (clzz.indexOf("bool") >= 0) {
                return CHECK;
            }
            if (clzz.indexOf("ist") > 0) {
                return COMBO;
            }
            if (clzz.indexOf("et") > 0) {
                return COMBO;
            }
            if (clzz.indexOf("ector") > 0) {
                return COMBO;
            }
            return TEXT;
        }
    }

    private static class ControlDescriptor {
        private String widgetType;
        private String title;
        private Object layoutData;
        private Object subLayoutData;
        private boolean readOnly;
        private boolean localOnly;
        private boolean directory;
        private boolean returnUri;
        private int style;
        private String background;
        private String foreground;
        private FontType font;
        private Integer min;
        private Integer max;
        private String tooltip;
        private String choice;
        private String fixedText;
        private List<String> valueList;

        private ControlDescriptor(WidgetType widget, IVariableMap rmMap) {
            this.setControlData(widget);
            this.setMapDependentData(widget, rmMap);
        }

        private void setControlData(WidgetType widget) {
            this.widgetType = widget.getType();
            this.title = widget.getTitle();
            LayoutDataType layout = widget.getLayoutData();
            this.layoutData = LaunchTabBuilder.createLayoutData(layout);
            layout = widget.getSubLayoutData();
            this.subLayoutData = LaunchTabBuilder.createLayoutData(layout);
            this.style = WidgetBuilderUtils.getStyle((String)widget.getStyle());
            this.directory = widget.isDirectory();
            this.returnUri = widget.isUri();
            this.localOnly = widget.isLocalOnly();
            this.readOnly = widget.isReadOnly();
            if (this.readOnly) {
                this.style |= 8;
            }
            this.background = widget.getBackground();
            this.foreground = widget.getForeground();
            this.font = widget.getFont();
            this.tooltip = widget.getTooltip();
            this.fixedText = widget.getFixedText();
        }

        private void setData(Object data) {
            if (data instanceof AttributeType) {
                AttributeType a = (AttributeType)data;
                this.choice = a.getChoice();
                this.min = a.getMin();
                this.max = a.getMax();
            } else {
                boolean cfr_ignored_0 = data instanceof PropertyType;
            }
        }

        private void setMapDependentData(WidgetType widget, IVariableMap rmMap) {
            Object data;
            String s;
            this.tooltip = this.tooltip == null ? "" : WidgetBuilderUtils.removeTabOrLineBreak((String)rmMap.getString(this.tooltip));
            if (this.fixedText != null) {
                this.fixedText = rmMap.getString(this.fixedText);
            }
            if ((s = widget.getSaveValueTo()) != null && (data = rmMap.get(s)) != null) {
                this.setData(data);
            }
            if ((s = widget.getItemsFrom()) != null && (data = rmMap.get(s)) != null) {
                this.setValueListData(data);
            }
        }

        private void setValueListData(Object data) {
            if (data instanceof AttributeType) {
                AttributeType a = (AttributeType)data;
                Object value = a.getValue();
                if (value instanceof List) {
                    this.valueList = (List)value;
                }
            } else {
                PropertyType p = (PropertyType)data;
                Object value = p.getValue();
                if (value instanceof List) {
                    this.valueList = (List)value;
                }
            }
        }
    }
}

