/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control.ui.variables;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.ptp.rm.jaxb.control.ui.messages.Messages;
import org.eclipse.ptp.rm.jaxb.control.ui.variables.LCVariableResolver;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.ptp.rm.jaxb.core.JAXBCorePlugin;
import org.eclipse.ptp.rm.jaxb.core.data.AttributeType;
import org.eclipse.ptp.rm.jaxb.core.data.PropertyType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LCVariableMap
implements IVariableMap {
    private static final Object monitor = new Object();
    private Map<String, Object> globalValues;
    private final Map<String, Object> hidden;
    private Map<String, Object> values = Collections.synchronizedMap(new TreeMap());
    private final Map<String, String> defaultValues = Collections.synchronizedMap(new TreeMap());

    public LCVariableMap() {
        this.hidden = Collections.synchronizedMap(new TreeMap());
    }

    public void clear() {
        if (this.globalValues != null) {
            this.globalValues.clear();
        }
        if (this.values != null) {
            this.values.clear();
        }
        this.defaultValues.clear();
        this.hidden.clear();
    }

    public Object get(String name) {
        return this.values.get(name);
    }

    public Map<String, String> getChecked(String viewerName) {
        HashMap<String, String> m = new HashMap<String, String>();
        String checked = (String)this.values.get("checked_attributes" + viewerName);
        if (checked != null) {
            String[] split;
            String[] stringArray = split = checked.split(" ");
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                m.put(s, s);
                ++n2;
            }
        }
        return m;
    }

    public String getDefault(String name) {
        return this.defaultValues.get(name);
    }

    public Map<String, Object> getDiscovered() {
        return null;
    }

    public String getString(String value) {
        try {
            value = value.replaceAll("ptp_rm:", "ptp_lc:");
            return this.dereference(value);
        }
        catch (CoreException t) {
            JAXBCorePlugin.log((Throwable)t);
            return value;
        }
    }

    public String getString(String jobId, String value) {
        return this.getString(value);
    }

    public Map<String, Object> getVariables() {
        return this.values;
    }

    public void initialize(IVariableMap rmVars) throws Throwable {
        this.clear();
        for (String s : rmVars.getVariables().keySet()) {
            this.loadValues(s, rmVars.getVariables().get(s));
        }
        for (String s : rmVars.getDiscovered().keySet()) {
            this.loadValues(s, rmVars.getDiscovered().get(s));
        }
        this.globalValues = this.values;
        this.values = null;
    }

    public void put(String name, Object value) {
        if (value == null) {
            this.values.remove(name);
        } else {
            this.values.put(name, value);
        }
    }

    public void relinkHidden(Map<String, Object> current) {
        for (String name : this.hidden.keySet()) {
            Object linked;
            Object value = null;
            Object o = this.hidden.get(name);
            String link = null;
            if (o instanceof PropertyType) {
                PropertyType p = (PropertyType)o;
                link = p.getLinkValueTo();
            } else if (o instanceof AttributeType) {
                AttributeType a = (AttributeType)o;
                link = a.getLinkValueTo();
            }
            if (link != null && (linked = current.get(link)) != null && !"".equals(linked)) {
                value = linked;
            }
            if (value == null || "".equals(value)) {
                value = this.defaultValues.get(name);
            }
            if (value == null) continue;
            current.put(name, value);
        }
    }

    public Object remove(String name) {
        return this.values.remove(name);
    }

    public void saveHiddenNonLinked(Map<String, Object> current, Map<String, Object> saved) {
        for (String name : this.hidden.keySet()) {
            AttributeType a;
            Object o = this.hidden.get(name);
            Object v = null;
            if (o instanceof PropertyType) {
                PropertyType p = (PropertyType)o;
                if (p.getLinkValueTo() == null) {
                    v = p.getValue();
                }
            } else if (o instanceof AttributeType && (a = (AttributeType)o).getLinkValueTo() == null) {
                v = a.getValue();
            }
            if (v == null) continue;
            saved.put(name, v);
        }
    }

    public void saveStandardConfigurationProperties(ILaunchConfiguration configuration, Map<String, Object> current, Map<String, Object> saved) throws CoreException {
        Map attributes = configuration.getAttributes();
        for (Object o : attributes.keySet()) {
            String key = (String)o;
            if (!key.startsWith("org.eclipse.debug") && !key.startsWith("org.eclipse.ptp")) continue;
            saved.put(key, attributes.get(key));
        }
        String dir = (String)saved.get("control.working.dir");
        if (dir == null) {
            dir = "";
        }
        saved.put("directory", configuration.getAttribute("org.eclipse.ptp.launch.WORKING_DIR_ATTR", dir));
        saved.put("executablePath", configuration.getAttribute("org.eclipse.ptp.launch.ATTR_REMOTE_EXECUTABLE_PATH", ""));
        saved.put("progArgs", configuration.getAttribute("org.eclipse.ptp.launch.ARGUMENT_ATTR", ""));
    }

    public void setInitialized(boolean initialized) {
    }

    public Map<String, Object> swapVariables(Map<String, Object> newV) throws CoreException {
        Map<String, Object> oldV = this.values;
        this.values = newV;
        return oldV;
    }

    public void updateGlobal(ILaunchConfiguration configuration) throws CoreException {
        Map attr = configuration.getAttributes();
        for (Object k : attr.keySet()) {
            Object val = attr.get(k);
            if (val == null) continue;
            this.globalValues.put((String)k, attr.get(k));
        }
        this.values = this.globalValues;
    }

    public void writeToConfiguration(ILaunchConfigurationWorkingCopy configuration) throws CoreException {
        configuration.setAttributes(this.values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String dereference(String expression) throws CoreException {
        if (expression == null) {
            return null;
        }
        Object object = monitor;
        synchronized (object) {
            LCVariableResolver.setActive(this);
            return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(expression);
        }
    }

    private void loadValues(String key, Object value) throws Throwable {
        String name = null;
        String defVal = null;
        String strVal = null;
        boolean visible = true;
        Object o = null;
        if (value instanceof PropertyType) {
            PropertyType p = (PropertyType)value;
            name = p.getName();
            if (name == null) {
                return;
            }
            defVal = p.getDefault();
            if (!p.isVisible()) {
                this.hidden.put(name, p);
            } else {
                o = p.getValue();
            }
        } else if (value instanceof AttributeType) {
            AttributeType ja = (AttributeType)value;
            name = ja.getName();
            if (name == null) {
                return;
            }
            defVal = ja.getDefault();
            if (!ja.isVisible()) {
                this.hidden.put(name, ja);
            } else {
                o = ja.getValue();
                String status = ja.getStatus();
                this.put(String.valueOf(name) + "#" + "status", status);
            }
        } else {
            throw new ArrayStoreException(String.valueOf(Messages.IllegalVariableValueType) + value);
        }
        this.defaultValues.put(name, defVal);
        if (visible) {
            if (o != null) {
                strVal = String.valueOf(o);
            }
            if (strVal == null) {
                strVal = defVal;
            }
            this.put(name, strVal);
        }
    }
}

