/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control.data;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.ptp.rm.jaxb.core.data.RegexType;

public class RegexImpl {
    private String expression;
    private final boolean split;
    private final Pattern pattern;
    private int lastChar;

    public RegexImpl(RegexType regex) {
        this.expression = regex.getExpression();
        if (this.expression == null) {
            this.expression = regex.getContent();
        }
        this.split = regex.isSplit();
        this.pattern = Pattern.compile(this.expression, this.getFlags(regex.getFlags()));
    }

    public String getExpression() {
        return this.expression;
    }

    public int getLastChar() {
        return this.lastChar;
    }

    public String[] getMatched(String sequence) {
        String[] result = null;
        if (this.split) {
            result = this.pattern.split(sequence);
        } else {
            Matcher m = this.pattern.matcher(sequence);
            if (m.matches()) {
                int count = m.groupCount();
                result = new String[count + 1];
                int i = 0;
                while (i < result.length) {
                    result[i] = m.group(i);
                    ++i;
                }
                this.lastChar = m.end(count);
            }
        }
        return result;
    }

    private int getFlags(String flags) {
        String[] split;
        if (flags == null) {
            return 0;
        }
        int f = 0;
        String[] stringArray = split = flags.split("[|]");
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if ("CASE_INSENSITIVE".equals(s.trim())) {
                f |= 2;
            } else if ("MULTILINE".equals(s.trim())) {
                f |= 8;
            } else if ("DOTALL".equals(s.trim())) {
                f |= 0x20;
            } else if ("UNICODE_CASE".equals(s.trim())) {
                f |= 0x40;
            } else if ("CANON_EQ".equals(s.trim())) {
                f |= 0x80;
            } else if ("LITERAL".equals(s.trim())) {
                f |= 0x10;
            } else if ("COMMENTS".equals(s.trim())) {
                f |= 4;
            } else if ("UNIX_LINES".equals(s.trim())) {
                f |= 1;
            }
            ++n2;
        }
        return f;
    }
}

