/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control.internal.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ptp.core.util.CoreExceptionUtils;
import org.eclipse.ptp.rm.jaxb.control.internal.IAssign;
import org.eclipse.ptp.rm.jaxb.control.internal.IMatchable;
import org.eclipse.ptp.rm.jaxb.control.internal.data.MatchImpl;
import org.eclipse.ptp.rm.jaxb.control.internal.data.TestImpl;
import org.eclipse.ptp.rm.jaxb.control.internal.messages.Messages;
import org.eclipse.ptp.rm.jaxb.control.internal.variables.RMVariableMap;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.ptp.rm.jaxb.core.data.AttributeType;
import org.eclipse.ptp.rm.jaxb.core.data.MatchType;
import org.eclipse.ptp.rm.jaxb.core.data.PropertyType;
import org.eclipse.ptp.rm.jaxb.core.data.TargetType;
import org.eclipse.ptp.rm.jaxb.core.data.TestType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetImpl
implements IMatchable {
    private final IVariableMap rmVarMap;
    private final String uuid;
    private final String ref;
    private final String type;
    private final List<MatchImpl> matches;
    private final List<TestImpl> tests;
    private final List<Object> targets;
    private Object refTarget;
    private final boolean matchAll;
    private boolean selected;

    public TargetImpl(String uuid, TargetType target, IVariableMap rmVarMap) {
        this.rmVarMap = rmVarMap;
        this.uuid = uuid;
        this.ref = target.getRef();
        this.type = target.getType();
        this.matchAll = target.isMatchAll();
        this.matches = new ArrayList<MatchImpl>();
        List mdata = target.getMatch();
        for (MatchType m : mdata) {
            this.matches.add(new MatchImpl(uuid, m, this, rmVarMap));
        }
        this.tests = new ArrayList<TestImpl>();
        List tdata = target.getTest();
        for (TestType t : tdata) {
            this.tests.add(new TestImpl(uuid, t, rmVarMap));
        }
        this.targets = new ArrayList<Object>();
        this.selected = false;
    }

    @Override
    public synchronized boolean doMatch(StringBuffer segment) throws Throwable {
        int matched = 0;
        boolean match = false;
        for (MatchImpl m : this.matches) {
            if (this.matchAll && m.getMatched()) {
                ++matched;
                continue;
            }
            int tail = m.doMatch(segment.toString());
            match = m.getMatched();
            if (!match) continue;
            segment.delete(0, tail);
            ++matched;
            this.selected = m.getMoveToTop();
            break;
        }
        if (!this.matchAll || matched == this.matches.size()) {
            for (MatchImpl m : this.matches) {
                m.reset();
            }
        }
        return match;
    }

    public Object getTarget(IAssign assign) throws CoreException {
        if (this.refTarget != null) {
            return this.refTarget;
        }
        Object target = null;
        if (this.ref != null) {
            String name = this.rmVarMap.getString(this.uuid, this.ref);
            target = this.rmVarMap.get(name);
            if (target == null) {
                throw CoreExceptionUtils.newException((String)(String.valueOf(Messages.StreamParserNoSuchVariableError) + name), null);
            }
            this.refTarget = target;
        } else {
            int i = assign.getIndex();
            if (i < this.targets.size()) {
                target = this.targets.get(i);
            }
            if (target == null) {
                if ("property".equals(this.type)) {
                    PropertyType p = new PropertyType();
                    target = p;
                    this.targets.add(target);
                } else if ("attribute".equals(this.type)) {
                    AttributeType ja = new AttributeType();
                    target = ja;
                    this.targets.add(target);
                } else {
                    throw CoreExceptionUtils.newException((String)(String.valueOf(Messages.StreamParserMissingTargetType) + this.ref), null);
                }
            }
        }
        return target;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public synchronized void postProcess() throws Throwable {
        if (this.refTarget == null) {
            if ("property".equals(this.type)) {
                this.mergeProperties(this.targets);
            } else if ("attribute".equals(this.type)) {
                this.mergeAttributes(this.targets);
            }
            if (this.rmVarMap instanceof RMVariableMap) {
                Map<String, Object> dmap = ((RMVariableMap)this.rmVarMap).getDiscovered();
                for (Object t : this.targets) {
                    for (TestImpl test : this.tests) {
                        test.setTarget(t);
                        test.doTest();
                    }
                    if ("property".equals(this.type)) {
                        dmap.put(((PropertyType)t).getName(), t);
                        continue;
                    }
                    if (!"attribute".equals(this.type)) continue;
                    dmap.put(((AttributeType)t).getName(), t);
                }
            }
            this.targets.clear();
        } else {
            for (TestImpl test : this.tests) {
                test.setTarget(this.refTarget);
                test.doTest();
            }
            this.refTarget = null;
        }
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    private void merge(AttributeType previous, AttributeType current) throws Throwable {
        Object v0 = previous.getValue();
        Object v1 = current.getValue();
        if (v0 == null) {
            previous.setValue(v1);
        } else if (v1 != null) {
            throw new Throwable(String.valueOf(Messages.StreamParserInconsistentPropertyWarning) + v0 + "," + " " + v1);
        }
        String s0 = previous.getDefault();
        String s1 = current.getDefault();
        if (s0 == null) {
            previous.setDefault(s1);
        } else if (s1 != null) {
            throw new Throwable(String.valueOf(Messages.StreamParserInconsistentPropertyWarning) + s0 + "," + " " + s1);
        }
        s0 = previous.getType();
        s1 = current.getType();
        if (s0 == null) {
            previous.setType(s1);
        } else if (s1 != null) {
            throw new Throwable(String.valueOf(Messages.StreamParserInconsistentPropertyWarning) + s0 + "," + " " + s1);
        }
        s0 = previous.getStatus();
        s1 = current.getStatus();
        if (s0 == null) {
            previous.setStatus(s1);
        } else if (s1 != null) {
            throw new Throwable(String.valueOf(Messages.StreamParserInconsistentPropertyWarning) + s0 + "," + " " + s1);
        }
        boolean b0 = previous.isReadOnly();
        boolean b1 = current.isReadOnly();
        if (!b0) {
            previous.setReadOnly(Boolean.valueOf(b1));
        }
        b0 = previous.isVisible();
        b1 = current.isVisible();
        if (!b0) {
            previous.setVisible(Boolean.valueOf(b1));
        }
        Integer i0 = previous.getMax();
        Integer i1 = current.getMax();
        if (i0 == null) {
            previous.setMax(i1);
        } else if (i1 != null) {
            throw new Throwable(String.valueOf(Messages.StreamParserInconsistentPropertyWarning) + i0 + "," + " " + i1);
        }
        i0 = previous.getMin();
        i1 = current.getMin();
        if (i0 == null) {
            previous.setMin(i1);
        } else if (i1 != null) {
            throw new Throwable(String.valueOf(Messages.StreamParserInconsistentPropertyWarning) + i0 + "," + " " + i1);
        }
        s0 = previous.getDescription();
        s1 = current.getDescription();
        if (s0 == null) {
            previous.setDescription(s1);
        } else if (s1 != null) {
            throw new Throwable(String.valueOf(Messages.StreamParserInconsistentPropertyWarning) + s0 + "," + " " + s1);
        }
        s0 = previous.getChoice();
        s1 = current.getChoice();
        if (s0 == null) {
            previous.setChoice(s1);
        } else if (s1 != null) {
            throw new Throwable(String.valueOf(Messages.StreamParserInconsistentPropertyWarning) + s0 + "," + " " + s1);
        }
        s0 = previous.getTooltip();
        s1 = current.getTooltip();
        if (s0 == null) {
            previous.setTooltip(s1);
        } else if (s1 != null) {
            throw new Throwable(String.valueOf(Messages.StreamParserInconsistentPropertyWarning) + s0 + "," + " " + s1);
        }
    }

    private void merge(PropertyType previous, PropertyType current) throws Throwable {
        Object v0 = previous.getValue();
        Object v1 = current.getValue();
        if (v0 == null) {
            previous.setValue(v1);
        } else if (v1 != null) {
            throw new Throwable(String.valueOf(Messages.StreamParserInconsistentPropertyWarning) + v0 + "," + " " + v1);
        }
        String s0 = previous.getDefault();
        String s1 = current.getDefault();
        if (s0 == null) {
            previous.setDefault(s1);
        } else if (s1 != null) {
            throw new Throwable(String.valueOf(Messages.StreamParserInconsistentPropertyWarning) + s0 + "," + " " + s1);
        }
        s0 = previous.getType();
        s1 = current.getType();
        if (s0 == null) {
            previous.setType(s1);
        } else if (s1 != null) {
            throw new Throwable(String.valueOf(Messages.StreamParserInconsistentPropertyWarning) + s0 + "," + " " + s1);
        }
        boolean b0 = previous.isReadOnly();
        boolean b1 = current.isReadOnly();
        if (!b0) {
            previous.setReadOnly(Boolean.valueOf(b1));
        }
        b0 = previous.isVisible();
        b1 = current.isVisible();
        if (!b0) {
            previous.setVisible(Boolean.valueOf(b1));
        }
    }

    private void mergeAttributes(List<Object> targets) throws Throwable {
        HashMap<String, AttributeType> hash = new HashMap<String, AttributeType>();
        Iterator<Object> i = targets.iterator();
        while (i.hasNext()) {
            AttributeType current = (AttributeType)i.next();
            String name = current.getName();
            if (current.getName() == null) {
                i.remove();
                continue;
            }
            AttributeType previous = (AttributeType)hash.get(name);
            if (previous != null) {
                this.merge(previous, current);
                i.remove();
                continue;
            }
            hash.put(name, current);
        }
    }

    private void mergeProperties(List<Object> targets) throws Throwable {
        HashMap<String, PropertyType> hash = new HashMap<String, PropertyType>();
        Iterator<Object> i = targets.iterator();
        while (i.hasNext()) {
            PropertyType current = (PropertyType)i.next();
            String name = current.getName();
            if (current.getName() == null) {
                i.remove();
                continue;
            }
            PropertyType previous = (PropertyType)hash.get(name);
            if (previous != null) {
                this.merge(previous, current);
                i.remove();
                continue;
            }
            hash.put(name, current);
        }
    }
}

