/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control.internal.variables;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.rm.jaxb.control.JAXBControlCorePlugin;
import org.eclipse.ptp.rm.jaxb.control.internal.variables.RMVariableResolver;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.ptp.rm.jaxb.core.data.PropertyType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RMVariableMap
implements IVariableMap {
    private static final Object monitor = new Object();
    private final Map<String, Object> variables = Collections.synchronizedMap(new TreeMap());
    private final Map<String, Object> discovered = Collections.synchronizedMap(new TreeMap());
    private boolean initialized = false;

    public void clear() {
        this.variables.clear();
        this.discovered.clear();
        this.initialized = false;
    }

    public Object get(String name) {
        Object o = this.variables.get(name);
        if (o == null) {
            o = this.discovered.get(name);
        }
        return o;
    }

    public Map<String, Object> getDiscovered() {
        return this.discovered;
    }

    public String getString(String value) {
        return this.getString(null, value);
    }

    public String getString(String jobId, String value) {
        try {
            if (jobId != null) {
                value = value.replaceAll("@jobId", jobId);
            }
            return this.dereference(value);
        }
        catch (CoreException t) {
            JAXBControlCorePlugin.log(t);
            return value;
        }
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void maybeAddProperty(String name, Object value, boolean visible) {
        if (value == null) {
            return;
        }
        PropertyType p = new PropertyType();
        p.setName(name);
        p.setValue(value);
        p.setVisible(Boolean.valueOf(visible));
        this.variables.put(name, p);
    }

    public void maybeOverwrite(String key1, String key2, ILaunchConfiguration configuration) throws CoreException {
        Object value1 = null;
        Object value2 = null;
        PropertyType p = (PropertyType)this.get(key1);
        if (p != null) {
            value1 = p.getValue();
        }
        if ((value2 = configuration.getAttributes().get(key2)) == null) {
            this.maybeAddProperty(key1, value1, false);
        } else {
            this.maybeAddProperty(key1, value2, false);
        }
    }

    public void put(String name, Object value) {
        this.variables.put(name, value);
    }

    public Object remove(String name) {
        Object o = this.variables.remove(name);
        if (o == null) {
            o = this.discovered.remove(name);
        }
        return o;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String dereference(String expression) throws CoreException {
        if (expression == null) {
            return null;
        }
        Object object = monitor;
        synchronized (object) {
            RMVariableResolver.setActive(this);
            return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(expression);
        }
    }
}

