/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.search;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.search.LineSearchElement;
import org.eclipse.cdt.internal.ui.util.Messages;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.ptp.internal.rdt.ui.search.RemoteSearchLabelProvider;
import org.eclipse.ptp.internal.rdt.ui.search.RemoteSearchViewPage;

public class RemoteSearchTreeLabelProvider
extends RemoteSearchLabelProvider {
    public RemoteSearchTreeLabelProvider(RemoteSearchViewPage page) {
        super(page);
    }

    public String getText(Object element) {
        String text = super.getText(element);
        int count = this.getMatchCount(element);
        if (count <= 1) {
            return text;
        }
        return String.valueOf(text) + " " + Messages.format((String)CSearchMessages.CSearchResultCollector_matches, (Object[])new Object[]{new Integer(count)});
    }

    public StyledString getStyledText(Object element) {
        if (element instanceof ITranslationUnit) {
            StyledString styled = new StyledString(super.getText(element));
            int count = this.getMatchCount(element);
            if (count > 1) {
                String matchesCount = " " + Messages.format((String)CSearchMessages.CSearchResultCollector_matches, (Object[])new Object[]{new Integer(count)});
                styled.append(matchesCount, StyledString.COUNTER_STYLER);
                return styled;
            }
        }
        if (!(element instanceof LineSearchElement)) {
            return new StyledString(this.getText(element));
        }
        LineSearchElement lineElement = (LineSearchElement)element;
        String enclosingName = "";
        ICElement enclosingElement = lineElement.getMatches()[0].getEnclosingElement();
        if (this.fPage.isShowEnclosingDefinitions() && enclosingElement != null) {
            enclosingName = String.valueOf(enclosingElement.getElementName()) + ", ";
        }
        Integer lineNumber = lineElement.getLineNumber();
        String prefix = Messages.format((String)CSearchMessages.CSearchResultCollector_line, (Object[])new Object[]{enclosingName, lineNumber});
        prefix = String.valueOf(prefix) + ":  ";
        StyledString location = new StyledString(prefix, StyledString.QUALIFIER_STYLER);
        return location.append(super.getStyledText(element));
    }
}

