/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.model;

import java.io.Serializable;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTImageLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.model.ISourceRange;

public class SourceRange
implements ISourceRange,
Serializable {
    private static final long serialVersionUID = 1L;
    private int fEndLine;
    private int fIdLength;
    private int fIdStartPos;
    private int fLength;
    private int fStartLine;
    private int fStartPos;

    public SourceRange() {
    }

    public SourceRange(ISourceRange range) {
        this.fEndLine = range.getEndLine();
        this.fIdLength = range.getIdLength();
        this.fIdStartPos = range.getIdStartPos();
        this.fLength = range.getLength();
        this.fStartLine = range.getStartLine();
        this.fStartPos = range.getStartPos();
    }

    public SourceRange(IASTName name, IASTFileLocation location) {
        IASTImageLocation image = name.getImageLocation();
        this.fIdLength = image.getNodeOffset();
        this.fIdStartPos = image.getNodeLength();
        this.fEndLine = location.getEndingLineNumber();
        this.fLength = location.getNodeLength();
        this.fStartLine = location.getStartingLineNumber();
        this.fStartPos = location.getNodeOffset();
    }

    public SourceRange(IIndexName name, IASTFileLocation location) {
        this.fEndLine = location.getEndingLineNumber();
        this.fIdLength = name.getNodeLength();
        this.fIdStartPos = name.getNodeOffset();
        this.fLength = location.getNodeLength();
        this.fStartLine = location.getStartingLineNumber();
        this.fStartPos = location.getNodeOffset();
    }

    public int getEndLine() {
        return this.fEndLine;
    }

    public int getIdLength() {
        return this.fIdLength;
    }

    public int getIdStartPos() {
        return this.fIdStartPos;
    }

    public int getLength() {
        return this.fLength;
    }

    public int getStartLine() {
        return this.fStartLine;
    }

    public int getStartPos() {
        return this.fStartPos;
    }

    public void setIdPos(int offset, int length) {
        this.fIdStartPos = offset;
        this.fIdLength = length;
    }

    public void setPos(int offset, int length) {
        this.fStartPos = offset;
        this.fLength = length;
    }

    public void setLines(int startingLineNumber, int endingLineNumber) {
        this.fStartLine = startingLineNumber;
        this.fEndLine = endingLineNumber;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ISourceRange)) {
            return false;
        }
        ISourceRange range = (ISourceRange)o;
        return range.getIdStartPos() == this.fIdStartPos && range.getIdLength() == this.fIdLength && range.getStartPos() == this.fStartPos && range.getLength() == this.fLength && range.getStartLine() == this.fStartLine && range.getEndLine() == this.fEndLine;
    }

    public int hashCode() {
        return this.fEndLine + this.fIdLength + this.fIdStartPos + this.fLength + this.fStartLine + this.fStartPos;
    }
}

