/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control.internal.data;

import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.List;
import org.eclipse.ptp.rm.jaxb.control.internal.IAssign;
import org.eclipse.ptp.rm.jaxb.control.internal.data.AddImpl;
import org.eclipse.ptp.rm.jaxb.control.internal.data.AppendImpl;
import org.eclipse.ptp.rm.jaxb.control.internal.data.PutImpl;
import org.eclipse.ptp.rm.jaxb.control.internal.data.SetImpl;
import org.eclipse.ptp.rm.jaxb.control.internal.data.ThrowImpl;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.ptp.rm.jaxb.core.data.AddType;
import org.eclipse.ptp.rm.jaxb.core.data.AppendType;
import org.eclipse.ptp.rm.jaxb.core.data.EntryType;
import org.eclipse.ptp.rm.jaxb.core.data.PutType;
import org.eclipse.ptp.rm.jaxb.core.data.SetType;
import org.eclipse.ptp.rm.jaxb.core.data.ThrowType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAssign
implements IAssign {
    protected String uuid = null;
    protected String field = null;
    protected Object target = null;
    protected int index = 0;
    protected IVariableMap rmVarMap;

    protected AbstractAssign(IVariableMap rmVarMap) {
        this.rmVarMap = rmVarMap;
    }

    @Override
    public void assign(String[] values) throws Throwable {
        Object previous = AbstractAssign.get(this.target, this.field);
        AbstractAssign.set(this.target, this.field, this.getValue(previous, values));
        ++this.index;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setTarget(Object target) {
        this.target = target;
    }

    protected int determineKeyIndex(EntryType entry) {
        int index = entry.getKeyIndex();
        int group = entry.getKeyGroup();
        if (index == 0 && group != 0) {
            index = group;
        }
        return index;
    }

    protected int determineValueIndex(EntryType entry) {
        int index = entry.getValueIndex();
        int group = entry.getValueGroup();
        if (index == 0 && group != 0) {
            index = group;
        }
        return index;
    }

    protected String getKey(EntryType entry, String[] values) throws Throwable {
        String k = entry.getKey();
        if (k != null) {
            return (String)AbstractAssign.normalizedValue(this.target, this.uuid, k, false, this.rmVarMap);
        }
        int index = this.determineKeyIndex(entry);
        if (values != null) {
            return values[index];
        }
        return null;
    }

    protected Object getValue(EntryType entry, String[] values) throws Throwable {
        String v = entry.getValue();
        if (v != null) {
            return AbstractAssign.normalizedValue(this.target, this.uuid, v, true, this.rmVarMap);
        }
        int index = this.determineValueIndex(entry);
        if (values != null) {
            return values[index];
        }
        return null;
    }

    protected abstract Object[] getValue(Object var1, String[] var2) throws Throwable;

    static void add(String uuid, Object assign, List<IAssign> list, IVariableMap rmVarMap) {
        if (assign instanceof AddType) {
            AddType add = (AddType)assign;
            list.add(new AddImpl(uuid, add, rmVarMap));
            return;
        }
        if (assign instanceof AppendType) {
            AppendType append = (AppendType)assign;
            list.add(new AppendImpl(uuid, append, rmVarMap));
            return;
        }
        if (assign instanceof PutType) {
            PutType put = (PutType)assign;
            list.add(new PutImpl(uuid, put, rmVarMap));
            return;
        }
        if (assign instanceof SetType) {
            SetType set = (SetType)assign;
            list.add(new SetImpl(uuid, set, rmVarMap));
            return;
        }
        if (assign instanceof ThrowType) {
            ThrowType thr = (ThrowType)assign;
            list.add(new ThrowImpl(uuid, thr, rmVarMap));
            return;
        }
    }

    static Object get(Object target, String field) throws Throwable {
        if (field == null) {
            return null;
        }
        String name = "get" + field.substring(0, 1).toUpperCase() + field.substring(1);
        Method method = null;
        try {
            method = target.getClass().getMethod(name, null);
        }
        catch (Throwable throwable) {
            name = "is" + field.substring(0, 1).toUpperCase() + field.substring(1);
            method = target.getClass().getMethod(name, null);
        }
        return method.invoke(target, null);
    }

    static Object normalizedValue(Object target, String uuid, String expression, boolean convert, IVariableMap map) throws Throwable {
        if (expression.startsWith("#")) {
            if (target == null) {
                return null;
            }
            String field = expression.substring(1);
            return AbstractAssign.get(target, field);
        }
        if (expression.indexOf("${") >= 0) {
            expression = map.getString(uuid, expression);
            return map.getString(uuid, expression);
        }
        if (convert) {
            if ("true".equalsIgnoreCase(expression)) {
                return true;
            }
            if ("false".equalsIgnoreCase(expression)) {
                return false;
            }
            try {
                if (expression.indexOf(".") >= 0) {
                    return new Double(expression);
                }
                return new Integer(expression);
            }
            catch (NumberFormatException numberFormatException) {
                return expression;
            }
        }
        return expression;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void set(Object target, String field, Object[] values) throws Throwable {
        String name = "set" + field.substring(0, 1).toUpperCase() + field.substring(1);
        Method[] methods = target.getClass().getMethods();
        Method setter = null;
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().equals(name)) {
                setter = m;
            }
            ++n2;
        }
        if (setter == null) {
            throw new NoSuchMethodException(String.valueOf(name) + ":" + " " + target);
        }
        if (values != null && values[0] != null) {
            Class<?>[] mclzz = setter.getParameterTypes();
            Class<?> param = mclzz[0];
            Class<?> valueClass = values[0].getClass();
            IllegalArgumentException t = new IllegalArgumentException(String.valueOf(name) + " " + valueClass);
            if (!param.equals(Object.class) && !param.isAssignableFrom(values[0].getClass())) {
                if (valueClass.equals(String.class)) {
                    if (param.equals(Boolean.class)) {
                        values[0] = new Boolean(values[0].toString());
                    } else if (param.equals(Integer.class)) {
                        values[0] = new Integer(values[0].toString());
                    } else {
                        if (!param.equals(BigInteger.class)) throw t;
                        values[0] = new BigInteger(values[0].toString());
                    }
                } else {
                    if (!valueClass.equals(Integer.class) && !valueClass.equals(BigInteger.class) && !valueClass.equals(Boolean.class)) throw t;
                    if (!param.equals(String.class)) throw t;
                    values[0] = values[0].toString();
                }
            }
        }
        setter.invoke(target, values);
    }
}

