/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.core;

import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ptp.core.Preferences;
import org.eclipse.ptp.rm.core.rmsystem.AbstractRemoteResourceManagerConfiguration;
import org.eclipse.ptp.rm.jaxb.core.IJAXBResourceManagerConfiguration;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.ptp.rm.jaxb.core.JAXBCorePlugin;
import org.eclipse.ptp.rm.jaxb.core.JAXBInitializationUtils;
import org.eclipse.ptp.rm.jaxb.core.data.ResourceManagerData;
import org.eclipse.ptp.rm.jaxb.core.messages.Messages;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;

public abstract class AbstractJAXBResourceManagerConfiguration
extends AbstractRemoteResourceManagerConfiguration
implements IJAXBResourceManagerConfiguration {
    protected ResourceManagerData rmdata;
    protected IVariableMap map;

    protected AbstractJAXBResourceManagerConfiguration(String namespace, IServiceProvider provider) {
        super(namespace, provider);
    }

    public void clearReferences(boolean all) {
        if (all) {
            this.map.clear();
            this.map = null;
            this.clearRMData();
        } else {
            if (this.map != null) {
                this.map.clear();
            }
            this.rmdata = null;
        }
    }

    public ResourceManagerData getResourceManagerData() throws Throwable {
        if (this.rmdata == null) {
            this.realizeRMDataFromXML();
        }
        if (this.rmdata == null) {
            throw new InstantiationError(Messages.FailedToCreateRmData);
        }
        return this.rmdata;
    }

    public void setRMConfigurationURL(URL url) {
        if (url != null) {
            this.putString("rm_config_url", url.toExternalForm());
        }
    }

    private void clearRMData() {
        this.rmdata = null;
        this.setRemoteServicesId(null);
        this.setConnectionName(null);
        this.setInvocationOptions("");
        this.setLocalAddress("");
    }

    private String getRMConfigurationXML() {
        String xml = this.getString("rm_config_xml", "");
        if ("".equals(xml)) {
            return null;
        }
        return xml;
    }

    private void realizeRMDataFromXML() throws Throwable {
        String location;
        String xml = this.getRMConfigurationXML();
        boolean force = Preferences.getBoolean((String)JAXBCorePlugin.getUniqueIdentifier(), (String)"Always reload XML from URL");
        if ((xml == null || force) && (location = this.getString("rm_config_url", "")) != null) {
            try {
                xml = JAXBInitializationUtils.getRMConfigurationXML(new URL(location));
                this.setRMConfigurationXML(xml);
            }
            catch (Throwable throwable) {
                new UIJob(Messages.CachedDefinitionWarning){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.CachedDefinitionWarning, (String)Messages.UsingCachedDefinition);
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        }
        this.rmdata = xml != null ? JAXBInitializationUtils.initializeRMData(xml) : null;
    }

    private void setRMConfigurationXML(String xml) {
        if (xml != null) {
            this.putString("rm_config_xml", xml);
            this.clearRMData();
        }
    }
}

