/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control.ui.launch;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.ptp.core.elements.IPQueue;
import org.eclipse.ptp.launch.ui.extensions.AbstractRMLaunchConfigurationDynamicTab;
import org.eclipse.ptp.launch.ui.extensions.IRMLaunchConfigurationContentsChangedListener;
import org.eclipse.ptp.launch.ui.extensions.IRMLaunchConfigurationDynamicTab;
import org.eclipse.ptp.launch.ui.extensions.RMLaunchValidation;
import org.eclipse.ptp.rm.jaxb.control.ui.launch.AbstractJAXBLaunchConfigurationTab;
import org.eclipse.ptp.rmsystem.IResourceManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExtensibleJAXBControllerTab
extends AbstractRMLaunchConfigurationDynamicTab
implements IRMLaunchConfigurationContentsChangedListener {
    protected boolean voidRMConfig = false;
    protected TabFolder tabFolder;
    protected String lastVisited = null;
    protected int lastIndex = 0;
    private final LinkedList<AbstractJAXBLaunchConfigurationTab> tabControllers = new LinkedList();
    private final Map<String, AbstractJAXBLaunchConfigurationTab> controllerIndex = new HashMap<String, AbstractJAXBLaunchConfigurationTab>();
    private Composite control;

    protected ExtensibleJAXBControllerTab(ILaunchConfigurationDialog dialog) {
        super(dialog);
    }

    public RMLaunchValidation canSave(Control control, IResourceManager rm, IPQueue queue) {
        for (AbstractJAXBLaunchConfigurationTab tabControl : this.tabControllers) {
            RMLaunchValidation validation = tabControl.canSave(control, rm, queue);
            if (validation.isSuccess()) continue;
            return validation;
        }
        return new RMLaunchValidation(true, null);
    }

    public void createControl(Composite parent, IResourceManager rm, IPQueue queue) throws CoreException {
        this.control = new Composite(parent, 0);
        if (!this.voidRMConfig) {
            GridLayout layout = new GridLayout();
            this.control.setLayout((Layout)layout);
            this.tabFolder = new TabFolder(this.control, 0);
            this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
            for (AbstractJAXBLaunchConfigurationTab tabControl : this.tabControllers) {
                TabItem simpleTabItem = new TabItem(this.tabFolder, 0);
                tabControl.createControl((Composite)this.tabFolder, rm, queue);
                simpleTabItem.setText(tabControl.getText());
                simpleTabItem.setImage(tabControl.getImage());
                simpleTabItem.setControl(tabControl.getControl());
            }
        }
    }

    public Control getControl() {
        return this.control;
    }

    public String getLastVisited() {
        return this.lastVisited;
    }

    public void handleContentsChanged(IRMLaunchConfigurationDynamicTab factory) {
        this.fireContentsChanged();
    }

    public RMLaunchValidation initializeFrom(Control control, IResourceManager rm, IPQueue queue, ILaunchConfiguration configuration) {
        RMLaunchValidation resultValidation = new RMLaunchValidation(true, null);
        for (AbstractJAXBLaunchConfigurationTab tabControl : this.tabControllers) {
            RMLaunchValidation validation = tabControl.initializeFrom(control, rm, queue, configuration);
            if (validation.isSuccess()) continue;
            resultValidation = validation;
        }
        for (AbstractJAXBLaunchConfigurationTab tabControl : this.tabControllers) {
            tabControl.setUpSharedEnvironment(this.controllerIndex);
        }
        return resultValidation;
    }

    public RMLaunchValidation isValid(ILaunchConfiguration launchConfig, IResourceManager rm, IPQueue queue) {
        for (AbstractJAXBLaunchConfigurationTab tabControl : this.tabControllers) {
            RMLaunchValidation validation = tabControl.isValid(launchConfig, rm, queue);
            if (validation.isSuccess()) continue;
            return validation;
        }
        return new RMLaunchValidation(true, null);
    }

    public RMLaunchValidation performApply(ILaunchConfigurationWorkingCopy configuration, IResourceManager rm, IPQueue queue) {
        RMLaunchValidation resultValidation = new RMLaunchValidation(true, null);
        for (AbstractJAXBLaunchConfigurationTab tabControl : this.tabControllers) {
            RMLaunchValidation validation = tabControl.performApply(configuration, rm, queue);
            if (validation.isSuccess()) continue;
            resultValidation = validation;
        }
        return resultValidation;
    }

    public RMLaunchValidation setDefaults(ILaunchConfigurationWorkingCopy configuration, IResourceManager rm, IPQueue queue) {
        RMLaunchValidation resultValidation = new RMLaunchValidation(true, null);
        for (AbstractJAXBLaunchConfigurationTab tabControl : this.tabControllers) {
            RMLaunchValidation validation = tabControl.setDefaults(configuration, rm, queue);
            if (validation.isSuccess()) continue;
            resultValidation = validation;
        }
        return resultValidation;
    }

    public void setLastVisited(String lastVisited) {
        this.lastVisited = lastVisited;
    }

    protected void addDynamicTab(AbstractJAXBLaunchConfigurationTab tabController) {
        this.tabControllers.add(tabController);
        this.controllerIndex.put(tabController.getText(), tabController);
        tabController.addContentsChangedListener(this);
    }

    protected List<AbstractJAXBLaunchConfigurationTab> getControllers() {
        return this.tabControllers;
    }
}

