/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.ui.wizards;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.ui.wizards.conversion.ConvertProjectWizardPage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.ptp.rdt.sync.core.BuildConfigurationManager;
import org.eclipse.ptp.rdt.sync.core.BuildScenario;
import org.eclipse.ptp.rdt.sync.core.resources.RemoteMakeNature;
import org.eclipse.ptp.rdt.sync.core.resources.RemoteSyncNature;
import org.eclipse.ptp.rdt.sync.core.serviceproviders.ISyncServiceProvider;
import org.eclipse.ptp.rdt.sync.core.serviceproviders.SyncBuildServiceProvider;
import org.eclipse.ptp.rdt.sync.ui.ISynchronizeParticipant;
import org.eclipse.ptp.rdt.sync.ui.ISynchronizeParticipantDescriptor;
import org.eclipse.ptp.rdt.sync.ui.RDTSyncUIPlugin;
import org.eclipse.ptp.rdt.sync.ui.SynchronizeParticipantRegistry;
import org.eclipse.ptp.rdt.sync.ui.messages.Messages;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.services.core.IService;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.ptp.services.core.IServiceProviderDescriptor;
import org.eclipse.ptp.services.core.ServiceModelManager;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.statushandlers.StatusManager;

public class ConvertToSyncProjectWizardPage
extends ConvertProjectWizardPage {
    private Combo fProviderCombo;
    private Composite fProviderArea;
    private StackLayout fProviderStack;
    private final List<Composite> fProviderControls = new ArrayList<Composite>();
    private ISynchronizeParticipantDescriptor fSelectedProvider;
    private final Map<Integer, ISynchronizeParticipantDescriptor> fComboIndexToDescriptorMap = new HashMap<Integer, ISynchronizeParticipantDescriptor>();
    protected Map<IProject, IServiceConfiguration> projectConfigs = new HashMap<IProject, IServiceConfiguration>();

    public ConvertToSyncProjectWizardPage(String pageName) {
        super(pageName);
    }

    private void addProviderControl(ISynchronizeParticipantDescriptor desc) {
        Composite comp = null;
        ISynchronizeParticipant part = desc.getParticipant();
        if (part != null) {
            comp = new Composite(this.fProviderArea, 0);
            comp.setLayout((Layout)new GridLayout(1, false));
            comp.setLayoutData((Object)new GridData(4, 4, true, true));
            part.createConfigurationArea(comp, (IRunnableContext)this.getWizard().getContainer());
        }
        this.fProviderControls.add(comp);
    }

    protected void addToMainPage(Composite container) {
        Composite comp = new Composite(container, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        comp.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        comp.setLayoutData((Object)gd);
        Label providerLabel = new Label(comp, 16384);
        providerLabel.setText(Messages.NewRemoteSyncProjectWizardPage_syncProvider);
        this.fProviderCombo = new Combo(comp, 12);
        this.fProviderCombo.setLayoutData((Object)new GridData(1, 1, false, false));
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fProviderCombo.setLayoutData((Object)gd);
        this.fProviderCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConvertToSyncProjectWizardPage.this.handleProviderSelected();
            }
        });
        this.fProviderArea = new Group(comp, 16);
        this.fProviderStack = new StackLayout();
        this.fProviderArea.setLayout((Layout)this.fProviderStack);
        GridData providerAreaData = new GridData(4, 4, true, true);
        providerAreaData.horizontalSpan = 3;
        this.fProviderArea.setLayoutData((Object)providerAreaData);
        ISynchronizeParticipantDescriptor[] providers = SynchronizeParticipantRegistry.getDescriptors();
        int k = 0;
        while (k < providers.length) {
            this.fProviderCombo.add(providers[k].getName(), k);
            this.fComboIndexToDescriptorMap.put(k, providers[k]);
            this.addProviderControl(providers[k]);
            ++k;
        }
        this.fProviderCombo.select(0);
        this.handleProviderSelected();
    }

    protected void convertProject(IProject project, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(Messages.ConvertToSyncProjectWizardPage_convertingToSyncProject, 3);
        RemoteSyncNature.addNature((IProject)project, (IProgressMonitor)new NullProgressMonitor());
        try {
            RemoteMakeNature.updateProjectDescription((IProject)project, (String)"org.eclipse.ptp.rdt.sync.core.remoteMakeBuilder", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            StatusManager.getManager().handle(e, "org.eclipse.ptp.rdt.sync.ui");
        }
        try {
            ISynchronizeParticipant participant = this.fSelectedProvider.getParticipant();
            ServiceModelManager smm = ServiceModelManager.getInstance();
            IServiceConfiguration serviceConfig = smm.newServiceConfiguration(this.getConfigName(project.getName()));
            IService syncService = smm.getService("org.eclipse.ptp.rdt.sync.core.SyncService");
            serviceConfig.setServiceProvider(syncService, (IServiceProvider)participant.getProvider(project));
            IService buildService = smm.getService("org.eclipse.ptp.rdt.core.BuildService");
            IServiceProviderDescriptor descriptor = buildService.getProviderDescriptor("org.eclipse.ptp.rdt.sync.BuildServiceProvider");
            SyncBuildServiceProvider rbsp = (SyncBuildServiceProvider)smm.getServiceProvider(descriptor);
            if (rbsp != null) {
                IRemoteConnection remoteConnection = participant.getProvider(project).getRemoteConnection();
                rbsp.setRemoteToolsConnection(remoteConnection);
                serviceConfig.setServiceProvider(buildService, (IServiceProvider)rbsp);
            }
            smm.addConfiguration(project, serviceConfig);
            try {
                smm.saveModelConfiguration();
            }
            catch (IOException e) {
                RDTSyncUIPlugin.log(e.toString(), e);
            }
            ISyncServiceProvider provider = participant.getProvider(project);
            BuildScenario buildScenario = new BuildScenario(provider.getName(), provider.getRemoteConnection(), provider.getLocation());
            IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
            if (buildInfo == null) {
                throw new RuntimeException("Build information for project not found. Project name: " + project.getName());
            }
            IConfiguration[] allConfigs = buildInfo.getManagedProject().getConfigurations();
            String buildPath = buildScenario.getLocation();
            IConfiguration[] iConfigurationArray = allConfigs;
            int n = allConfigs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfiguration config = iConfigurationArray[n2];
                config.getToolChain().getBuilder().setBuildPath(buildPath);
                ++n2;
            }
            ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
            BuildConfigurationManager.getInstance().initProject(project, serviceConfig, buildScenario);
            try {
                BuildConfigurationManager.getInstance().saveConfigurationData();
            }
            catch (IOException iOException) {}
            monitor.done();
        }
        finally {
            monitor.done();
        }
        BuildConfigurationManager.getInstance().createLocalConfiguration(project);
    }

    public void convertProject(IProject project, IProgressMonitor monitor, String projectID) throws CoreException {
        this.convertProject(project, monitor);
    }

    public void convertProject(IProject project, String bsId, IProgressMonitor monitor) throws CoreException {
        this.convertProject(project, monitor);
    }

    public void doRun(IProgressMonitor monitor, String projectID, String bsId) throws CoreException {
        monitor.beginTask(Messages.ConvertToRemoteWizardPage_0, 2);
        super.doRun((IProgressMonitor)new SubProgressMonitor(monitor, 1), projectID, bsId);
        try {
            try {
                ServiceModelManager.getInstance().saveModelConfiguration();
            }
            catch (IOException e) {
                RDTSyncUIPlugin.log(e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    protected IServiceConfiguration getConfig(IProject project) {
        IServiceConfiguration config = this.projectConfigs.get(project);
        if (config == null) {
            config = ServiceModelManager.getInstance().newServiceConfiguration(project.getName());
            this.projectConfigs.put(project, config);
        }
        return config;
    }

    private String getConfigName(String candidateName) {
        Set configs = ServiceModelManager.getInstance().getConfigurations();
        HashSet<String> existingNames = new HashSet<String>();
        for (IServiceConfiguration config : configs) {
            existingNames.add(config.getName());
        }
        int i = 2;
        String newConfigName = candidateName;
        while (existingNames.contains(newConfigName)) {
            newConfigName = String.valueOf(candidateName) + " (" + i++ + ")";
        }
        return newConfigName;
    }

    public String getErrorMessage() {
        String errMsg = null;
        errMsg = super.getErrorMessage() != null ? super.getErrorMessage() : (this.fSelectedProvider == null ? Messages.ConvertToSyncProjectWizardPage_0 : this.fSelectedProvider.getParticipant().getErrorMessage());
        this.setPageComplete(super.validatePage() && errMsg == null);
        return errMsg;
    }

    protected String getWzDescriptionResource() {
        return "Converts a managed or unmanaged project to a synchronized project by adding a sync nature";
    }

    protected String getWzTitleResource() {
        return "Convert to a synchronized project";
    }

    private void handleProviderSelected() {
        int index = this.fProviderCombo.getSelectionIndex();
        this.fProviderStack.topControl = (Control)this.fProviderControls.get(index);
        this.fSelectedProvider = this.fComboIndexToDescriptorMap.get(index);
        this.fProviderArea.layout();
        this.update();
    }

    public boolean isCandidate(IProject project) {
        boolean a = false;
        boolean b = false;
        boolean c = false;
        a = !project.isHidden();
        try {
            b = project.hasNature("org.eclipse.cdt.core.cnature") || project.hasNature("org.eclipse.cdt.core.ccnature");
            c = !project.hasNature("org.eclipse.ptp.rdt.sync.core.remoteSyncNature");
        }
        catch (CoreException e) {
            RDTSyncUIPlugin.log(e);
        }
        return a && b && c;
    }

    private void update() {
        this.getWizard().getContainer().updateMessage();
    }
}

