/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.core;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.rm.lml.core.Preferences;
import org.eclipse.ptp.rm.lml.core.messages.Messages;
import org.eclipse.ptp.rm.lml.core.util.DebugUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.xml.sax.SAXException;

public class LMLCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.ptp.rm.lml.core";
    private static LMLCorePlugin fPlugin;
    private static Unmarshaller unmarshaller;
    private static Marshaller marshaller;
    private ResourceBundle resourceBundle;

    public static LMLCorePlugin getDefault() {
        return fPlugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = LMLCorePlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static String getUniqueIdentifier() {
        if (LMLCorePlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return LMLCorePlugin.getDefault().getBundle().getSymbolicName();
    }

    public static void log(IStatus status) {
        LMLCorePlugin.getDefault().getLog().log(status);
    }

    public static void log(String msg) {
        if (DebugUtil.RM_TRACING) {
            System.err.println(msg);
        }
        LMLCorePlugin.log((IStatus)new Status(4, LMLCorePlugin.getUniqueIdentifier(), 4, msg, null));
    }

    public static void log(Throwable e) {
        LMLCorePlugin.log((IStatus)new Status(4, LMLCorePlugin.getUniqueIdentifier(), 4, Messages.LMLCorePlugin_0, e));
    }

    public LMLCorePlugin() {
        fPlugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.eclipse.ptp.rm.lml.core.ParallelPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public Marshaller getMarshaller() {
        if (marshaller == null) {
            try {
                this.createMarshaller();
            }
            catch (JAXBException e) {
                LMLCorePlugin.log(e);
            }
        }
        return marshaller;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public Unmarshaller getUnmarshaller() {
        if (unmarshaller == null) {
            try {
                this.createUnmarshaller();
            }
            catch (JAXBException e) {
                LMLCorePlugin.log(e);
            }
            catch (MalformedURLException e) {
                LMLCorePlugin.log(e);
            }
        }
        return unmarshaller;
    }

    public String locateFragmentFile(String fragment, String file) {
        Bundle[] frags = Platform.getFragments((Bundle)Platform.getBundle((String)PLUGIN_ID));
        if (frags != null) {
            String os = Platform.getOS();
            String arch = Platform.getOSArch();
            String frag_os_arch = String.valueOf(fragment) + "." + os + "." + arch;
            Bundle[] bundleArray = frags;
            int n = frags.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle frag = bundleArray[n2];
                URL path = frag.getEntry("/");
                try {
                    String file_path;
                    File f;
                    URL local_path = FileLocator.toFileURL((URL)path);
                    String str_path = local_path.getPath();
                    int idx = str_path.indexOf(frag_os_arch);
                    if (idx > 0 && (f = new File(file_path = String.valueOf(str_path) + "bin/" + file)).exists()) {
                        return file_path;
                    }
                }
                catch (Exception exception) {}
                ++n2;
            }
        }
        return null;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.createUnmarshaller();
        DebugUtil.configurePluginDebugOptions();
        ResourcesPlugin.getWorkspace().addSaveParticipant(LMLCorePlugin.getUniqueIdentifier(), new ISaveParticipant(){

            public void doneSaving(ISaveContext saveContext) {
            }

            public void prepareToSave(ISaveContext saveContext) throws CoreException {
            }

            public void rollback(ISaveContext saveContext) {
            }

            public void saving(ISaveContext saveContext) throws CoreException {
                Preferences.savePreferences(LMLCorePlugin.getUniqueIdentifier());
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        try {
            Preferences.savePreferences(LMLCorePlugin.getUniqueIdentifier());
            ResourcesPlugin.getWorkspace().removeSaveParticipant(LMLCorePlugin.getUniqueIdentifier());
        }
        finally {
            super.stop(context);
            fPlugin = null;
        }
    }

    private void createMarshaller() throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((String)"org.eclipse.ptp.rm.lml.internal.core.elements", (ClassLoader)LMLCorePlugin.class.getClassLoader());
        marshaller = jc.createMarshaller();
    }

    private void createUnmarshaller() throws MalformedURLException, JAXBException {
        URL xsd = this.getBundle().getEntry("/schema/lgui.xsd");
        JAXBContext jc = JAXBContext.newInstance((String)"org.eclipse.ptp.rm.lml.internal.core.elements", (ClassLoader)LMLCorePlugin.class.getClassLoader());
        unmarshaller = jc.createUnmarshaller();
        if (xsd != null) {
            Schema mySchema;
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            try {
                mySchema = sf.newSchema(xsd);
            }
            catch (SAXException sAXException) {
                mySchema = null;
            }
            unmarshaller.setSchema(mySchema);
        }
    }
}

