/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.internal.core.model;

import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.eclipse.ptp.rm.lml.core.events.ILguiUpdatedEvent;
import org.eclipse.ptp.rm.lml.core.listeners.ILguiListener;
import org.eclipse.ptp.rm.lml.core.model.ILguiItem;
import org.eclipse.ptp.rm.lml.internal.core.elements.AbslayoutType;
import org.eclipse.ptp.rm.lml.internal.core.elements.GobjectType;
import org.eclipse.ptp.rm.lml.internal.core.elements.InfoType;
import org.eclipse.ptp.rm.lml.internal.core.elements.InfodataType;
import org.eclipse.ptp.rm.lml.internal.core.elements.InformationType;
import org.eclipse.ptp.rm.lml.internal.core.elements.LayoutType;
import org.eclipse.ptp.rm.lml.internal.core.elements.LguiType;
import org.eclipse.ptp.rm.lml.internal.core.elements.ObjectsType;
import org.eclipse.ptp.rm.lml.internal.core.elements.SplitlayoutType;
import org.eclipse.ptp.rm.lml.internal.core.model.LguiHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OverviewAccess
extends LguiHandler {
    public OverviewAccess(ILguiItem lguiItem, LguiType lgui) {
        super(lguiItem, lgui);
        this.lguiItem.addListener(new ILguiListener(){

            public void handleEvent(ILguiUpdatedEvent e) {
                OverviewAccess.this.update(e.getLgui());
            }
        });
    }

    public List<AbslayoutType> getAbslayouts() {
        LinkedList<AbslayoutType> layouts = new LinkedList<AbslayoutType>();
        for (LayoutType tag : this.getLayouts()) {
            if (!(tag instanceof AbslayoutType)) continue;
            layouts.add((AbslayoutType)tag);
        }
        return layouts;
    }

    public List<GobjectType> getGraphicalObjects() {
        LinkedList<GobjectType> objects = new LinkedList<GobjectType>();
        for (JAXBElement<?> tag : this.lgui.getObjectsAndRelationsAndInformation()) {
            if (!(tag.getValue() instanceof GobjectType)) continue;
            objects.add((GobjectType)tag.getValue());
        }
        return objects;
    }

    public String getInfodataValue(InfoType info, String key) {
        for (InfodataType data : info.getData()) {
            if (!data.getKey().equals(key)) continue;
            return data.getValue();
        }
        return null;
    }

    public List<InformationType> getInformations() {
        LinkedList<InformationType> informations = new LinkedList<InformationType>();
        for (JAXBElement<?> tag : this.lgui.getObjectsAndRelationsAndInformation()) {
            if (!(tag.getValue() instanceof InformationType)) continue;
            informations.add((InformationType)tag.getValue());
        }
        return informations;
    }

    public List<LayoutType> getLayouts() {
        LinkedList<LayoutType> layouts = new LinkedList<LayoutType>();
        for (JAXBElement<?> tag : this.lgui.getObjectsAndRelationsAndInformation()) {
            if (!(tag.getValue() instanceof LayoutType)) continue;
            layouts.add((LayoutType)tag.getValue());
        }
        return layouts;
    }

    public List<ObjectsType> getObjects() {
        LinkedList<ObjectsType> objects = new LinkedList<ObjectsType>();
        for (JAXBElement<?> tag : this.lgui.getObjectsAndRelationsAndInformation()) {
            if (!(tag.getValue() instanceof ObjectsType)) continue;
            objects.add((ObjectsType)tag.getValue());
        }
        return objects;
    }

    public String getOIDByJobId(String jobId) {
        List<InformationType> listInformation = this.getInformations();
        for (InformationType information : listInformation) {
            List<InfoType> listInfo = information.getInfo();
            for (InfoType info : listInfo) {
                List<InfodataType> listData = info.getData();
                for (InfodataType data : listData) {
                    if (!data.getKey().equals("step") || data.getValue().indexOf(jobId) == -1) continue;
                    return info.getOid();
                }
            }
        }
        return null;
    }

    public List<SplitlayoutType> getSplitlayouts() {
        LinkedList<SplitlayoutType> tables = new LinkedList<SplitlayoutType>();
        for (LayoutType tag : this.getLayouts()) {
            if (!(tag instanceof SplitlayoutType)) continue;
            tables.add((SplitlayoutType)tag);
        }
        return tables;
    }
}

