/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.services.ui.wizards;

import java.util.ArrayList;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ptp.services.core.IService;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.ptp.services.core.IServiceProviderDescriptor;
import org.eclipse.ptp.services.core.ServiceModelManager;
import org.eclipse.ptp.services.ui.IServiceProviderContributor;
import org.eclipse.ptp.services.ui.ServiceModelUIManager;
import org.eclipse.ptp.services.ui.messages.Messages;
import org.eclipse.ptp.services.ui.wizards.ServiceConfigurationWizard;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ServiceConfigurationWizardPage
extends WizardPage {
    private final IService fService;
    private IWizard fChildWizard = null;
    private ArrayList<IServiceProviderDescriptor> fProviderComboList = new ArrayList();

    public ServiceConfigurationWizardPage(IService service, String pageName) {
        super(pageName);
        this.fService = service;
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        this.setControl((Control)container);
        Label providerLabel = new Label(container, 16384);
        providerLabel.setText(Messages.ServiceConfigurationWizardPage_0);
        final Combo providerCombo = new Combo(container, 12);
        providerCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        providerCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ServiceConfigurationWizardPage.this.handleComboSelection(providerCombo);
            }
        });
        this.createComboContents(providerCombo);
    }

    public IWizardPage getNextPage() {
        if (this.fChildWizard != null) {
            return this.fChildWizard.getStartingPage();
        }
        return super.getNextPage();
    }

    private void handleComboSelection(Combo combo) {
        int index = combo.getSelectionIndex();
        IServiceProvider provider = ServiceModelManager.getInstance().getServiceProvider(this.fProviderComboList.get(index));
        IServiceConfiguration config = ((ServiceConfigurationWizard)this.getWizard()).getServiceConfiguration();
        config.setServiceProvider(this.getService(), provider);
        this.fChildWizard = null;
        if (!provider.isConfigured()) {
            IWizardPage page = this.getNextPage();
            IServiceProviderContributor contrib = ServiceModelUIManager.getInstance().getServiceProviderContributor((IServiceProviderDescriptor)provider);
            if (contrib != null) {
                this.fChildWizard = contrib.getWizard(provider, page);
            }
        }
        this.setPageComplete(true);
    }

    protected void createComboContents(Combo combo) {
        IServiceConfiguration config = ((ServiceConfigurationWizard)this.getWizard()).getServiceConfiguration();
        IServiceProvider provider = config.getServiceProvider(this.getService());
        int index = 0;
        int selection = 0;
        combo.removeAll();
        for (IServiceProviderDescriptor descriptor : this.getService().getProvidersByPriority()) {
            combo.add(descriptor.getName());
            this.fProviderComboList.add(index, descriptor);
            if (descriptor.getId().equals(provider.getId())) {
                selection = index;
            }
            ++index;
        }
        combo.select(selection);
        this.handleComboSelection(combo);
    }

    protected IService getService() {
        return this.fService;
    }
}

