/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch.rulesengine;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.launch.internal.rulesengine.DownloadBackAction;
import org.eclipse.ptp.launch.internal.rulesengine.DownloadBackRule;
import org.eclipse.ptp.launch.internal.rulesengine.DownloadRule;
import org.eclipse.ptp.launch.internal.rulesengine.DownloadRuleAction;
import org.eclipse.ptp.launch.internal.rulesengine.UploadRule;
import org.eclipse.ptp.launch.internal.rulesengine.UploadRuleAction;
import org.eclipse.ptp.launch.rulesengine.ILaunchProcessCallback;
import org.eclipse.ptp.launch.rulesengine.IRuleAction;
import org.eclipse.ptp.launch.rulesengine.ISynchronizationRule;

public class RuleActionFactory {
    private final ILaunchProcessCallback process;
    private final ILaunchConfiguration configuration;
    private final IProgressMonitor monitor;

    public RuleActionFactory(ILaunchConfiguration configuration, ILaunchProcessCallback process, IProgressMonitor monitor) {
        this.process = process;
        this.configuration = configuration;
        this.monitor = monitor;
    }

    public IRuleAction getAction(ISynchronizationRule rule) throws CoreException {
        if (rule instanceof DownloadRule) {
            DownloadRule downloadRule = (DownloadRule)rule;
            DownloadRuleAction action = new DownloadRuleAction(this.process, this.configuration, downloadRule, this.monitor);
            return action;
        }
        if (rule instanceof UploadRule) {
            UploadRule uploadRule = (UploadRule)rule;
            UploadRuleAction action = new UploadRuleAction(this.process, this.configuration, uploadRule, this.monitor);
            return action;
        }
        if (rule instanceof DownloadBackRule) {
            DownloadBackRule uploadRule = (DownloadBackRule)rule;
            DownloadBackAction action = new DownloadBackAction(this.process, this.configuration, uploadRule, this.monitor);
            return action;
        }
        Assert.isLegal((boolean)false);
        return null;
    }
}

