/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.internal.common;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.ptp.remotetools.core.IRemoteScript;

public class RemoteScript
implements IRemoteScript {
    private final List<String> environment = new ArrayList<String>();
    private boolean willForwardX11;
    private InputStream inputStream = null;
    private OutputStream outputStream = null;
    private OutputStream errorStream = null;
    private String[] script;
    private boolean fetchProcessErrorStream = false;
    private boolean fetchProcessInputStream = false;
    private boolean fetchProcessOutputStream = false;
    private boolean allocateTerminal = false;

    public void addEnvironment(String variable) {
        this.environment.add(variable);
    }

    public void addEnvironment(String[] variables) {
        this.environment.addAll(Arrays.asList(variables));
    }

    public boolean getAllocateTerminal() {
        return this.allocateTerminal;
    }

    public OutputStream getErrorStream() {
        return this.errorStream;
    }

    public boolean getFetchProcessErrorStream() {
        return this.fetchProcessErrorStream;
    }

    public boolean getFetchProcessInputStream() {
        return this.fetchProcessInputStream;
    }

    public boolean getFetchProcessOutputStream() {
        return this.fetchProcessOutputStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public String getScriptString() {
        if (this.script == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (String env : this.environment) {
            sb.append("export \"" + env + "\"; ");
        }
        int i = 0;
        while (i < this.script.length) {
            sb.append(String.valueOf(this.script[i]) + "; ");
            ++i;
        }
        return sb.toString();
    }

    public void setAllocateTerminal(boolean flag) {
        this.allocateTerminal = flag;
    }

    public void setFetchProcessErrorStream(boolean flag) {
        this.fetchProcessErrorStream = flag;
        this.errorStream = null;
    }

    public void setFetchProcessInputStream(boolean flag) {
        this.fetchProcessInputStream = flag;
        this.inputStream = null;
    }

    public void setFetchProcessOutputStream(boolean flag) {
        this.fetchProcessOutputStream = flag;
        this.outputStream = null;
    }

    public void setForwardX11(boolean willForward) {
        this.willForwardX11 = willForward;
    }

    public void setProcessErrorStream(OutputStream output) {
        this.errorStream = output;
        this.fetchProcessErrorStream = false;
    }

    public void setProcessInputStream(InputStream input) {
        this.inputStream = input;
        this.fetchProcessInputStream = false;
    }

    public void setProcessOutputStream(OutputStream output) {
        this.outputStream = output;
        this.fetchProcessOutputStream = false;
    }

    public void setScript(String script) {
        this.script = new String[1];
        this.script[0] = script;
    }

    public void setScript(String[] script) {
        this.script = script;
    }

    public boolean willForwardX11() {
        return this.willForwardX11;
    }
}

