/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.internal.ssh;

import com.jcraft.jsch.ChannelExec;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.ptp.remotetools.core.IRemotePathTools;
import org.eclipse.ptp.remotetools.core.IRemoteUploadExecution;
import org.eclipse.ptp.remotetools.core.messages.Messages;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.ptp.remotetools.internal.common.Debug;
import org.eclipse.ptp.remotetools.internal.ssh.ExecutionManager;
import org.eclipse.ptp.remotetools.internal.ssh.KillableExecution;

public class UploadExecution
extends KillableExecution
implements IRemoteUploadExecution {
    String remoteFile;
    InputStream sourceStream;
    ByteArrayOutputStream errorStream;
    OutputStream outputStream;

    public UploadExecution(ExecutionManager executionManager, String remoteFile, InputStream source) throws RemoteConnectionException {
        super(executionManager);
        this.sourceStream = source;
        this.remoteFile = remoteFile;
        this.errorStream = new ByteArrayOutputStream();
    }

    public OutputStream getOutputStreamToProcessRemoteFile() {
        if (this.sourceStream != null) {
            throw new IllegalStateException();
        }
        return this.outputStream;
    }

    public void startExecution() throws RemoteConnectionException {
        ChannelExec channel = this.createChannel(false);
        IRemotePathTools pathTool = this.getExecutionManager().getRemotePathTools();
        this.setCommandLine("cat >" + pathTool.quote(this.remoteFile, true));
        if (this.sourceStream != null) {
            channel.setInputStream(this.sourceStream);
            this.outputStream = null;
        } else {
            try {
                this.outputStream = channel.getOutputStream();
            }
            catch (IOException e) {
                throw new RemoteConnectionException(Messages.UploadExecution_StartExecution_FailedCreateUpload, e);
            }
        }
        channel.setErrStream((OutputStream)this.errorStream);
        super.startExecution();
        Debug.println("Uploading " + this.remoteFile);
    }

    public String getErrorMessage() {
        return this.errorStream.toString();
    }
}

