/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.provider.IIndexProvider;
import org.eclipse.cdt.core.index.provider.IReadOnlyPDOMProvider;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.index.provider.IIndexFragmentProvider;
import org.eclipse.cdt.internal.core.index.provider.Messages;
import org.eclipse.cdt.internal.core.index.provider.ReadOnlyPDOMProviderBridge;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IndexProviderManager
implements IElementChangedListener {
    private static final String ELEMENT_RO_PDOM_PROVIDER = "ReadOnlyPDOMProvider";
    private static final String ATTRIBUTE_CLASS = "class";
    private IIndexFragmentProvider[] allProviders;
    private Map<ProvisionMapKey, Boolean> provisionMap;
    private Set<String> compatibleFragmentUnavailable;
    private VersionRange pdomVersionRange;

    public IndexProviderManager() {
        this.reset();
    }

    public void reset() {
        Version minVersion = Version.parseVersion((String)PDOM.versionString(PDOM.getMinSupportedVersion()));
        Version maxVersion = Version.parseVersion((String)PDOM.versionString(PDOM.getMaxSupportedVersion()));
        this.reset(new VersionRange(minVersion, true, maxVersion, true));
    }

    public void reset(VersionRange pdomVersionRange) {
        this.allProviders = new IIndexFragmentProvider[0];
        this.provisionMap = new HashMap<ProvisionMapKey, Boolean>();
        this.pdomVersionRange = pdomVersionRange;
        this.compatibleFragmentUnavailable = new HashSet<String>();
    }

    public void startup() {
        ArrayList<ReadOnlyPDOMProviderBridge> providers = new ArrayList<ReadOnlyPDOMProviderBridge>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint indexProviders = registry.getExtensionPoint("org.eclipse.cdt.core.CIndex");
        IExtension[] iExtensionArray = indexProviders.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            try {
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (ELEMENT_RO_PDOM_PROVIDER.equals(element.getName())) {
                        Object provider = element.createExecutableExtension(ATTRIBUTE_CLASS);
                        if (provider instanceof IReadOnlyPDOMProvider) {
                            providers.add(new ReadOnlyPDOMProviderBridge((IReadOnlyPDOMProvider)provider));
                        } else {
                            CCorePlugin.log((String)NLS.bind((String)Messages.IndexProviderManager_0, (Object)extension.getContributor().getName()));
                        }
                    }
                    ++n4;
                }
            }
            catch (CoreException e) {
                CCorePlugin.log((Throwable)e);
            }
            ++n2;
        }
        CoreModel.getDefault().addElementChangedListener((IElementChangedListener)this);
        this.allProviders = providers.toArray(new IIndexFragmentProvider[providers.size()]);
    }

    public IIndexFragment[] getProvidedIndexFragments(ICConfigurationDescription config) throws CoreException {
        HashMap<String, IIndexFragment> id2fragment = new HashMap<String, IIndexFragment>();
        IProject project = config.getProjectDescription().getProject();
        IIndexFragmentProvider[] iIndexFragmentProviderArray = this.allProviders;
        int n = this.allProviders.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                IIndexFragmentProvider provider = iIndexFragmentProviderArray[n2];
                try {
                    IIndexFragment[] fragments;
                    if (!this.providesForProject(provider, project)) break block9;
                    IIndexFragment[] iIndexFragmentArray = fragments = provider.getIndexFragments(config);
                    int n3 = fragments.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IIndexFragment fragment = iIndexFragmentArray[n4];
                        try {
                            this.processCandidate(id2fragment, fragment);
                        }
                        catch (InterruptedException e) {
                            CCorePlugin.log((Throwable)e);
                        }
                        catch (CoreException e) {
                            CCorePlugin.log((Throwable)e);
                        }
                        ++n4;
                    }
                }
                catch (CoreException e) {
                    CCorePlugin.log((Throwable)e);
                }
            }
            ++n2;
        }
        ArrayList<IIndexFragment> preresult = new ArrayList<IIndexFragment>();
        for (Map.Entry entry : id2fragment.entrySet()) {
            if (entry.getValue() == null) {
                String key = (String)entry.getKey();
                if (this.compatibleFragmentUnavailable.contains(key)) continue;
                String msg = NLS.bind((String)Messages.IndexProviderManager_NoCompatibleFragmentsAvailable, (Object)key);
                CCorePlugin.log((IStatus)new Status(2, "org.eclipse.cdt.core", msg));
                this.compatibleFragmentUnavailable.add(key);
                continue;
            }
            preresult.add((IIndexFragment)entry.getValue());
        }
        return preresult.toArray(new IIndexFragment[preresult.size()]);
    }

    private VersionRange getCurrentlySupportedVersionRangeForFormat(String formatID) {
        if (!"org.eclipse.cdt.internal.core.pdom.PDOM".equals(formatID)) {
            throw new IllegalArgumentException("Non-PDOM formats are currently unsupported");
        }
        return this.pdomVersionRange;
    }

    private void processCandidate(Map<String, IIndexFragment> id2fragment, IIndexFragment candidate) throws InterruptedException, CoreException {
        String cid = null;
        String csver = null;
        String cformatID = null;
        candidate.acquireReadLock();
        try {
            cid = candidate.getProperty("org.eclipse.cdt.internal.core.index.fragment.id");
            csver = candidate.getProperty("org.eclipse.cdt.internal.core.index.fragment.format.version");
            cformatID = candidate.getProperty("org.eclipse.cdt.internal.core.index.fragment.format.id");
        }
        finally {
            candidate.releaseReadLock();
        }
        assert (cid != null && csver != null && cformatID != null);
        Version cver = Version.parseVersion((String)csver);
        IIndexFragment existing = id2fragment.get(cid);
        if (this.getCurrentlySupportedVersionRangeForFormat(cformatID).isIncluded(cver)) {
            if (existing != null) {
                Version ever;
                String esver = null;
                String eformatID = null;
                existing.acquireReadLock();
                try {
                    esver = existing.getProperty("org.eclipse.cdt.internal.core.index.fragment.format.version");
                    eformatID = existing.getProperty("org.eclipse.cdt.internal.core.index.fragment.format.id");
                }
                finally {
                    existing.releaseReadLock();
                }
                if (eformatID.equals(cformatID) && (ever = Version.parseVersion((String)esver)).compareTo(cver) < 0) {
                    id2fragment.put(cid, candidate);
                }
            } else {
                id2fragment.put(cid, candidate);
            }
        } else if (existing == null) {
            id2fragment.put(cid, null);
        }
    }

    public void addIndexProvider(IIndexProvider provider) {
        if (!(provider instanceof IIndexFragmentProvider)) {
            CCorePlugin.log((String)"An unknown index provider implementation was plugged in to the CIndex extension point");
            return;
        }
        IIndexFragmentProvider[] newAllProviders = new IIndexFragmentProvider[this.allProviders.length + 1];
        System.arraycopy(this.allProviders, 0, newAllProviders, 0, this.allProviders.length);
        newAllProviders[this.allProviders.length] = (IIndexFragmentProvider)provider;
        this.allProviders = newAllProviders;
    }

    public void removeIndexProvider(IIndexProvider provider) {
        ArrayUtil.remove(this.allProviders, provider);
        if (this.allProviders[this.allProviders.length - 1] == null) {
            IIndexFragmentProvider[] newAllProviders = new IIndexFragmentProvider[this.allProviders.length - 1];
            System.arraycopy(this.allProviders, 0, newAllProviders, 0, this.allProviders.length - 1);
            this.allProviders = newAllProviders;
        }
    }

    private boolean providesForProject(IIndexProvider provider, IProject project) {
        ProvisionMapKey key = new ProvisionMapKey(provider, project);
        if (!this.provisionMap.containsKey(key)) {
            try {
                ICProject cproject = CoreModel.getDefault().create(project);
                this.provisionMap.put(key, new Boolean(provider.providesFor(cproject)));
            }
            catch (CoreException e) {
                CCorePlugin.log((Throwable)e);
                this.provisionMap.put(key, Boolean.FALSE);
            }
        }
        return this.provisionMap.get(key);
    }

    public void elementChanged(ElementChangedEvent event) {
        try {
            if (event.getType() == 1) {
                this.processDelta(event.getDelta());
            }
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
        }
    }

    private void processDelta(ICElementDelta delta) throws CoreException {
        int type = delta.getElement().getElementType();
        switch (type) {
            case 10: {
                ICElementDelta[] children = delta.getAffectedChildren();
                int i = 0;
                while (i < children.length) {
                    this.processDelta(children[i]);
                    ++i;
                }
                break;
            }
            case 11: {
                ICProject cproject = (ICProject)delta.getElement();
                switch (delta.getKind()) {
                    case 2: {
                        ArrayList<ProvisionMapKey> toRemove = new ArrayList<ProvisionMapKey>();
                        for (ProvisionMapKey key : this.provisionMap.keySet()) {
                            if (!key.getProject().equals((Object)cproject.getProject())) continue;
                            toRemove.add(key);
                        }
                        for (ProvisionMapKey key : toRemove) {
                            this.provisionMap.remove(key);
                        }
                    }
                }
            }
        }
    }

    private static class ProvisionMapKey {
        private final IIndexProvider provider;
        private final IProject project;

        ProvisionMapKey(IIndexProvider provider, IProject project) {
            this.provider = provider;
            this.project = project;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ProvisionMapKey) {
                ProvisionMapKey other = (ProvisionMapKey)obj;
                return other.project.equals((Object)this.project) && other.provider.equals(this.provider);
            }
            return false;
        }

        public int hashCode() {
            return this.project.hashCode() ^ this.provider.hashCode();
        }

        public IProject getProject() {
            return this.project;
        }
    }
}

