/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.TreeSet;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;
import org.eclipse.ptp.remote.ui.IRemoteUIConnectionManager;
import org.eclipse.ptp.remote.ui.IRemoteUIFileManager;
import org.eclipse.ptp.remote.ui.IRemoteUIServices;
import org.eclipse.ptp.remote.ui.PTPRemoteUIPlugin;
import org.eclipse.ptp.rm.core.rmsystem.IRemoteResourceManagerConfiguration;
import org.eclipse.ptp.rm.ui.messages.Messages;
import org.eclipse.ptp.rm.ui.wizards.AbstractProxyOptions;
import org.eclipse.ptp.rm.ui.wizards.DefaultProxyOptions;
import org.eclipse.ptp.ui.preferences.ScrolledPageContent;
import org.eclipse.ptp.ui.wizards.IRMConfigurationWizard;
import org.eclipse.ptp.ui.wizards.RMConfigurationWizardPage;
import org.eclipse.ptp.utils.ui.swt.SWTUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.progress.UIJob;

public abstract class AbstractRemoteProxyResourceManagerConfigurationWizardPage
extends RMConfigurationWizardPage {
    public static final String EMPTY_STRING = "";
    public static final int VALIDATE_TIMER = 250;
    protected String proxyPath = "";
    protected String localAddr = "";
    protected IRemoteServices remoteServices = null;
    protected IRemoteServices[] fAllRemoteServices = null;
    protected IRemoteConnectionManager connectionManager = null;
    protected IRemoteUIConnectionManager uiConnectionManager = null;
    protected IRemoteConnection connection = null;
    protected boolean loading = true;
    protected boolean isValid;
    protected boolean muxPortFwd = false;
    protected boolean portFwdSupported = true;
    protected boolean proxyPathIsValid = true;
    protected boolean manualLaunch = false;
    protected final Job validateJob = new ValidateJob();
    protected final WidgetListener listener = new WidgetListener();
    protected Text proxyPathText = null;
    protected Text optionsText = null;
    protected Button browseButton = null;
    protected Button noneButton = null;
    protected Button portForwardingButton = null;
    protected Button manualButton = null;
    protected Button newConnectionButton;
    protected Combo remoteCombo;
    protected Combo connectionCombo;
    protected Combo localAddrCombo;
    protected boolean proxyPathEnabled = true;
    protected boolean proxyOptionsEnabled = true;
    protected boolean fManualLaunchEnabled = true;
    protected AbstractProxyOptions fProxyOptions;

    public AbstractRemoteProxyResourceManagerConfigurationWizardPage(IRMConfigurationWizard wizard, String title) {
        super(wizard, title);
        this.setPageComplete(false);
        this.isValid = false;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.marginHeight = 0;
        topLayout.marginWidth = 0;
        composite.setLayout((Layout)topLayout);
        Composite pageContent = this.createContents(composite);
        pageContent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setControl((Control)composite);
    }

    public boolean performOk() {
        this.store();
        int options = 0;
        if (this.muxPortFwd) {
            options |= 2;
        }
        if (this.manualLaunch) {
            options |= 4;
        }
        if (this.remoteServices != null) {
            this.getConfiguration().setRemoteServicesId(this.remoteServices.getId());
        }
        if (this.connection != null) {
            this.getConfiguration().setConnectionName(this.connection.getName());
        }
        this.getConfiguration().setLocalAddress(this.localAddr);
        this.getConfiguration().setProxyServerPath(this.proxyPath);
        this.getConfiguration().setOptions(options);
        this.fProxyOptions.save();
        return true;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.initContents();
        }
        super.setVisible(visible);
    }

    private void checkConnection() {
        if (!this.connection.isOpen()) {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        AbstractRemoteProxyResourceManagerConfigurationWizardPage.this.connection.open(monitor);
                        if (monitor.isCanceled()) {
                            throw new InterruptedException(Messages.AbstractRemoteProxyResourceManagerConfigurationWizardPage_0);
                        }
                    }
                    catch (RemoteConnectionException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            try {
                new ProgressMonitorDialog(this.getShell()).run(true, true, op);
            }
            catch (InvocationTargetException e) {
                ErrorDialog.openError((Shell)this.getShell(), (String)Messages.AbstractRemoteProxyResourceManagerConfigurationWizardPage_1, (String)Messages.AbstractRemoteProxyResourceManagerConfigurationWizardPage_2, (IStatus)new Status(4, "org.eclipse.ptp.rm.ui", e.getCause().getMessage()));
            }
            catch (InterruptedException e) {
                ErrorDialog.openError((Shell)this.getShell(), (String)Messages.AbstractRemoteProxyResourceManagerConfigurationWizardPage_3, (String)Messages.AbstractRemoteProxyResourceManagerConfigurationWizardPage_2, (IStatus)new Status(4, "org.eclipse.ptp.rm.ui", e.getMessage()));
            }
        }
    }

    private Composite createContents(Composite parent) {
        ScrolledPageContent pageContent = new ScrolledPageContent(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Composite composite = pageContent.getBody();
        composite.setLayout((Layout)layout);
        Composite remoteComp = new Composite(composite, 0);
        GridLayout remoteLayout = new GridLayout();
        remoteLayout.numColumns = 4;
        remoteLayout.marginWidth = 0;
        remoteComp.setLayout((Layout)remoteLayout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 4;
        remoteComp.setLayoutData((Object)gd);
        pageContent.adaptChild((Control)remoteComp);
        Label label = new Label(remoteComp, 0);
        label.setText(Messages.AbstractRemoteProxyResourceManagerConfigurationWizardPage_4);
        gd = new GridData();
        gd.horizontalSpan = 1;
        label.setLayoutData((Object)gd);
        this.remoteCombo = new Combo(remoteComp, 12);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.remoteCombo.setLayoutData((Object)gd);
        label = new Label(remoteComp, 0);
        label.setText(Messages.AbstractRemoteProxyResourceManagerConfigurationWizardPage_5);
        gd = new GridData();
        gd.horizontalSpan = 1;
        label.setLayoutData((Object)gd);
        this.connectionCombo = new Combo(remoteComp, 12);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.connectionCombo.setLayoutData((Object)gd);
        this.newConnectionButton = SWTUtil.createPushButton((Composite)remoteComp, (String)Messages.AbstractRemoteProxyResourceManagerConfigurationWizardPage_6, null);
        if (this.proxyPathEnabled) {
            label = new Label(remoteComp, 0);
            label.setText(Messages.AbstractRemoteProxyResourceManagerConfigurationWizardPage_7);
            gd = new GridData();
            gd.horizontalSpan = 1;
            label.setLayoutData((Object)gd);
            this.proxyPathText = new Text(remoteComp, 2052);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            gd.grabExcessHorizontalSpace = true;
            gd.widthHint = 100;
            this.proxyPathText.setLayoutData((Object)gd);
            this.proxyPathText.addModifyListener((ModifyListener)this.listener);
            this.browseButton = SWTUtil.createPushButton((Composite)remoteComp, (String)Messages.AbstractRemoteProxyResourceManagerConfigurationWizardPage_8, null);
            this.browseButton.addSelectionListener((SelectionListener)this.listener);
        }
        this.addCustomWidgets(remoteComp);
        if (this.proxyOptionsEnabled) {
            ExpandableComposite proxyOptionsArea = new ExpandableComposite(composite, 0, 18);
            proxyOptionsArea.setText(Messages.AbstractRemoteProxyResourceManagerConfigurationWizardPage_ProxyOptions);
            proxyOptionsArea.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent e) {
                    ScrolledPageContent parent = AbstractRemoteProxyResourceManagerConfigurationWizardPage.this.getParentScrolledComposite((Control)((ExpandableComposite)e.getSource()));
                    if (parent != null) {
                        parent.reflow(true);
                    }
                }
            });
            proxyOptionsArea.setLayoutData((Object)this.spanGridData(768, 4));
            pageContent.adaptChild((Control)proxyOptionsArea);
            this.fProxyOptions = this.createProxyOptions((WizardPage)this, this.getConfiguration());
            this.fProxyOptions.setRemoteConnection(this.connection);
            Composite optionsComp = this.fProxyOptions.createContents((Composite)proxyOptionsArea);
            proxyOptionsArea.setClient((Control)optionsComp);
        }
        ExpandableComposite advancedOptionsArea = new ExpandableComposite(composite, 0, 18);
        advancedOptionsArea.setText(Messages.AbstractRemoteResourceManagerConfigurationWizardPage_AdvancedOptions);
        advancedOptionsArea.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                ScrolledPageContent parent = AbstractRemoteProxyResourceManagerConfigurationWizardPage.this.getParentScrolledComposite((Control)((ExpandableComposite)e.getSource()));
                if (parent != null) {
                    parent.reflow(true);
                }
            }
        });
        advancedOptionsArea.setLayoutData((Object)this.spanGridData(768, 4));
        pageContent.adaptChild((Control)advancedOptionsArea);
        Composite advancedOptionsComp = new Composite((Composite)advancedOptionsArea, 0);
        layout = new GridLayout();
        advancedOptionsComp.setLayout((Layout)layout);
        advancedOptionsArea.setClient((Control)advancedOptionsComp);
        Group mxGroup = new Group(advancedOptionsComp, 16);
        mxGroup.setLayout((Layout)this.createGridLayout(1, true, 10, 10));
        mxGroup.setLayoutData((Object)this.spanGridData(768, 2));
        mxGroup.setText(Messages.AbstractRemoteProxyResourceManagerConfigurationWizardPage_10);
        this.noneButton = this.createRadioButton((Composite)mxGroup, Messages.AbstractRemoteProxyResourceManagerConfigurationWizardPage_11, "mxGroup", (SelectionListener)this.listener);
        this.noneButton.addSelectionListener((SelectionListener)this.listener);
        Composite addrComp = new Composite((Composite)mxGroup, 0);
        GridLayout addrLayout = new GridLayout();
        addrLayout.numColumns = 2;
        addrLayout.marginWidth = 0;
        addrLayout.marginLeft = 15;
        addrComp.setLayout((Layout)addrLayout);
        gd = new GridData(768);
        addrComp.setLayoutData((Object)gd);
        label = new Label(addrComp, 0);
        label.setText(Messages.AbstractRemoteProxyResourceManagerConfigurationWizardPage_12);
        gd = new GridData();
        gd.horizontalSpan = 1;
        label.setLayoutData((Object)gd);
        this.localAddrCombo = new Combo(addrComp, 4);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.localAddrCombo.setLayoutData((Object)gd);
        this.portForwardingButton = this.createRadioButton((Composite)mxGroup, Messages.AbstractRemoteProxyResourceManagerConfigurationWizardPage_13, "mxGroup", (SelectionListener)this.listener);
        this.portForwardingButton.addSelectionListener((SelectionListener)this.listener);
        if (this.fManualLaunchEnabled) {
            this.manualButton = this.createCheckButton(advancedOptionsComp, "Launch server manually");
            this.manualButton.addSelectionListener((SelectionListener)this.listener);
        }
        this.registerListeners();
        return pageContent;
    }

    private String fixHostName(String hostname) {
        try {
            if (hostname.endsWith(".in-addr.arpa")) {
                return InetAddress.getLocalHost().getHostAddress();
            }
        }
        catch (UnknownHostException unknownHostException) {}
        return hostname;
    }

    private void initializeLocalHostCombo() {
        TreeSet<String> addrs = new TreeSet<String>();
        try {
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            while (netInterfaces.hasMoreElements()) {
                NetworkInterface ni = netInterfaces.nextElement();
                Enumeration<InetAddress> alladdr = ni.getInetAddresses();
                while (alladdr.hasMoreElements()) {
                    InetAddress ip = alladdr.nextElement();
                    if (!(ip instanceof Inet4Address)) continue;
                    addrs.add(this.fixHostName(ip.getCanonicalHostName()));
                }
            }
        }
        catch (Exception exception) {}
        if (addrs.size() == 0) {
            addrs.add("localhost");
        }
        this.localAddrCombo.removeAll();
        int index = 0;
        int selection = -1;
        for (String addr : addrs) {
            this.localAddrCombo.add(addr);
            if (this.localAddr.equals(EMPTY_STRING) && addr.equals("localhost") || addr.equals(this.localAddr)) {
                selection = index;
            }
            ++index;
        }
        if (selection < 0) {
            if (!this.localAddr.equals(EMPTY_STRING)) {
                this.localAddrCombo.add(this.localAddr);
            }
            selection = this.localAddrCombo.getItemCount() - 1;
        }
        this.localAddrCombo.select(selection);
    }

    private void loadSaved() {
        int options;
        this.proxyPath = this.getConfiguration().getProxyServerPath();
        this.localAddr = this.getConfiguration().getLocalAddress();
        String rmID = this.getConfiguration().getRemoteServicesId();
        if (rmID != null) {
            IWizardContainer container = null;
            if (this.getControl().isVisible()) {
                container = this.getWizard().getContainer();
            }
            this.remoteServices = PTPRemoteUIPlugin.getDefault().getRemoteServices(rmID, (IRunnableContext)container);
            String conn = this.getConfiguration().getConnectionName();
            if (this.remoteServices != null && conn != null) {
                this.connection = this.remoteServices.getConnectionManager().getConnection(conn);
            }
        }
        this.muxPortFwd = ((options = this.getConfiguration().getOptions()) & 2) == 2;
        this.manualLaunch = (options & 4) == 4;
    }

    private void registerListeners() {
        this.remoteCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (AbstractRemoteProxyResourceManagerConfigurationWizardPage.this.loading) {
                    AbstractRemoteProxyResourceManagerConfigurationWizardPage.this.handleRemoteServiceSelected(AbstractRemoteProxyResourceManagerConfigurationWizardPage.this.connection);
                } else {
                    AbstractRemoteProxyResourceManagerConfigurationWizardPage.this.handleRemoteServiceSelected(null);
                }
                AbstractRemoteProxyResourceManagerConfigurationWizardPage.this.updateSettings();
            }
        });
        this.connectionCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractRemoteProxyResourceManagerConfigurationWizardPage.this.handleConnectionSelected();
                AbstractRemoteProxyResourceManagerConfigurationWizardPage.this.updatePage();
            }
        });
        this.newConnectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                AbstractRemoteProxyResourceManagerConfigurationWizardPage.this.handleNewRemoteConnectionSelected();
                AbstractRemoteProxyResourceManagerConfigurationWizardPage.this.updatePage();
            }
        });
        this.localAddrCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractRemoteProxyResourceManagerConfigurationWizardPage.this.updateSettings();
                AbstractRemoteProxyResourceManagerConfigurationWizardPage.this.updatePage();
            }
        });
    }

    private void setValid(boolean complete) {
        this.isValid = complete;
        this.setPageComplete(this.isValid);
    }

    private void store() {
        if (this.proxyPathEnabled && this.proxyPathText != null) {
            this.proxyPath = this.proxyPathText.getText();
        }
    }

    protected void addCustomWidgets(Composite remoteComp) {
    }

    protected Button createButton(Composite parent, String label, int type) {
        Button button = new Button(parent, type);
        button.setText(label);
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        return button;
    }

    protected Button createCheckButton(Composite parent, String label) {
        return this.createButton(parent, label, 16416);
    }

    protected GridLayout createGridLayout(int columns, boolean isEqual, int mh, int mw) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = columns;
        gridLayout.makeColumnsEqualWidth = isEqual;
        gridLayout.marginHeight = mh;
        gridLayout.marginWidth = mw;
        return gridLayout;
    }

    protected AbstractProxyOptions createProxyOptions(WizardPage wizardPage, IRemoteResourceManagerConfiguration config) {
        return new DefaultProxyOptions(wizardPage, config);
    }

    protected Button createRadioButton(Composite parent, String label, String value, SelectionListener listener) {
        Button button = this.createButton(parent, label, 16400);
        button.setData((Object)(value == null ? label : value));
        GridData data = new GridData(768);
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        button.setLayoutData((Object)data);
        if (listener != null) {
            button.addSelectionListener(listener);
        }
        return button;
    }

    protected void defaultSetting() {
        if (this.proxyPathEnabled) {
            this.proxyPathText.setText(this.proxyPath);
        }
    }

    protected IRemoteResourceManagerConfiguration getConfiguration() {
        return (IRemoteResourceManagerConfiguration)super.getConfiguration();
    }

    protected String getFieldContent(String text) {
        if (text.trim().length() == 0 || text.equals(EMPTY_STRING)) {
            return null;
        }
        return text;
    }

    protected ScrolledPageContent getParentScrolledComposite(Control control) {
        Composite parent = control.getParent();
        while (!(parent instanceof ScrolledPageContent) && parent != null) {
            parent = parent.getParent();
        }
        if (parent instanceof ScrolledPageContent) {
            return (ScrolledPageContent)parent;
        }
        return null;
    }

    protected void handleConnectionSelected() {
        int currentSelection = this.connectionCombo.getSelectionIndex();
        if (currentSelection >= 0 && this.connectionManager != null) {
            String connectionName = this.connectionCombo.getItem(currentSelection);
            this.connection = this.connectionManager.getConnection(connectionName);
            this.fProxyOptions.setRemoteConnection(this.connection);
        }
        if (this.connection != null) {
            this.portFwdSupported = this.connection.supportsTCPPortForwarding();
            this.portForwardingButton.setEnabled(this.portFwdSupported);
            this.portForwardingButton.setSelection(this.portFwdSupported);
        }
        this.updateSettings();
        this.updatePage();
    }

    protected void handleNewRemoteConnectionSelected() {
        if (this.uiConnectionManager != null) {
            this.handleRemoteServiceSelected(this.uiConnectionManager.newConnection(this.getShell()));
        }
    }

    protected void handlePathBrowseButtonSelected() {
        if (!this.proxyPathEnabled) {
            return;
        }
        if (this.connection != null) {
            IRemoteUIFileManager fileMgr;
            IRemoteUIServices remoteUIServices;
            this.checkConnection();
            if (this.connection.isOpen() && (remoteUIServices = PTPRemoteUIPlugin.getDefault().getRemoteUIServices(this.remoteServices)) != null && (fileMgr = remoteUIServices.getUIFileManager()) != null) {
                fileMgr.setConnection(this.connection);
                String correctPath = this.proxyPathText.getText();
                String selectedPath = fileMgr.browseFile(this.getShell(), Messages.AbstractRemoteProxyResourceManagerConfigurationWizardPage_16, correctPath, 0);
                if (selectedPath != null) {
                    this.proxyPathText.setText(selectedPath.toString());
                }
            }
        }
    }

    protected void handleRemoteServiceSelected(IRemoteConnection conn) {
        int selectionIndex = this.remoteCombo.getSelectionIndex();
        if (this.fAllRemoteServices != null && this.fAllRemoteServices.length > 0 && selectionIndex >= 0) {
            this.remoteServices = this.fAllRemoteServices[selectionIndex];
            this.connectionManager = this.remoteServices.getConnectionManager();
            IRemoteUIServices remUIServices = PTPRemoteUIPlugin.getDefault().getRemoteUIServices(this.remoteServices);
            if (remUIServices != null) {
                this.uiConnectionManager = remUIServices.getUIConnectionManager();
            }
            IRemoteConnection[] connections = this.connectionManager.getConnections();
            Arrays.sort(connections, new Comparator<IRemoteConnection>(){

                @Override
                public int compare(IRemoteConnection c1, IRemoteConnection c2) {
                    return c1.getName().compareToIgnoreCase(c2.getName());
                }
            });
            this.connectionCombo.removeAll();
            int selected = 0;
            int i = 0;
            while (i < connections.length) {
                this.connectionCombo.add(connections[i].getName());
                if (conn != null && connections[i].equals(conn)) {
                    selected = i;
                }
                ++i;
            }
            if (connections.length > 0) {
                this.connectionCombo.select(selected);
                this.handleConnectionSelected();
            }
            this.newConnectionButton.setEnabled(this.uiConnectionManager != null);
        }
    }

    protected void initContents() {
        this.loading = true;
        this.loadSaved();
        this.updateSettings();
        this.defaultSetting();
        this.initializeRemoteServicesCombo();
        this.initializeLocalHostCombo();
        this.updatePage();
        this.loading = false;
    }

    protected void initializeRemoteServicesCombo() {
        IWizardContainer container = null;
        if (this.getControl().isVisible()) {
            container = this.getWizard().getContainer();
        }
        this.fAllRemoteServices = PTPRemoteUIPlugin.getDefault().getRemoteServices((IRunnableContext)container);
        IRemoteServices defServices = this.remoteServices != null ? this.remoteServices : PTPRemoteCorePlugin.getDefault().getDefaultServices();
        int defIndex = 0;
        Arrays.sort(this.fAllRemoteServices, new Comparator<IRemoteServices>(){

            @Override
            public int compare(IRemoteServices c1, IRemoteServices c2) {
                return c1.getName().compareToIgnoreCase(c2.getName());
            }
        });
        this.remoteCombo.removeAll();
        int i = 0;
        while (i < this.fAllRemoteServices.length) {
            this.remoteCombo.add(this.fAllRemoteServices[i].getName());
            if (this.fAllRemoteServices[i].equals(defServices)) {
                defIndex = i;
            }
            ++i;
        }
        if (this.fAllRemoteServices.length > 0) {
            this.remoteCombo.select(defIndex);
            this.handleRemoteServiceSelected(this.connection);
            this.handleConnectionSelected();
        }
    }

    protected boolean isValidSetting() {
        String name;
        return !this.proxyPathEnabled || this.proxyPathText == null || (name = this.getFieldContent(this.proxyPathText.getText())) != null && this.proxyPathIsValid;
    }

    protected GridData spanGridData(int style, int space) {
        GridData gd = null;
        gd = style == -1 ? new GridData() : new GridData(style);
        gd.horizontalSpan = space;
        return gd;
    }

    protected void updatePage() {
        if (!this.loading) {
            if (!this.isValidSetting()) {
                this.setValid(false);
            } else {
                this.performOk();
                this.setValid(true);
                this.setErrorMessage(null);
            }
        }
    }

    protected void updateSettings() {
        if (!this.loading) {
            this.muxPortFwd = this.portForwardingButton.getSelection();
            if (this.manualButton != null) {
                this.manualLaunch = this.manualButton.getSelection();
            }
        }
        if (!this.loading || this.localAddr.equals(EMPTY_STRING)) {
            this.localAddr = this.localAddrCombo.getText();
        }
        if (this.muxPortFwd && !this.portFwdSupported) {
            this.muxPortFwd = false;
        }
        if (this.noneButton != null) {
            this.noneButton.setSelection(!this.muxPortFwd);
        }
        if (this.portForwardingButton != null) {
            this.portForwardingButton.setSelection(this.muxPortFwd);
            this.portForwardingButton.setEnabled(this.portFwdSupported);
        }
        if (this.localAddrCombo != null) {
            this.localAddrCombo.setEnabled(!this.muxPortFwd);
        }
        if (this.manualButton != null) {
            this.manualButton.setSelection(this.manualLaunch);
        }
    }

    protected boolean validateProxyPath() {
        if (!this.proxyPathEnabled) {
            return true;
        }
        this.proxyPathIsValid = false;
        final String path = this.proxyPathText.getText();
        if (path != null && !path.equals(EMPTY_STRING) && this.connection != null) {
            IRemoteFileManager fileMgr;
            this.checkConnection();
            if (this.connection.isOpen() && this.remoteServices != null && (fileMgr = this.remoteServices.getFileManager(this.connection)) != null) {
                IRunnableWithProgress op = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            IFileStore file = fileMgr.getResource(path);
                            if (!monitor.isCanceled()) {
                                AbstractRemoteProxyResourceManagerConfigurationWizardPage.this.proxyPathIsValid = file.fetchInfo(0, monitor).exists();
                            }
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                };
                try {
                    ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
                    dialog.setOpenOnRun(false);
                    dialog.run(true, true, op);
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return this.proxyPathIsValid;
    }

    protected class ValidateJob
    extends UIJob {
        public ValidateJob() {
            super("ValidateJob");
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            AbstractRemoteProxyResourceManagerConfigurationWizardPage.this.validateProxyPath();
            if (!AbstractRemoteProxyResourceManagerConfigurationWizardPage.this.proxyPathIsValid) {
                AbstractRemoteProxyResourceManagerConfigurationWizardPage.this.setErrorMessage(Messages.AbstractRemoteProxyResourceManagerConfigurationWizardPage_17);
            }
            AbstractRemoteProxyResourceManagerConfigurationWizardPage.this.updatePage();
            return Status.OK_STATUS;
        }
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener,
    IPropertyChangeListener {
        protected WidgetListener() {
        }

        public void modifyText(ModifyEvent evt) {
            Object source = evt.getSource();
            if (!AbstractRemoteProxyResourceManagerConfigurationWizardPage.this.loading && source == AbstractRemoteProxyResourceManagerConfigurationWizardPage.this.proxyPathText) {
                AbstractRemoteProxyResourceManagerConfigurationWizardPage.this.validateJob.cancel();
                AbstractRemoteProxyResourceManagerConfigurationWizardPage.this.validateJob.schedule(250L);
            }
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("field_editor_is_valid")) {
                AbstractRemoteProxyResourceManagerConfigurationWizardPage.this.updatePage();
            }
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == AbstractRemoteProxyResourceManagerConfigurationWizardPage.this.browseButton) {
                AbstractRemoteProxyResourceManagerConfigurationWizardPage.this.handlePathBrowseButtonSelected();
            } else {
                AbstractRemoteProxyResourceManagerConfigurationWizardPage.this.updateSettings();
                AbstractRemoteProxyResourceManagerConfigurationWizardPage.this.updatePage();
            }
        }
    }
}

