/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.ui.properties;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IMultiConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.MultiConfiguration;
import org.eclipse.cdt.managedbuilder.ui.properties.AbstractSingleBuildPage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.rdt.sync.core.BuildConfigurationManager;
import org.eclipse.ptp.rdt.sync.core.BuildScenario;
import org.eclipse.ptp.rdt.sync.ui.messages.Messages;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.ui.IRemoteUIConnectionManager;
import org.eclipse.ptp.remote.ui.IRemoteUIFileManager;
import org.eclipse.ptp.remote.ui.IRemoteUIServices;
import org.eclipse.ptp.remote.ui.PTPRemoteUIPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.statushandlers.StatusManager;

public class BuildRemotePropertiesPage
extends AbstractSingleBuildPage {
    private IRemoteConnection fSelectedConnection = null;
    private IRemoteServices fSelectedProvider = null;
    private IConfiguration fConfigBeforeSwitch = null;
    private boolean fWidgetsReady = false;
    private final Map<Integer, IRemoteServices> fComboIndexToRemoteServicesProviderMap = new HashMap<Integer, IRemoteServices>();
    private final Map<IRemoteServices, Integer> fComboRemoteServicesProviderToIndexMap = new HashMap<IRemoteServices, Integer>();
    private final Map<Integer, IRemoteConnection> fComboIndexToRemoteConnectionMap = new HashMap<Integer, IRemoteConnection>();
    private final Map<IRemoteConnection, Integer> fComboRemoteConnectionToIndexMap = new HashMap<IRemoteConnection, Integer>();
    private final Map<String, PageSettings> fConfigToPageSettings = new HashMap<String, PageSettings>();
    private Button fBrowseButton;
    private Button fNewConnectionButton;
    private Combo fProviderCombo;
    private Combo fConnectionCombo;
    private Text fRootLocationText;
    private Composite composite;

    public void createWidgets(Composite parent) {
        this.composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.composite.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        this.composite.setLayoutData((Object)gd);
        Label providerLabel = new Label(this.composite, 16384);
        providerLabel.setText(Messages.BRPPage_RemoteProviderLabel);
        this.fProviderCombo = new Combo(this.composite, 12);
        gd = new GridData(1, 1, false, false);
        gd.horizontalSpan = 2;
        this.fProviderCombo.setLayoutData((Object)gd);
        this.fProviderCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildRemotePropertiesPage.this.handleServicesSelected();
            }
        });
        Label connectionLabel = new Label(this.composite, 16384);
        connectionLabel.setText(Messages.BRPPage_ConnectionLabel);
        this.fConnectionCombo = new Combo(this.composite, 12);
        this.fConnectionCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fConnectionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildRemotePropertiesPage.this.handleConnectionSelected();
            }
        });
        this.fNewConnectionButton = new Button(this.composite, 8);
        this.fNewConnectionButton.setText(Messages.BRPPage_ConnectionButton);
        this.fNewConnectionButton.setEnabled(false);
        this.fNewConnectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IRemoteUIConnectionManager connectionManager = BuildRemotePropertiesPage.this.getUIConnectionManager();
                if (connectionManager != null) {
                    connectionManager.newConnection(BuildRemotePropertiesPage.this.fNewConnectionButton.getShell());
                }
                BuildRemotePropertiesPage.this.populateConnectionCombo(BuildRemotePropertiesPage.this.fConnectionCombo);
                BuildRemotePropertiesPage.this.update();
            }
        });
        Label rootLocationLabel = new Label(this.composite, 16384);
        rootLocationLabel.setText(Messages.BRPPage_RootLocation);
        this.fRootLocationText = new Text(this.composite, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 250;
        this.fRootLocationText.setLayoutData((Object)gd);
        this.fRootLocationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BuildRemotePropertiesPage.this.update();
            }
        });
        this.fBrowseButton = new Button(this.composite, 8);
        this.fBrowseButton.setText(Messages.BRPPage_BrowseButton);
        this.fBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (BuildRemotePropertiesPage.this.fSelectedConnection != null) {
                    IRemoteUIFileManager fileMgr;
                    IRemoteUIServices remoteUIServices;
                    BuildRemotePropertiesPage.this.checkConnection();
                    if (BuildRemotePropertiesPage.this.fSelectedConnection.isOpen() && (remoteUIServices = PTPRemoteUIPlugin.getDefault().getRemoteUIServices(BuildRemotePropertiesPage.this.fSelectedProvider)) != null && (fileMgr = remoteUIServices.getUIFileManager()) != null) {
                        fileMgr.setConnection(BuildRemotePropertiesPage.this.fSelectedConnection);
                        String correctPath = BuildRemotePropertiesPage.this.fRootLocationText.getText();
                        String selectedPath = fileMgr.browseDirectory(BuildRemotePropertiesPage.this.fRootLocationText.getShell(), "Project Location (" + BuildRemotePropertiesPage.this.fSelectedConnection.getName() + ")", correctPath, 0);
                        if (selectedPath != null) {
                            BuildRemotePropertiesPage.this.fRootLocationText.setText(selectedPath);
                        }
                    }
                }
            }
        });
        this.fConfigBeforeSwitch = this.getCfg();
        this.setValues(this.getCfg());
        this.fWidgetsReady = true;
    }

    private void handleConnectionSelected() {
        int selectionIndex = this.fConnectionCombo.getSelectionIndex();
        this.fSelectedConnection = this.fComboIndexToRemoteConnectionMap.get(selectionIndex);
        this.updateNewConnectionButtonEnabled(this.fNewConnectionButton);
        this.update();
    }

    private void handleServicesSelected() {
        int selectionIndex = this.fProviderCombo.getSelectionIndex();
        this.fSelectedProvider = this.fComboIndexToRemoteServicesProviderMap.get(selectionIndex);
        this.populateConnectionCombo(this.fConnectionCombo);
        this.updateNewConnectionButtonEnabled(this.fNewConnectionButton);
        this.update();
    }

    private void populateConnectionCombo(Combo connectionCombo) {
        this.fSelectedConnection = null;
        connectionCombo.removeAll();
        IRemoteConnection[] connections = this.fSelectedProvider.getConnectionManager().getConnections();
        int k = 0;
        while (k < connections.length) {
            connectionCombo.add(connections[k].getName(), k);
            this.fComboIndexToRemoteConnectionMap.put(k, connections[k]);
            this.fComboRemoteConnectionToIndexMap.put(connections[k], k);
            ++k;
        }
    }

    private void populateRemoteProviderCombo(Combo providerCombo) {
        providerCombo.removeAll();
        IRemoteServices[] providers = PTPRemoteUIPlugin.getDefault().getRemoteServices(null);
        int k = 0;
        while (k < providers.length) {
            providerCombo.add(providers[k].getName(), k);
            this.fComboIndexToRemoteServicesProviderMap.put(k, providers[k]);
            this.fComboRemoteServicesProviderToIndexMap.put(providers[k], k);
            ++k;
        }
    }

    private void updateNewConnectionButtonEnabled(Button button) {
        IRemoteUIConnectionManager connectionManager = this.getUIConnectionManager();
        button.setEnabled(connectionManager != null);
    }

    public boolean performOk() {
        super.performOk();
        if (!this.fWidgetsReady) {
            return true;
        }
        this.storeSettings(this.getCfg());
        ICConfigurationDescription[] iCConfigurationDescriptionArray = this.getCfgsReadOnly(this.getProject());
        int n = iCConfigurationDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            PageSettings settings;
            ICConfigurationDescription desc = iCConfigurationDescriptionArray[n2];
            IConfiguration config = this.getCfg(desc);
            if (config != null && !(config instanceof MultiConfiguration) && (settings = this.fConfigToPageSettings.get(config.getId())) != null && this.isConfigAltered(config, settings)) {
                this.saveConfig(config, settings);
            }
            ++n2;
        }
        return true;
    }

    private boolean isConfigAltered(IConfiguration config, PageSettings settings) {
        PageSettings systemSettings = this.loadSettings(config);
        if (systemSettings == null) {
            return true;
        }
        return !settings.equals(systemSettings);
    }

    private void saveConfig(IConfiguration config, PageSettings settings) {
        ManagedBuildManager.saveBuildInfo((IProject)config.getOwner().getProject(), (boolean)true);
        BuildConfigurationManager bcm = BuildConfigurationManager.getInstance();
        String syncProvider = bcm.getBuildScenarioForBuildConfiguration(config).getSyncProvider();
        BuildScenario buildScenario = new BuildScenario(syncProvider, settings.connection, settings.rootLocation);
        bcm.setBuildScenarioForBuildConfiguration(buildScenario, config);
        try {
            bcm.saveConfigurationData();
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.ptp.rdt.sync.ui", "Error saving configuration data: " + e.getMessage(), (Throwable)e);
            StatusManager.getManager().handle((IStatus)status, 2);
        }
    }

    private void checkConnection() {
        IRemoteUIConnectionManager mgr = this.getUIConnectionManager();
        if (mgr != null) {
            mgr.openConnectionWithProgress(this.fConnectionCombo.getShell(), null, this.fSelectedConnection);
        }
    }

    private IRemoteUIConnectionManager getUIConnectionManager() {
        IRemoteUIConnectionManager connectionManager = PTPRemoteUIPlugin.getDefault().getRemoteUIServices(this.fSelectedProvider).getUIConnectionManager();
        return connectionManager;
    }

    private void setValues(IConfiguration config) {
        Integer index;
        if (config instanceof IMultiConfiguration) {
            this.composite.setEnabled(false);
            return;
        }
        this.composite.setEnabled(true);
        this.populateRemoteProviderCombo(this.fProviderCombo);
        PageSettings settings = this.fConfigToPageSettings.get(this.getCfg().getId());
        if (settings == null) {
            settings = this.loadSettings(this.getCfg());
            if (settings == null) {
                return;
            }
            this.fConfigToPageSettings.put(this.getCfg().getId(), settings);
        }
        this.fProviderCombo.select(this.fComboRemoteServicesProviderToIndexMap.get(settings.remoteProvider).intValue());
        this.handleServicesSelected();
        if (settings.connection != null && (index = this.fComboRemoteConnectionToIndexMap.get(settings.connection)) != null) {
            this.fConnectionCombo.select(index.intValue());
        }
        this.handleConnectionSelected();
        this.fRootLocationText.setText(settings.rootLocation);
    }

    protected void cfgChanged(ICConfigurationDescription cfg) {
        super.cfgChanged(cfg);
        if (!this.fWidgetsReady) {
            return;
        }
        this.storeSettings(this.fConfigBeforeSwitch);
        this.fConfigBeforeSwitch = this.getCfg();
        this.setValues(this.getCfg());
    }

    protected void performApply(ICResourceDescription src, ICResourceDescription dst) {
        this.performOk();
    }

    private PageSettings loadSettings(IConfiguration config) {
        BuildScenario buildScenario = BuildConfigurationManager.getInstance().getBuildScenarioForBuildConfiguration(config);
        if (buildScenario == null) {
            Status status = new Status(4, "org.eclipse.ptp.rdt.sync.ui", "Error loading configuration data");
            StatusManager.getManager().handle((IStatus)status, 2);
            return null;
        }
        PageSettings settings = new PageSettings();
        settings.remoteProvider = buildScenario.getRemoteConnection().getRemoteServices();
        settings.connection = buildScenario.getRemoteConnection();
        settings.rootLocation = buildScenario.getLocation();
        return settings;
    }

    private void storeSettings(IConfiguration config) {
        if (config == null || config instanceof MultiConfiguration) {
            return;
        }
        PageSettings settings = new PageSettings();
        Integer remoteServicesIndex = this.fProviderCombo.getSelectionIndex();
        Integer connectionIndex = this.fConnectionCombo.getSelectionIndex();
        settings.remoteProvider = this.fComboIndexToRemoteServicesProviderMap.get(remoteServicesIndex);
        settings.connection = this.fComboIndexToRemoteConnectionMap.get(connectionIndex);
        settings.rootLocation = this.fRootLocationText.getText();
        this.fConfigToPageSettings.put(config.getId(), settings);
    }

    public void performDefaults() {
        if (!this.fWidgetsReady) {
            return;
        }
        PageSettings settings = this.loadSettings(this.getCfg());
        this.fConfigToPageSettings.put(this.getCfg().getId(), settings);
        this.setValues(this.getCfg());
    }

    private void update() {
        this.getContainer().updateMessage();
        this.getContainer().updateButtons();
        this.updateApplyButton();
        this.enableConfigSelection(this.isValid());
    }

    public String getErrorMessage() {
        if (super.getErrorMessage() != null) {
            return super.getErrorMessage();
        }
        if (this.fSelectedProvider == null) {
            return Messages.GitParticipant_0;
        }
        if (this.fSelectedConnection == null) {
            return Messages.GitParticipant_1;
        }
        if (this.fRootLocationText.getText().length() == 0) {
            return Messages.GitParticipant_2;
        }
        IRemoteFileManager fileManager = this.fSelectedProvider.getFileManager(this.fSelectedConnection);
        if (fileManager.toURI(this.fRootLocationText.getText()) == null) {
            return Messages.GitParticipant_3;
        }
        return null;
    }

    public boolean isValid() {
        return super.isValid() && this.getErrorMessage() == null;
    }

    private static class PageSettings {
        IRemoteConnection connection;
        IRemoteServices remoteProvider;
        String rootLocation;

        private PageSettings() {
        }

        public boolean equals(PageSettings otherSettings) {
            if (this.connection != otherSettings.connection) {
                return false;
            }
            if (this.remoteProvider != otherSettings.remoteProvider) {
                return false;
            }
            return this.rootLocation.equals(otherSettings.rootLocation);
        }
    }
}

