/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.ptp.core.util.CoreExceptionUtils;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionChangeEvent;
import org.eclipse.ptp.remote.core.IRemoteConnectionChangeListener;
import org.eclipse.ptp.remote.core.RemoteServicesDelegate;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;
import org.eclipse.ptp.rm.jaxb.control.JAXBControlCorePlugin;
import org.eclipse.ptp.rm.jaxb.control.internal.ICommandJob;
import org.eclipse.ptp.rm.jaxb.control.internal.ICommandJobStatus;
import org.eclipse.ptp.rm.jaxb.control.internal.ICommandJobStatusMap;
import org.eclipse.ptp.rm.jaxb.control.internal.messages.Messages;
import org.eclipse.ptp.rm.jaxb.control.internal.runnable.JobStatusMap;
import org.eclipse.ptp.rm.jaxb.control.internal.runnable.ManagedFilesJob;
import org.eclipse.ptp.rm.jaxb.control.internal.runnable.command.CommandJob;
import org.eclipse.ptp.rm.jaxb.control.internal.runnable.command.CommandJobStatus;
import org.eclipse.ptp.rm.jaxb.control.internal.utils.JobIdPinTable;
import org.eclipse.ptp.rm.jaxb.control.internal.variables.RMVariableMap;
import org.eclipse.ptp.rm.jaxb.control.runnable.ScriptHandler;
import org.eclipse.ptp.rm.jaxb.core.IJAXBResourceManager;
import org.eclipse.ptp.rm.jaxb.core.IJAXBResourceManagerConfiguration;
import org.eclipse.ptp.rm.jaxb.core.IJAXBResourceManagerControl;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.ptp.rm.jaxb.core.data.AttributeType;
import org.eclipse.ptp.rm.jaxb.core.data.CommandType;
import org.eclipse.ptp.rm.jaxb.core.data.ControlType;
import org.eclipse.ptp.rm.jaxb.core.data.ManagedFileType;
import org.eclipse.ptp.rm.jaxb.core.data.ManagedFilesType;
import org.eclipse.ptp.rm.jaxb.core.data.PropertyType;
import org.eclipse.ptp.rm.jaxb.core.data.ResourceManagerData;
import org.eclipse.ptp.rm.jaxb.core.data.ScriptType;
import org.eclipse.ptp.rmsystem.AbstractResourceManager;
import org.eclipse.ptp.rmsystem.AbstractResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.AbstractResourceManagerControl;
import org.eclipse.ptp.rmsystem.IJobStatus;
import org.eclipse.ptp.rmsystem.IResourceManager;
import org.eclipse.ptp.rmsystem.IResourceManagerControl;
import org.eclipse.ui.progress.IProgressConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JAXBResourceManagerControl
extends AbstractResourceManagerControl
implements IJAXBResourceManagerControl {
    private final IJAXBResourceManagerConfiguration config;
    private final ConnectionChangeListener connectionListener;
    private Map<String, String> launchEnv;
    private ICommandJob interactiveJob;
    private ICommandJobStatusMap jobStatusMap;
    private JobIdPinTable pinTable;
    private RMVariableMap rmVarMap;
    private ControlType controlData;
    private String servicesId;
    private String connectionName;
    private RemoteServicesDelegate remoteServicesDelegate;
    private boolean appendLaunchEnv;

    public static void checkConnection(IRemoteConnection connection, SubMonitor progress) throws RemoteConnectionException {
        if (connection != null) {
            if (!connection.isOpen()) {
                connection.open((IProgressMonitor)progress.newChild(25));
                if (!connection.isOpen()) {
                    throw new RemoteConnectionException(String.valueOf(Messages.RemoteConnectionError) + connection.getAddress());
                }
            }
        } else {
            new RemoteConnectionException(String.valueOf(Messages.RemoteConnectionError) + connection);
        }
    }

    public JAXBResourceManagerControl(AbstractResourceManagerConfiguration jaxbServiceProvider) {
        super(jaxbServiceProvider);
        this.config = (IJAXBResourceManagerConfiguration)jaxbServiceProvider;
        this.connectionListener = new ConnectionChangeListener();
    }

    public boolean getAppendEnv() {
        return this.appendLaunchEnv;
    }

    public IVariableMap getEnvironment() {
        return this.rmVarMap;
    }

    public synchronized ICommandJob getInteractiveJob() {
        return this.interactiveJob;
    }

    public Map<String, String> getLaunchEnv() {
        return this.launchEnv;
    }

    public RemoteServicesDelegate getRemoteServicesDelegate(IProgressMonitor monitor) throws CoreException {
        String cname = this.config.getConnectionName();
        String sid = this.config.getRemoteServicesId();
        if (this.remoteServicesDelegate == null || !cname.equals(this.connectionName) || !sid.equals(this.servicesId)) {
            this.connectionName = cname;
            this.servicesId = sid;
            this.remoteServicesDelegate = new RemoteServicesDelegate(this.servicesId, this.connectionName);
            this.remoteServicesDelegate.initialize(monitor);
        }
        return this.remoteServicesDelegate;
    }

    public String getState() {
        return this.getResourceManager().getState();
    }

    public ICommandJobStatusMap getStatusMap() {
        return this.jobStatusMap;
    }

    public void jobStateChanged(String jobId, IJobStatus status) {
        ((IJAXBResourceManager)this.getResourceManager()).fireJobChanged(jobId);
        this.getResourceManager().updateJob(jobId, status);
    }

    public synchronized void setInteractiveJob(ICommandJob interactiveJob) {
        this.interactiveJob = interactiveJob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doControlJob(String jobId, String operation, IProgressMonitor monitor) throws CoreException {
        if (!this.resourceManagerIsActive()) {
            return;
        }
        if (jobId == null) {
            JAXBResourceManagerControl jAXBResourceManagerControl = this;
            synchronized (jAXBResourceManagerControl) {
                if (this.interactiveJob != null) {
                    this.interactiveJob.terminate();
                    this.interactiveJob = null;
                }
            }
            return;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            this.pinTable.pin(jobId);
            PropertyType p = new PropertyType();
            p.setVisible(Boolean.valueOf(false));
            p.setName(jobId);
            this.rmVarMap.put(jobId, p);
            this.worked((IProgressMonitor)progress, 30);
            this.doControlCommand(jobId, operation);
            this.rmVarMap.remove(jobId);
            this.worked((IProgressMonitor)progress, 40);
            if ("TERMINATE".equals(operation)) {
                ICommandJobStatus canceledStatus = this.jobStatusMap.cancel(jobId);
                JAXBResourceManagerControl jAXBResourceManagerControl = this;
                synchronized (jAXBResourceManagerControl) {
                    if (this.interactiveJob != null && canceledStatus == this.interactiveJob.getJobStatus()) {
                        this.interactiveJob = null;
                    }
                }
            }
            this.worked((IProgressMonitor)progress, 30);
        }
        finally {
            this.pinTable.release(jobId);
        }
    }

    protected void doDispose() {
    }

    protected IJobStatus doGetJobStatus(String jobId, boolean force, IProgressMonitor monitor) throws CoreException {
        try {
            ICommandJobStatus status = this.jobStatusMap.getStatus(jobId);
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            if (status != null) {
                if ("COMPLETED".equals(status.getState())) {
                    status = this.jobStatusMap.terminated(jobId, (IProgressMonitor)progress.newChild(50));
                    if (status.stateChanged()) {
                        this.jobStateChanged(jobId, status);
                    }
                    return status;
                }
                if (!force) {
                    long now = System.currentTimeMillis();
                    long lapse = now - status.getLastUpdateRequest();
                    if (lapse < 30000L) {
                        return status;
                    }
                    status.setUpdateRequestTime(now);
                }
            }
            String state = status == null ? "UNDETERMINED" : status.getStateDetail();
            try {
                PropertyType p = (PropertyType)this.rmVarMap.get(jobId);
                CommandType job = this.controlData.getGetJobStatus();
                if (job != null && this.resourceManagerIsActive() && !progress.isCanceled()) {
                    this.pinTable.pin(jobId);
                    p = new PropertyType();
                    p.setVisible(Boolean.valueOf(false));
                    p.setName(jobId);
                    this.rmVarMap.put(jobId, p);
                    this.runCommand(jobId, job, CommandJob.JobMode.STATUS, true);
                    p = (PropertyType)this.rmVarMap.remove(jobId);
                }
                if (p != null) {
                    state = String.valueOf(p.getValue());
                }
            }
            finally {
                this.pinTable.release(jobId);
            }
            if (status == null) {
                status = new CommandJobStatus(this.getResourceManager().getUniqueName(), jobId, state, null, this);
                status.setOwner(this.rmVarMap.getString("${ptp_rm:control.user.name#value}"));
                this.jobStatusMap.addJobStatus(jobId, status);
            } else {
                status.setState(state);
            }
            if (progress.isCanceled()) {
                status.setState("UNDETERMINED");
                this.jobStateChanged(jobId, status);
                return status;
            }
            if ("COMPLETED".equals(state)) {
                status = this.jobStatusMap.terminated(jobId, (IProgressMonitor)progress.newChild(50));
            }
            if (status.stateChanged()) {
                this.jobStateChanged(jobId, status);
            }
            return status;
        }
        catch (CoreException ce) {
            this.getResourceManager().setState("ERROR");
            throw ce;
        }
    }

    protected void doShutdown() throws CoreException {
        this.doOnShutdown();
        ((IJAXBResourceManagerConfiguration)this.getResourceManager().getConfiguration()).clearReferences(true);
        this.jobStatusMap.halt();
        RemoteServicesDelegate d = this.getRemoteServicesDelegate(null);
        IRemoteConnection conn = d.getRemoteConnection();
        if (conn != null) {
            conn.removeConnectionChangeListener((IRemoteConnectionChangeListener)this.connectionListener);
        }
    }

    protected void doStartup(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)60);
        try {
            this.doConnect((IProgressMonitor)progress.newChild(20));
        }
        catch (Throwable t) {
            progress.done();
            throw CoreExceptionUtils.newException((String)t.getMessage(), (Throwable)t);
        }
        try {
            this.initialize((IProgressMonitor)progress.newChild(30));
            this.doOnStartUp();
        }
        catch (Throwable t) {
            throw CoreExceptionUtils.newException((String)t.getMessage(), (Throwable)t);
        }
    }

    protected IJobStatus doSubmitJob(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        String uuid = UUID.randomUUID().toString();
        if (!this.resourceManagerIsActive()) {
            CommandJobStatus status = new CommandJobStatus(this.getResourceManager().getUniqueName(), uuid, "UNDETERMINED", null, this);
            status.setOwner(this.rmVarMap.getString("${ptp_rm:control.user.name#value}"));
            return status;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        String jobId = null;
        PropertyType p = new PropertyType();
        p.setVisible(Boolean.valueOf(false));
        this.rmVarMap.put(uuid, p);
        this.updatePropertyValuesFromTab(configuration, (IProgressMonitor)progress.newChild(5));
        boolean delScript = this.maybeHandleScript(uuid, this.controlData.getScript());
        this.worked((IProgressMonitor)progress, 20);
        ManagedFilesType files = this.controlData.getManagedFiles();
        files = this.maybeAddManagedFileForScript(files, delScript);
        this.worked((IProgressMonitor)progress, 5);
        if (!this.maybeTransferManagedFiles(uuid, files)) {
            throw CoreExceptionUtils.newException((String)Messages.CannotCompleteSubmitFailedStaging, null);
        }
        this.worked((IProgressMonitor)progress, 20);
        ICommandJob job = null;
        try {
            job = this.doJobSubmitCommand(uuid, mode);
            this.worked((IProgressMonitor)progress, 40);
        }
        finally {
            this.maybeCleanupManagedFiles(uuid, files);
            this.worked((IProgressMonitor)progress, 5);
        }
        ICommandJobStatus status = job.getJobStatus();
        if (this.interactiveJob != null && this.interactiveJob.getJobStatus() == status && this.interactiveJob != job) {
            return status;
        }
        this.rmVarMap.remove(uuid);
        jobId = p.getName();
        if (jobId == null) {
            status = new CommandJobStatus(this.getResourceManager().getUniqueName(), uuid, "CANCELED", null, this);
            status.setOwner(this.rmVarMap.getString("${ptp_rm:control.user.name#value}"));
            return status;
        }
        this.jobStatusMap.addJobStatus(status.getJobId(), status);
        status.setLaunchConfig(configuration);
        this.worked((IProgressMonitor)progress, 5);
        this.rmVarMap.remove("script_path");
        this.rmVarMap.remove("script");
        return status;
    }

    private void checkJobForError(ICommandJob job) throws CoreException {
        IStatus status = job.getRunStatus();
        if (status != null && status.getSeverity() == 4) {
            Throwable t = status.getException();
            if (t instanceof CoreException) {
                throw (CoreException)t;
            }
            throw CoreExceptionUtils.newException((String)status.getMessage(), (Throwable)t);
        }
    }

    private void doConnect(IProgressMonitor monitor) throws RemoteConnectionException, CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        RemoteServicesDelegate d = this.getRemoteServicesDelegate((IProgressMonitor)progress.newChild(50));
        IRemoteConnection conn = d.getRemoteConnection();
        if (conn != null) {
            JAXBResourceManagerControl.checkConnection(conn, progress);
            conn.addConnectionChangeListener((IRemoteConnectionChangeListener)this.connectionListener);
        }
    }

    private void doControlCommand(String jobId, String operation) throws CoreException {
        CoreException ce = CoreExceptionUtils.newException((String)(String.valueOf(Messages.RMNoSuchCommandError) + operation), null);
        CommandType job = null;
        if ("TERMINATE".equals(operation)) {
            this.maybeKillInteractive(jobId);
            job = this.controlData.getTerminateJob();
            if (job == null) {
                return;
            }
        } else if ("SUSPEND".equals(operation) ? (job = this.controlData.getSuspendJob()) == null : ("RESUME".equals(operation) ? (job = this.controlData.getResumeJob()) == null : ("RELEASE".equals(operation) ? (job = this.controlData.getReleaseJob()) == null : "HOLD".equals(operation) && (job = this.controlData.getHoldJob()) == null))) {
            throw ce;
        }
        this.runCommand(jobId, job, CommandJob.JobMode.INTERACTIVE, true);
    }

    private ICommandJob doJobSubmitCommand(String uuid, String mode) throws CoreException {
        CommandType command = null;
        CommandJob.JobMode jobMode = CommandJob.JobMode.INTERACTIVE;
        if ("run".equals(mode)) {
            command = this.controlData.getSubmitBatch();
            if (command != null) {
                jobMode = CommandJob.JobMode.BATCH;
            } else {
                command = this.controlData.getSubmitInteractive();
            }
        } else if ("debug".equals(mode)) {
            command = this.controlData.getSubmitBatchDebug();
            if (command != null) {
                jobMode = CommandJob.JobMode.BATCH;
            } else {
                command = this.controlData.getSubmitInteractiveDebug();
            }
        }
        if (command == null) {
            throw CoreExceptionUtils.newException((String)(String.valueOf(Messages.MissingRunCommandsError) + " " + uuid + " " + mode), null);
        }
        return this.runCommand(uuid, command, jobMode, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOnShutdown() throws CoreException {
        String iJobId = null;
        JAXBResourceManagerControl jAXBResourceManagerControl = this;
        synchronized (jAXBResourceManagerControl) {
            ICommandJobStatus status;
            if (this.interactiveJob != null && (status = this.interactiveJob.getJobStatus()) != null) {
                iJobId = status.getJobId();
            }
        }
        this.doControlJob(iJobId, "TERMINATE", null);
        List onShutDown = this.controlData.getShutDownCommand();
        this.runCommands(onShutDown);
    }

    private void doOnStartUp() throws CoreException {
        List onStartUp = this.controlData.getStartUpCommand();
        this.runCommands(onStartUp);
    }

    private void initialize(IProgressMonitor monitor) throws Throwable {
        this.launchEnv = new TreeMap<String, String>();
        this.pinTable = new JobIdPinTable();
        IJAXBResourceManagerConfiguration base = (IJAXBResourceManagerConfiguration)this.getResourceManager().getConfiguration();
        base.clearReferences(false);
        this.rmVarMap = (RMVariableMap)base.getRMVariableMap();
        ResourceManagerData data = base.getResourceManagerData();
        if (data != null) {
            this.controlData = data.getControlData();
        }
        this.setFixedConfigurationProperties(monitor);
        this.launchEnv.clear();
        this.appendLaunchEnv = true;
        this.jobStatusMap = new JobStatusMap((IResourceManagerControl)this, (IResourceManager)this.getResourceManager());
        ((Thread)((Object)this.jobStatusMap)).start();
    }

    private ManagedFilesType maybeAddManagedFileForScript(ManagedFilesType files, boolean delete) {
        PropertyType scriptVar = (PropertyType)this.rmVarMap.get("script");
        PropertyType scriptPathVar = (PropertyType)this.rmVarMap.get("script_path");
        if (scriptVar != null || scriptPathVar != null) {
            if (files == null) {
                files = new ManagedFilesType();
                files.setFileStagingLocation(".eclipsesettings");
            }
            List fileList = files.getFile();
            ManagedFileType scriptFile = null;
            if (!fileList.isEmpty()) {
                for (ManagedFileType f : fileList) {
                    if (!f.getName().equals("managed_file_for_script")) continue;
                    scriptFile = f;
                    break;
                }
            }
            if (scriptFile == null) {
                scriptFile = new ManagedFileType();
                scriptFile.setName("managed_file_for_script");
                fileList.add(scriptFile);
            }
            scriptFile.setResolveContents(Boolean.valueOf(false));
            scriptFile.setUniqueIdPrefix(Boolean.valueOf(true));
            if (scriptPathVar != null) {
                scriptFile.setPath(String.valueOf(scriptPathVar.getValue()));
                scriptFile.setDeleteSourceAfterUse(Boolean.valueOf(false));
            } else {
                scriptFile.setContents("${ptp_rm:script#value}");
                scriptFile.setDeleteSourceAfterUse(Boolean.valueOf(true));
            }
            scriptFile.setDeleteTargetAfterUse(Boolean.valueOf(delete));
        }
        return files;
    }

    private void maybeCleanupManagedFiles(String uuid, ManagedFilesType files) throws CoreException {
        if (files == null || files.getFile().isEmpty()) {
            return;
        }
        ManagedFilesJob job = new ManagedFilesJob(uuid, files, this);
        job.setOperation(ManagedFilesJob.Operation.DELETE);
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {}
    }

    private boolean maybeHandleScript(String uuid, ScriptType script) {
        PropertyType p = (PropertyType)this.rmVarMap.get("script_path");
        if (p != null && p.getValue() != null) {
            return false;
        }
        if (script == null) {
            return false;
        }
        ScriptHandler job = new ScriptHandler(uuid, script, this.rmVarMap, this.launchEnv, false);
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {}
        return script.isDeleteAfterSubmit();
    }

    private boolean maybeKillInteractive(String jobId) {
        ICommandJobStatus status = this.jobStatusMap.getStatus(jobId);
        boolean killed = false;
        if (status != null) {
            killed = status.cancel();
        }
        return killed;
    }

    private boolean maybeTransferManagedFiles(String uuid, ManagedFilesType files) throws CoreException {
        if (files == null || files.getFile().isEmpty()) {
            return true;
        }
        ManagedFilesJob job = new ManagedFilesJob(uuid, files, this);
        job.setOperation(ManagedFilesJob.Operation.COPY);
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {}
        return job.getSuccess();
    }

    private boolean resourceManagerIsActive() {
        AbstractResourceManager rm = this.getResourceManager();
        if (rm != null) {
            String rmState = rm.getState();
            return !rmState.equals("STOPPED");
        }
        return false;
    }

    private ICommandJob runCommand(String uuid, CommandType command, CommandJob.JobMode mode, boolean join) throws CoreException {
        if (command == null) {
            throw CoreExceptionUtils.newException((String)Messages.RMNoSuchCommandError, null);
        }
        CommandJob job = new CommandJob(uuid, command, mode, (IJAXBResourceManager)this.getResourceManager());
        ((Job)job).setProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY, (Object)Boolean.TRUE);
        job.schedule();
        if (join) {
            try {
                job.join();
            }
            catch (InterruptedException interruptedException) {}
            this.checkJobForError(job);
        }
        return job;
    }

    private void runCommands(List<CommandType> cmds) throws CoreException {
        for (CommandType cmd : cmds) {
            this.runCommand(null, cmd, CommandJob.JobMode.INTERACTIVE, true);
        }
    }

    private void setFixedConfigurationProperties(IProgressMonitor monitor) throws CoreException {
        IRemoteConnection rc = this.getRemoteServicesDelegate(monitor).getRemoteConnection();
        if (rc != null) {
            this.rmVarMap.maybeAddProperty("control.user.name", rc.getUsername(), false);
            this.rmVarMap.maybeAddProperty("control.address", rc.getAddress(), false);
            this.rmVarMap.maybeAddProperty("control.working.dir", rc.getWorkingDirectory(), false);
            this.rmVarMap.maybeAddProperty("directory", rc.getWorkingDirectory(), false);
        }
    }

    private void updatePropertyValuesFromTab(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)40);
        this.setFixedConfigurationProperties((IProgressMonitor)progress.newChild(10));
        Map lcattr = configuration.getAttributes();
        for (Object k : lcattr.keySet()) {
            Object value = lcattr.get(k);
            Object target = this.rmVarMap.get(k.toString());
            if (target instanceof PropertyType) {
                PropertyType p = (PropertyType)target;
                p.setValue(value);
                continue;
            }
            if (!(target instanceof AttributeType)) continue;
            AttributeType ja = (AttributeType)target;
            ja.setValue(value);
        }
        progress.worked(10);
        for (String string : this.rmVarMap.getVariables().keySet()) {
            AttributeType ja;
            if (lcattr.containsKey(string)) continue;
            Object target = this.rmVarMap.get(string.toString());
            if (target instanceof PropertyType) {
                PropertyType p = (PropertyType)target;
                if (!p.isVisible()) continue;
                p.setValue(null);
                continue;
            }
            if (!(target instanceof AttributeType) || !(ja = (AttributeType)target).isVisible()) continue;
            ja.setValue(null);
        }
        progress.worked(10);
        this.rmVarMap.maybeOverwrite("script_path", "script_path", configuration);
        this.rmVarMap.maybeOverwrite("directory", "org.eclipse.ptp.launch.WORKING_DIR_ATTR", configuration);
        this.rmVarMap.maybeOverwrite("executablePath", "org.eclipse.ptp.launch.ATTR_REMOTE_EXECUTABLE_PATH", configuration);
        this.rmVarMap.maybeOverwrite("progArgs", "org.eclipse.ptp.launch.ARGUMENT_ATTR", configuration);
        this.launchEnv.clear();
        this.launchEnv.putAll(configuration.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, this.launchEnv));
        this.appendLaunchEnv = configuration.getAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, this.appendLaunchEnv);
    }

    private void worked(IProgressMonitor monitor, int units) {
        if (monitor != null) {
            if (units == 0) {
                monitor.done();
            } else {
                monitor.worked(units);
            }
        }
    }

    private class ConnectionChangeListener
    implements IRemoteConnectionChangeListener {
        public void connectionChanged(IRemoteConnectionChangeEvent event) {
            if (event.getType() == 4 || event.getType() == 1) {
                try {
                    JAXBResourceManagerControl.this.getResourceManager().stop();
                }
                catch (CoreException e) {
                    JAXBControlCorePlugin.log(e);
                }
            }
        }
    }
}

