/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control.internal.runnable;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.UUID;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ptp.core.util.CoreExceptionUtils;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.RemoteServicesDelegate;
import org.eclipse.ptp.rm.jaxb.control.JAXBControlConstants;
import org.eclipse.ptp.rm.jaxb.control.JAXBControlCorePlugin;
import org.eclipse.ptp.rm.jaxb.control.JAXBResourceManagerControl;
import org.eclipse.ptp.rm.jaxb.control.internal.messages.Messages;
import org.eclipse.ptp.rm.jaxb.core.IJAXBResourceManagerControl;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.ptp.rm.jaxb.core.data.AttributeType;
import org.eclipse.ptp.rm.jaxb.core.data.ManagedFileType;
import org.eclipse.ptp.rm.jaxb.core.data.ManagedFilesType;
import org.eclipse.ptp.rm.jaxb.core.data.PropertyType;

public class ManagedFilesJob
extends Job {
    private final String uuid;
    private final IJAXBResourceManagerControl control;
    private final List<ManagedFileType> files;
    private RemoteServicesDelegate delegate;
    private IVariableMap rmVarMap;
    private String stagingDir;
    private boolean success;
    private Operation operation;

    public ManagedFilesJob(String uuid, ManagedFilesType files, IJAXBResourceManagerControl control) throws CoreException {
        super(Messages.ManagedFilesJob);
        this.uuid = uuid;
        this.control = control;
        this.stagingDir = files.getFileStagingLocation();
        this.files = files.getFile();
    }

    public boolean getSuccess() {
        return this.success;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.delegate = this.control.getRemoteServicesDelegate(monitor);
            IRemoteConnection conn = this.delegate.getRemoteConnection();
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
            JAXBResourceManagerControl.checkConnection(conn, progress);
            if (this.delegate.getRemoteFileManager() == null) {
                throw new Throwable(Messages.UninitializedRemoteServices);
            }
        }
        catch (Throwable t) {
            return CoreExceptionUtils.getErrorStatus((String)Messages.ManagedFilesJobError, (Throwable)t);
        }
        this.rmVarMap = this.control.getEnvironment();
        this.success = false;
        try {
            if (this.operation == Operation.COPY) {
                this.doCopy(monitor);
            } else if (this.operation == Operation.DELETE) {
                this.doDelete(monitor);
            }
            this.success = true;
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (Throwable t) {
            IStatus iStatus = CoreExceptionUtils.getErrorStatus((String)Messages.ManagedFilesJobError, (Throwable)t);
            return iStatus;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void copyFileToRemoteHost(String localPath, String remotePath, IProgressMonitor monitor) throws CoreException {
        RemoteServicesDelegate.copy((IRemoteFileManager)this.delegate.getLocalFileManager(), (String)localPath, (IRemoteFileManager)this.delegate.getRemoteFileManager(), (String)remotePath, (int)0, (IProgressMonitor)monitor);
    }

    private void doCopy(IProgressMonitor monitor) throws Throwable {
        this.stagingDir = this.rmVarMap.getString(this.uuid, this.stagingDir);
        boolean localTarget = this.delegate.getLocalFileManager() == this.delegate.getRemoteFileManager();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.files.size() * 10));
        for (ManagedFileType file : this.files) {
            File localFile = this.maybeWriteFile(file);
            progress.worked(5);
            String fileName = localFile.getName();
            String pathSep = localTarget ? JAXBControlConstants.PATH_SEP : "/";
            String target = String.valueOf(this.stagingDir) + pathSep + fileName;
            SubMonitor m = progress.newChild(5);
            this.copyFileToRemoteHost(localFile.getAbsolutePath(), target, (IProgressMonitor)m);
            if (file.isDeleteSourceAfterUse()) {
                localFile.delete();
            }
            if (m.isCanceled()) break;
            PropertyType p = new PropertyType();
            p.setName(file.getName());
            if (localTarget) {
                p.setValue((Object)new File(System.getProperty("user.home"), target).getAbsolutePath());
            } else {
                p.setValue((Object)target);
            }
            p.setVisible(Boolean.valueOf(false));
            this.rmVarMap.put(p.getName(), (Object)p);
            progress.worked(5);
        }
    }

    private void doDelete(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.files.size() * 15));
        for (ManagedFileType file : this.files) {
            if (!file.isDeleteTargetAfterUse()) {
                progress.worked(15);
                continue;
            }
            PropertyType p = (PropertyType)this.rmVarMap.get(file.getName());
            IFileStore store = this.delegate.getRemoteFileManager().getResource(String.valueOf(p.getValue()));
            try {
                if (!store.fetchInfo(0, (IProgressMonitor)progress.newChild(5)).exists()) continue;
                store.delete(0, (IProgressMonitor)progress.newChild(10));
            }
            catch (CoreException t) {
                JAXBControlCorePlugin.log(t);
            }
        }
    }

    private File maybeWriteFile(ManagedFileType file) throws IOException, CoreException {
        String path = file.getPath();
        if (path != null) {
            path = this.rmVarMap.getString(this.uuid, path);
            return new File(path);
        }
        String name = this.rmVarMap.getString(this.uuid, file.getName());
        if (file.isUniqueIdPrefix()) {
            name = UUID.randomUUID() + name;
        }
        File sourceDir = new File(System.getProperty("java.io.tmpdir"));
        File localFile = new File(sourceDir, name);
        String contents = file.getContents();
        OutputStreamWriter fw = null;
        try {
            if (contents == null) {
                if (!localFile.exists() || !localFile.isFile()) {
                    throw new FileNotFoundException(localFile.getAbsolutePath());
                }
            } else {
                if (file.isResolveContents()) {
                    contents = this.rmVarMap.getString(this.uuid, contents);
                } else {
                    int start = contents.indexOf("${ptp_rm:");
                    int end = contents.length();
                    if (start >= 0) {
                        String key;
                        Object o;
                        start += "${ptp_rm:".length();
                        end = contents.indexOf("#");
                        if (end < 0) {
                            end = contents.indexOf("}");
                        }
                        if ((o = this.rmVarMap.get(key = contents.substring(start, end))) instanceof PropertyType) {
                            contents = String.valueOf(((PropertyType)o).getValue());
                        } else if (o instanceof AttributeType) {
                            contents = String.valueOf(((AttributeType)o).getValue());
                        }
                    }
                }
                fw = new FileWriter(localFile, false);
                fw.write(contents);
                fw.flush();
            }
        }
        finally {
            try {
                if (fw != null) {
                    fw.close();
                }
            }
            catch (IOException t) {
                JAXBControlCorePlugin.log(t);
            }
        }
        return localFile;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation {
        COPY,
        DELETE;

    }
}

