/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.sdm.core;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.Preferences;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.IPNode;
import org.eclipse.ptp.core.elements.IPResourceManager;
import org.eclipse.ptp.debug.core.IPDebugger;
import org.eclipse.ptp.debug.core.launch.IPLaunch;
import org.eclipse.ptp.debug.core.pdi.IPDIDebugger;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.Session;
import org.eclipse.ptp.debug.core.pdi.event.IPDIEventFactory;
import org.eclipse.ptp.debug.core.pdi.manager.IPDIManagerFactory;
import org.eclipse.ptp.debug.core.pdi.model.IPDIModelFactory;
import org.eclipse.ptp.debug.core.pdi.request.IPDIRequestFactory;
import org.eclipse.ptp.debug.sdm.core.SDMDebugCorePlugin;
import org.eclipse.ptp.debug.sdm.core.SDMEventFactory;
import org.eclipse.ptp.debug.sdm.core.SDMManagerFactory;
import org.eclipse.ptp.debug.sdm.core.SDMModelFactory;
import org.eclipse.ptp.debug.sdm.core.SDMPreferenceConstants;
import org.eclipse.ptp.debug.sdm.core.SDMRequestFactory;
import org.eclipse.ptp.debug.sdm.core.SDMRunner;
import org.eclipse.ptp.debug.sdm.core.messages.Messages;
import org.eclipse.ptp.debug.sdm.core.pdi.PDIDebugger;
import org.eclipse.ptp.debug.sdm.core.utils.DebugUtil;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.rmsystem.IResourceManager;
import org.eclipse.ptp.rmsystem.IResourceManagerComponentConfiguration;
import org.eclipse.ptp.utils.core.BitSetIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDMDebugger
implements IPDebugger {
    private final IPDIDebugger fPdiDebugger = new PDIDebugger();
    private final IPDIModelFactory fModelFactory = new SDMModelFactory();
    private final IPDIManagerFactory fManagerFactory = new SDMManagerFactory();
    private final IPDIEventFactory fEventFactory = new SDMEventFactory();
    private final IPDIRequestFactory fRequestFactory = new SDMRequestFactory();
    private IFileStore fRoutingFileStore = null;
    private SDMRunner fSdmRunner = null;

    public synchronized void cleanup(IPLaunch launch) {
        if (this.fSdmRunner != null) {
            DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING, Messages.SDMDebugger_8);
            new Thread(Messages.SDMDebugger_7){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING_MORE, Messages.SDMDebugger_9);
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        try {
                            this.wait(5000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        if (SDMDebugger.this.fSdmRunner.getSdmState() == SDMRunner.SDMMasterState.RUNNING) {
                            DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING, Messages.SDMDebugger_11);
                            SDMDebugger.this.fSdmRunner.cancel();
                            try {
                                SDMDebugger.this.fSdmRunner.join();
                            }
                            catch (InterruptedException interruptedException) {}
                        } else {
                            DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING, Messages.SDMDebugger_13);
                        }
                        DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING_MORE, Messages.SDMDebugger_14);
                        SDMDebugger.this.fSdmRunner = null;
                    }
                }
            }.start();
        }
    }

    public synchronized IPDISession createDebugSession(long timeout, IPLaunch launch, IProgressMonitor monitor) throws CoreException {
        Session session;
        int jobSize = this.getJobSize(launch);
        try {
            session = new Session(this.fManagerFactory, this.fRequestFactory, this.fEventFactory, this.fModelFactory, launch.getLaunchConfiguration(), timeout, this.fPdiDebugger, launch.getJobId(), jobSize);
        }
        catch (PDIException e) {
            throw this.newCoreException(e.getLocalizedMessage());
        }
        if (this.fRoutingFileStore != null) {
            this.writeRoutingFile(launch, monitor);
            this.fSdmRunner.setJob(launch.getJobId());
            this.fSdmRunner.schedule();
        }
        return session;
    }

    public synchronized void initialize(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)30);
        try {
            String args;
            String dbgExtraArgs;
            if (Preferences.getBoolean((String)SDMDebugCorePlugin.getUniqueIdentifier(), (String)SDMPreferenceConstants.SDM_DEBUG_CLIENT_ENABLED)) {
                int level = Preferences.getInt((String)SDMDebugCorePlugin.getUniqueIdentifier(), (String)SDMPreferenceConstants.SDM_DEBUG_CLIENT_LEVEL);
                if ((level & 1) == 1) {
                    DebugUtil.SDM_MASTER_TRACING = true;
                }
                if ((level & 2) == 2) {
                    DebugUtil.SDM_MASTER_TRACING_MORE = true;
                }
                if ((level & 4) == 4) {
                    DebugUtil.SDM_MASTER_OUTPUT_TRACING = true;
                }
            }
            ILaunchConfigurationWorkingCopy workingCopy = configuration.getWorkingCopy();
            ArrayList<String> dbgArgs = new ArrayList<String>();
            try {
                this.fPdiDebugger.initialize(configuration, dbgArgs, (IProgressMonitor)progress.newChild(10));
            }
            catch (PDIException e) {
                throw this.newCoreException(e.getLocalizedMessage());
            }
            String localAddress = configuration.getAttribute("org.eclipse.ptp.launch.ATTR_DEBUGGER_HOST", "localhost");
            dbgArgs.add("--host=" + localAddress);
            String debuggerBackend = Preferences.getString((String)SDMDebugCorePlugin.getUniqueIdentifier(), (String)SDMPreferenceConstants.SDM_DEBUGGER_BACKEND_TYPE);
            debuggerBackend = configuration.getAttribute("org.eclipse.ptp.launch.DEBUGGER_SDM_BACKEND", debuggerBackend);
            dbgArgs.add("--debugger=" + debuggerBackend);
            String dbgPath = Preferences.getString((String)SDMDebugCorePlugin.getUniqueIdentifier(), (String)SDMPreferenceConstants.SDM_DEBUGGER_BACKEND_PATH);
            if (dbgPath.length() > 0) {
                dbgArgs.add("--debugger_path=" + dbgPath);
            }
            if ((dbgExtraArgs = Preferences.getString((String)SDMDebugCorePlugin.getUniqueIdentifier(), (String)SDMPreferenceConstants.SDM_DEBUGGER_ARGS)).length() > 0) {
                dbgArgs.addAll(Arrays.asList(dbgExtraArgs.split(" ")));
            }
            if (Preferences.getBoolean((String)SDMDebugCorePlugin.getUniqueIdentifier(), (String)SDMPreferenceConstants.SDM_DEBUG_ENABLED)) {
                dbgArgs.add("--debug=" + Preferences.getInt((String)SDMDebugCorePlugin.getUniqueIdentifier(), (String)SDMPreferenceConstants.SDM_DEBUG_LEVEL));
            }
            args = (args = workingCopy.getAttribute("org.eclipse.ptp.launch.DEBUGGER_ARGS", null)) == null ? this.stringify(dbgArgs) : String.valueOf(args) + " " + this.stringify(dbgArgs);
            workingCopy.setAttribute("org.eclipse.ptp.launch.DEBUGGER_ARGS", args);
            String dbgExePath = configuration.getAttribute("org.eclipse.ptp.launch.DEBUGGER_EXECUTABLE_PATH", "");
            this.verifyResource(dbgExePath, configuration, (IProgressMonitor)progress.newChild(10));
            IResourceManager rm = this.getResourceManager(configuration);
            if (rm.getConfiguration().needsDebuggerLaunchHelp()) {
                this.prepareRoutingFile(configuration, (IProgressMonitor)progress.newChild(10));
                this.fSdmRunner = new SDMRunner(rm);
                ArrayList<String> sdmCommand = new ArrayList<String>();
                sdmCommand.add(dbgExePath);
                sdmCommand.add("--master");
                sdmCommand.addAll(dbgArgs);
                this.fSdmRunner.setCommand(sdmCommand);
                this.fSdmRunner.setWorkDir(this.getWorkingDirectory(configuration));
            }
            workingCopy.doSave();
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private int getJobSize(IPLaunch launch) {
        IPJob job;
        IPResourceManager rm;
        int nprocs = 1;
        IResourceManager rmc = launch.getResourceManager();
        if (rmc != null && (rm = (IPResourceManager)rmc.getAdapter(IPResourceManager.class)) != null && (job = rm.getJobById(launch.getJobId())) != null && (nprocs = job.getProcessJobRanks().cardinality()) == 0) {
            nprocs = 1;
        }
        return nprocs;
    }

    private IResourceManager getResourceManager(ILaunchConfiguration configuration) throws CoreException {
        String rmUniqueName = configuration.getAttribute("org.eclipse.ptp.launch.RESOURCE_MANAGER_NAME", null);
        IResourceManager rm = PTPCorePlugin.getDefault().getModelManager().getResourceManagerFromUniqueName(rmUniqueName);
        if (rm.getState().equals("STARTED")) {
            return rm;
        }
        return null;
    }

    private String getWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        String wd = configuration.getAttribute("org.eclipse.ptp.launch.DEBUGGER_WORKING_DIR", null);
        if ((wd == null || wd.equals("")) && ((wd = configuration.getAttribute("org.eclipse.ptp.launch.WORKING_DIR_ATTR", null)) == null || wd.equals(""))) {
            String execPath = configuration.getAttribute("org.eclipse.ptp.launch.ATTR_REMOTE_EXECUTABLE_PATH", null);
            if (execPath == null) {
                throw this.newCoreException(Messages.SDMDebugger_NoWorkingDir);
            }
            wd = new Path(execPath).removeLastSegments(1).toString();
        }
        return wd;
    }

    private CoreException newCoreException(String message) {
        Status status = new Status(4, SDMDebugCorePlugin.getUniqueIdentifier(), message, null);
        return new CoreException((IStatus)status);
    }

    private void prepareRoutingFile(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        block7: {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
            try {
                Path routingFilePath = new Path(this.getWorkingDirectory(configuration));
                routingFilePath = routingFilePath.append("routing_file");
                IResourceManager rm = this.getResourceManager(configuration);
                IResourceManagerComponentConfiguration conf = rm.getControlConfiguration();
                IRemoteServices remoteServices = PTPRemoteCorePlugin.getDefault().getRemoteServices(conf.getRemoteServicesId(), (IProgressMonitor)progress.newChild(5));
                if (progress.isCanceled()) {
                    throw this.newCoreException(Messages.SDMDebugger_Operation_canceled_by_user);
                }
                IRemoteConnectionManager rconnMgr = remoteServices.getConnectionManager();
                IRemoteConnection rconn = rconnMgr.getConnection(conf.getConnectionName());
                IRemoteFileManager remoteFileManager = remoteServices.getFileManager(rconn);
                this.fRoutingFileStore = remoteFileManager.getResource(routingFilePath.toString());
                if (!this.fRoutingFileStore.fetchInfo(0, (IProgressMonitor)progress.newChild(3)).exists()) break block7;
                try {
                    this.fRoutingFileStore.delete(0, (IProgressMonitor)progress.newChild(2));
                }
                catch (CoreException e) {
                    throw this.newCoreException(e.getLocalizedMessage());
                }
                this.fRoutingFileStore.fetchInfo();
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
    }

    private String stringify(List<String> list) {
        String result = "";
        int i = 0;
        while (i < list.size()) {
            if (i > 0) {
                result = String.valueOf(result) + " ";
            }
            result = String.valueOf(result) + list.get(i);
            ++i;
        }
        return result;
    }

    private IPath verifyResource(String path, ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        IResourceManager rm = this.getResourceManager(configuration);
        if (rm == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.debug.sdm.core", Messages.SDMDebugger_4));
        }
        IResourceManagerComponentConfiguration conf = rm.getControlConfiguration();
        IRemoteServices remoteServices = PTPRemoteCorePlugin.getDefault().getRemoteServices(conf.getRemoteServicesId(), monitor);
        if (monitor.isCanceled()) {
            throw this.newCoreException(Messages.SDMDebugger_Operation_canceled_by_user);
        }
        if (remoteServices == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.debug.sdm.core", Messages.SDMDebugger_0));
        }
        IRemoteConnectionManager connMgr = remoteServices.getConnectionManager();
        if (connMgr == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.debug.sdm.core", Messages.SDMDebugger_1));
        }
        IRemoteConnection conn = connMgr.getConnection(conf.getConnectionName());
        if (conn == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.debug.sdm.core", Messages.SDMDebugger_2));
        }
        IRemoteFileManager fileManager = remoteServices.getFileManager(conn);
        if (fileManager == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.debug.sdm.core", Messages.SDMDebugger_3));
        }
        if (!fileManager.getResource(path).fetchInfo().exists()) {
            throw new CoreException((IStatus)new Status(1, "org.eclipse.ptp.debug.sdm.core", NLS.bind((String)Messages.SDMDebugger_5, (Object[])new Object[]{path})));
        }
        return new Path(path);
    }

    private void writeRoutingFile(IPLaunch launch, IProgressMonitor monitor) throws CoreException {
        DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING, Messages.SDMDebugger_12);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            OutputStream os = null;
            try {
                os = this.fRoutingFileStore.openOutputStream(0, (IProgressMonitor)progress.newChild(10));
            }
            catch (CoreException e) {
                throw this.newCoreException(e.getLocalizedMessage());
            }
            progress.subTask(Messages.SDMDebugger_6);
            PrintWriter pw = new PrintWriter(os);
            String jobId = launch.getJobId();
            IPResourceManager rm = (IPResourceManager)launch.getResourceManager().getAdapter(IPResourceManager.class);
            if (rm != null) {
                IPJob pJob = rm.getJobById(jobId);
                BitSet processJobRanks = pJob.getProcessJobRanks();
                pw.format("%d\n", processJobRanks.cardinality());
                int base = 50000;
                int range = 10000;
                Random random = new Random();
                for (Integer processIndex : new BitSetIterable(processJobRanks)) {
                    String nodeId = pJob.getProcessNodeId(processIndex.intValue());
                    if (nodeId == null) {
                        progress.subTask(Messages.SDMDebugger_10);
                        while (nodeId == null && !progress.isCanceled()) {
                            try {
                                this.wait(1000L);
                            }
                            catch (InterruptedException interruptedException) {}
                            nodeId = pJob.getProcessNodeId(processIndex.intValue());
                            progress.worked(1);
                        }
                    }
                    if (progress.isCanceled()) {
                        throw this.newCoreException(Messages.SDMDebugger_Operation_canceled_by_user);
                    }
                    IPNode node = rm.getNodeById(nodeId);
                    if (node == null) {
                        throw this.newCoreException(Messages.SDMDebugger_15);
                    }
                    String nodeName = node.getName();
                    int portNumber = base + random.nextInt(range);
                    pw.format("%s %s %d\n", processIndex, nodeName, portNumber);
                    progress.setWorkRemaining(60);
                    progress.worked(10);
                }
                pw.close();
            }
            try {
                os.close();
            }
            catch (IOException e) {
                throw this.newCoreException(e.getLocalizedMessage());
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }
}

