/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.services.ui.preferences;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.ServiceModelManager;
import org.eclipse.ptp.services.ui.dialogs.ServiceProviderConfigurationDialog;
import org.eclipse.ptp.services.ui.messages.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ServiceConfigurationPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private final String[] fTableColumnHeaders = new String[]{Messages.ServiceConfigurationPreferencePage_7, Messages.ServiceConfigurationPreferencePage_8};
    private final ColumnLayoutData[] fTableColumnLayouts = new ColumnLayoutData[]{new ColumnWeightData(40), new ColumnWeightData(60)};
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private Button importButton;
    private Button exportButton;
    private TableItem selectedTableItem;
    private Table serviceConfigurationTable;
    private TableViewer serviceConfigurationViewer;
    private Set<IServiceConfiguration> deletedServiceConfigurations = new HashSet<IServiceConfiguration>();
    private Set<IServiceConfiguration> addedServiceConfigurations = new HashSet<IServiceConfiguration>();
    private EventHandler eventHandler;
    private ProjectComparator projectComparator = new ProjectComparator();
    private IServiceConfiguration selectedConfiguration;
    private ServiceConfigurationComparator serviceConfigurationComparator = new ServiceConfigurationComparator();

    public ServiceConfigurationPreferencePage() {
    }

    public ServiceConfigurationPreferencePage(String title) {
        super(title);
    }

    public ServiceConfigurationPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        this.updateServiceConfigurations();
        return super.performOk();
    }

    private void addServiceConfiguration() {
        IServiceConfiguration config = ServiceModelManager.getInstance().newServiceConfiguration(Messages.ServiceConfigurationPreferencePage_6);
        ServiceProviderConfigurationDialog dialog = new ServiceProviderConfigurationDialog(this.getShell(), config);
        if (dialog.open() == 0) {
            this.addedServiceConfigurations.add(config);
            this.serviceConfigurationViewer.refresh();
        }
    }

    private Control createWidgets(Composite parent) {
        this.eventHandler = new EventHandler();
        Composite preferencePane = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginBottom = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginTop = 0;
        preferencePane.setLayout((Layout)layout);
        this.serviceConfigurationTable = new Table(preferencePane, 67586);
        GridData data = new GridData(1808);
        data.widthHint = 425;
        data.heightHint = this.serviceConfigurationTable.getItemHeight();
        data.horizontalSpan = 1;
        this.serviceConfigurationTable.setLayoutData((Object)data);
        this.serviceConfigurationTable.setFont(parent.getFont());
        this.serviceConfigurationTable.addSelectionListener((SelectionListener)this.eventHandler);
        TableLayout tableLayout = new TableLayout();
        this.serviceConfigurationTable.setLayout((Layout)tableLayout);
        this.serviceConfigurationTable.setHeaderVisible(true);
        this.serviceConfigurationTable.setLinesVisible(true);
        int i = 0;
        while (i < this.fTableColumnHeaders.length) {
            tableLayout.addColumnData(this.fTableColumnLayouts[i]);
            TableColumn column = new TableColumn(this.serviceConfigurationTable, 0, i);
            column.setResizable(this.fTableColumnLayouts[i].resizable);
            column.setText(this.fTableColumnHeaders[i]);
            ++i;
        }
        this.serviceConfigurationViewer = new TableViewer(this.serviceConfigurationTable);
        this.serviceConfigurationViewer.setContentProvider((IContentProvider)new ServiceConfigurationContentProvider());
        this.serviceConfigurationViewer.setLabelProvider((IBaseLabelProvider)new ServiceConfigurationLabelProvider());
        this.serviceConfigurationViewer.setInput((Object)ServiceModelManager.getInstance());
        Composite buttonPane = new Composite(preferencePane, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonPane.setLayout((Layout)layout);
        buttonPane.setLayoutData((Object)new GridData(1040));
        buttonPane.setFont(preferencePane.getFont());
        this.addButton = new Button(buttonPane, 8);
        this.setButtonLayoutData(this.addButton);
        this.addButton.setText(Messages.ServiceConfigurationPreferencePage_3);
        this.addButton.addSelectionListener((SelectionListener)this.eventHandler);
        this.editButton = new Button(buttonPane, 8);
        this.setButtonLayoutData(this.editButton);
        this.editButton.setText(Messages.ServiceConfigurationPreferencePage_4);
        this.editButton.addSelectionListener((SelectionListener)this.eventHandler);
        this.editButton.setEnabled(false);
        this.removeButton = new Button(buttonPane, 8);
        this.setButtonLayoutData(this.removeButton);
        this.removeButton.setText(Messages.ServiceConfigurationPreferencePage_5);
        this.removeButton.addSelectionListener((SelectionListener)this.eventHandler);
        this.removeButton.setEnabled(false);
        this.importButton = new Button(buttonPane, 8);
        this.setButtonLayoutData(this.importButton);
        this.importButton.setText(Messages.ServiceConfigurationPreferencePage_9);
        this.importButton.addSelectionListener((SelectionListener)this.eventHandler);
        this.importButton.setEnabled(false);
        this.exportButton = new Button(buttonPane, 8);
        this.setButtonLayoutData(this.exportButton);
        this.exportButton.setText(Messages.ServiceConfigurationPreferencePage_10);
        this.exportButton.addSelectionListener((SelectionListener)this.eventHandler);
        this.exportButton.setEnabled(false);
        return preferencePane;
    }

    private void editServiceConfiguration() {
        ServiceProviderConfigurationDialog dialog;
        if (this.selectedConfiguration != null && (dialog = new ServiceProviderConfigurationDialog(this.getShell(), this.selectedConfiguration)).open() == 0) {
            this.serviceConfigurationViewer.refresh();
        }
    }

    private void removeServiceConfiguration() {
        this.deletedServiceConfigurations.add(this.selectedConfiguration);
        this.serviceConfigurationViewer.refresh();
    }

    private void importServiceConfiguration() {
    }

    private void exportServiceConfiguration() {
    }

    private void setSelectedConfig() {
        boolean enabled;
        TableItem[] selection = this.serviceConfigurationTable.getSelection();
        boolean bl = enabled = selection.length > 0;
        if (enabled) {
            this.selectedTableItem = selection[0];
            this.selectedConfiguration = (IServiceConfiguration)this.selectedTableItem.getData();
        }
        this.editButton.setEnabled(enabled);
        this.removeButton.setEnabled(enabled);
    }

    private void updateServiceConfigurations() {
        this.addedServiceConfigurations.removeAll(this.deletedServiceConfigurations);
        for (IServiceConfiguration config : this.addedServiceConfigurations) {
            ServiceModelManager.getInstance().addConfiguration(config);
        }
        for (IServiceConfiguration config : this.deletedServiceConfigurations) {
            if (ServiceModelManager.getInstance().getConfiguration(config.getId()) == null) continue;
            ServiceModelManager.getInstance().remove(config);
        }
        this.addedServiceConfigurations.clear();
        this.deletedServiceConfigurations.clear();
    }

    protected Control createContents(Composite parent) {
        return this.createWidgets(parent);
    }

    protected void performApply() {
        this.updateServiceConfigurations();
        super.performApply();
    }

    private class EventHandler
    extends SelectionAdapter {
        private EventHandler() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == ServiceConfigurationPreferencePage.this.addButton) {
                ServiceConfigurationPreferencePage.this.addServiceConfiguration();
            } else if (source == ServiceConfigurationPreferencePage.this.editButton) {
                ServiceConfigurationPreferencePage.this.editServiceConfiguration();
            } else if (source == ServiceConfigurationPreferencePage.this.removeButton) {
                ServiceConfigurationPreferencePage.this.removeServiceConfiguration();
            } else if (source == ServiceConfigurationPreferencePage.this.importButton) {
                ServiceConfigurationPreferencePage.this.importServiceConfiguration();
            } else if (source == ServiceConfigurationPreferencePage.this.exportButton) {
                ServiceConfigurationPreferencePage.this.exportServiceConfiguration();
            } else if (source == ServiceConfigurationPreferencePage.this.serviceConfigurationTable) {
                ServiceConfigurationPreferencePage.this.setSelectedConfig();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProjectComparator
    implements Comparator<IProject> {
        private ProjectComparator() {
        }

        @Override
        public int compare(IProject p1, IProject p2) {
            return p1.getName().compareTo(p2.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ServiceConfigurationComparator
    implements Comparator<IServiceConfiguration> {
        private ServiceConfigurationComparator() {
        }

        @Override
        public int compare(IServiceConfiguration s1, IServiceConfiguration s2) {
            return s1.getName().compareTo(s2.getName());
        }
    }

    private class ServiceConfigurationContentProvider
    implements IStructuredContentProvider {
        private ServiceConfigurationContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Set configs = ServiceModelManager.getInstance().getConfigurations();
            configs.addAll(ServiceConfigurationPreferencePage.this.addedServiceConfigurations);
            configs.removeAll(ServiceConfigurationPreferencePage.this.deletedServiceConfigurations);
            Object[] current = configs.toArray(new IServiceConfiguration[0]);
            Arrays.sort(current, ServiceConfigurationPreferencePage.this.serviceConfigurationComparator);
            return current;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ServiceConfigurationLabelProvider
    implements ITableLabelProvider {
        private ServiceConfigurationLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            IServiceConfiguration config = (IServiceConfiguration)element;
            if (columnIndex == 0) {
                return config.getName();
            }
            if (columnIndex == 1) {
                IProject[] projects = ServiceModelManager.getInstance().getProjectsForConfiguration(config).toArray(new IProject[0]);
                Arrays.sort(projects, ServiceConfigurationPreferencePage.this.projectComparator);
                String projectNames = null;
                IProject[] iProjectArray = projects;
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = iProjectArray[n2];
                    projectNames = projectNames != null ? String.valueOf(projectNames) + ", " + project.getName() : project.getName();
                    ++n2;
                }
                return projectNames;
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

