/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control.ui.launch;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.ptp.core.elements.IPQueue;
import org.eclipse.ptp.launch.ui.extensions.AbstractRMLaunchConfigurationDynamicTab;
import org.eclipse.ptp.launch.ui.extensions.RMLaunchValidation;
import org.eclipse.ptp.rm.jaxb.control.ui.JAXBControlUIPlugin;
import org.eclipse.ptp.rm.jaxb.control.ui.launch.JAXBControllerLaunchConfigurationTab;
import org.eclipse.ptp.rm.jaxb.control.ui.messages.Messages;
import org.eclipse.ptp.rm.jaxb.control.ui.variables.LCVariableMap;
import org.eclipse.ptp.rmsystem.IResourceManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJAXBLaunchConfigurationTab
extends AbstractRMLaunchConfigurationDynamicTab {
    protected final JAXBControllerLaunchConfigurationTab parentTab;
    protected final Map<String, Object> localMap;
    protected String title;
    protected Composite control;
    protected Point size;

    protected AbstractJAXBLaunchConfigurationTab(JAXBControllerLaunchConfigurationTab parentTab, ILaunchConfigurationDialog dialog) {
        super(dialog);
        this.parentTab = parentTab;
        this.title = Messages.DefaultDynamicTab_title;
        this.localMap = new TreeMap<String, Object>();
    }

    public abstract Image getImage();

    public Point getSize() {
        return this.size;
    }

    public abstract String getText();

    public RMLaunchValidation performApply(ILaunchConfigurationWorkingCopy configuration, IResourceManager rm, IPQueue queue) {
        if (this.control.isVisible()) {
            Map<String, Object> current = null;
            LCVariableMap lcMap = this.parentTab.getLCMap();
            try {
                try {
                    this.refreshLocal((ILaunchConfiguration)configuration);
                    current = lcMap.swapVariables(this.localMap);
                    lcMap.writeToConfiguration(configuration);
                }
                catch (CoreException t) {
                    JAXBControlUIPlugin.log(t);
                    RMLaunchValidation rMLaunchValidation = new RMLaunchValidation(false, t.getMessage());
                    try {
                        lcMap.swapVariables(current);
                    }
                    catch (CoreException t2) {
                        JAXBControlUIPlugin.log(t2);
                    }
                    return rMLaunchValidation;
                }
            }
            finally {
                try {
                    lcMap.swapVariables(current);
                }
                catch (CoreException t) {
                    JAXBControlUIPlugin.log(t);
                }
            }
        }
        return new RMLaunchValidation(true, null);
    }

    public void setUpSharedEnvironment(Map<String, AbstractJAXBLaunchConfigurationTab> controllers) {
    }

    public void setVisible() {
    }

    protected abstract void doRefreshLocal();

    protected void refreshLocal(ILaunchConfiguration config) throws CoreException {
        TreeMap<String, Object> saved = new TreeMap<String, Object>();
        LCVariableMap lcMap = this.parentTab.getLCMap();
        lcMap.saveStandardConfigurationProperties(config, this.localMap, saved);
        lcMap.saveHiddenNonLinked(this.localMap, saved);
        this.localMap.clear();
        this.localMap.putAll(saved);
        this.doRefreshLocal();
        lcMap.relinkHidden(this.localMap);
    }
}

