/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control.ui.launch;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.ptp.core.elements.IPQueue;
import org.eclipse.ptp.core.util.CoreExceptionUtils;
import org.eclipse.ptp.launch.ui.extensions.RMLaunchValidation;
import org.eclipse.ptp.remote.core.RemoteServicesDelegate;
import org.eclipse.ptp.rm.jaxb.control.ui.IFireContentsChangedEnabled;
import org.eclipse.ptp.rm.jaxb.control.ui.JAXBControlUIPlugin;
import org.eclipse.ptp.rm.jaxb.control.ui.handlers.ValueUpdateHandler;
import org.eclipse.ptp.rm.jaxb.control.ui.launch.AbstractJAXBLaunchConfigurationTab;
import org.eclipse.ptp.rm.jaxb.control.ui.launch.ExtensibleJAXBControllerTab;
import org.eclipse.ptp.rm.jaxb.control.ui.launch.JAXBDynamicLaunchConfigurationTab;
import org.eclipse.ptp.rm.jaxb.control.ui.launch.JAXBImportedScriptLaunchConfigurationTab;
import org.eclipse.ptp.rm.jaxb.control.ui.messages.Messages;
import org.eclipse.ptp.rm.jaxb.control.ui.utils.WidgetActionUtils;
import org.eclipse.ptp.rm.jaxb.control.ui.variables.LCVariableMap;
import org.eclipse.ptp.rm.jaxb.core.IJAXBResourceManager;
import org.eclipse.ptp.rm.jaxb.core.IJAXBResourceManagerConfiguration;
import org.eclipse.ptp.rm.jaxb.core.data.LaunchTabType;
import org.eclipse.ptp.rm.jaxb.core.data.ResourceManagerData;
import org.eclipse.ptp.rm.jaxb.core.data.ScriptType;
import org.eclipse.ptp.rm.jaxb.core.data.TabControllerType;
import org.eclipse.ptp.rmsystem.IResourceManager;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class JAXBControllerLaunchConfigurationTab
extends ExtensibleJAXBControllerTab
implements IFireContentsChangedEnabled,
SelectionListener {
    private RemoteServicesDelegate delegate;
    private final IJAXBResourceManagerConfiguration rmConfig;
    private final LaunchTabType launchTabData;
    private final ValueUpdateHandler updateHandler;
    private final LCVariableMap lcMap;
    private ScriptType script;
    private ScrolledComposite scrolledParent;

    public JAXBControllerLaunchConfigurationTab(IJAXBResourceManager rm, ILaunchConfigurationDialog dialog) throws Throwable {
        super(dialog);
        this.rmConfig = rm.getJAXBConfiguration();
        try {
            ResourceManagerData data = this.rmConfig.getResourceManagerData();
            if (data != null) {
                this.script = data.getControlData().getScript();
            }
            this.voidRMConfig = false;
        }
        catch (Throwable t) {
            this.script = null;
            this.voidRMConfig = true;
            WidgetActionUtils.errorMessage(dialog.getActiveTab().getControl().getShell(), t, Messages.VoidLaunchTabMessage, Messages.VoidLaunchTabTitle, false);
        }
        if (!this.voidRMConfig) {
            this.launchTabData = this.rmConfig.getResourceManagerData().getControlData().getLaunchTab();
            this.updateHandler = new ValueUpdateHandler(this);
            if (this.launchTabData != null) {
                List dynamic = this.launchTabData.getDynamic();
                for (TabControllerType controller : dynamic) {
                    this.addDynamicTab(new JAXBDynamicLaunchConfigurationTab(rm, dialog, controller, this));
                }
                String title = this.launchTabData.getImport();
                if (title != null) {
                    this.addDynamicTab(new JAXBImportedScriptLaunchConfigurationTab(rm, dialog, title, this));
                }
            }
            this.lcMap = new LCVariableMap();
        } else {
            this.getControllers().clear();
            this.launchTabData = null;
            this.updateHandler = null;
            this.lcMap = null;
        }
    }

    public void createControl(Composite parent, IResourceManager rm, IPQueue queue) throws CoreException {
        if (!this.voidRMConfig) {
            this.updateHandler.clear();
            if (parent instanceof ScrolledComposite) {
                this.scrolledParent = (ScrolledComposite)parent;
            }
        }
        super.createControl(parent, rm, queue);
        if (this.tabFolder != null) {
            this.tabFolder.addSelectionListener((SelectionListener)this);
        }
    }

    public void fireContentsChanged() {
        super.fireContentsChanged();
    }

    public RemoteServicesDelegate getDelegate() {
        return this.delegate;
    }

    public LaunchTabType getLaunchTabData() {
        return this.launchTabData;
    }

    public LCVariableMap getLCMap() {
        return this.lcMap;
    }

    public IJAXBResourceManagerConfiguration getRmConfig() {
        return this.rmConfig;
    }

    public ScriptType getScript() {
        return this.script;
    }

    public ValueUpdateHandler getUpdateHandler() {
        return this.updateHandler;
    }

    public boolean hasScript() {
        return this.script != null;
    }

    public RMLaunchValidation initializeFrom(Control control, final IResourceManager rm, IPQueue queue, ILaunchConfiguration configuration) {
        if (!this.voidRMConfig) {
            Job j = new Job(Messages.TabInitialization){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        JAXBControllerLaunchConfigurationTab.this.delegate = ((IJAXBResourceManager)rm).getControl().getRemoteServicesDelegate(monitor);
                        if (JAXBControllerLaunchConfigurationTab.this.delegate.getRemoteConnection() == null) {
                            throw new Throwable(Messages.UninitializedRemoteServices);
                        }
                        JAXBControllerLaunchConfigurationTab.this.lcMap.initialize(JAXBControllerLaunchConfigurationTab.this.rmConfig.getRMVariableMap());
                        JAXBControllerLaunchConfigurationTab.this.updateHandler.clear();
                    }
                    catch (Throwable t) {
                        JAXBControlUIPlugin.log(t);
                        return CoreExceptionUtils.getErrorStatus((String)t.getMessage(), (Throwable)t);
                    }
                    return Status.OK_STATUS;
                }
            };
            j.schedule();
            try {
                j.join();
            }
            catch (InterruptedException interruptedException) {}
            IStatus result = j.getResult();
            if (result.getSeverity() == 4) {
                return new RMLaunchValidation(false, result.getMessage());
            }
        }
        RMLaunchValidation validation = super.initializeFrom(control, rm, queue, configuration);
        if (!this.getControllers().isEmpty()) {
            this.tabFolder.setSelection(this.lastIndex);
            this.setVisibleOnSelected();
        }
        return validation;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.setVisibleOnSelected();
    }

    public void widgetSelected(SelectionEvent e) {
        this.setVisibleOnSelected();
    }

    private void resize(Point p) {
        this.scrolledParent.setMinSize(this.getControl().computeSize(p.x + 25, p.y + 50));
    }

    private void setVisibleOnSelected() {
        this.lastIndex = this.tabFolder.getSelectionIndex();
        AbstractJAXBLaunchConfigurationTab t = this.getControllers().get(this.lastIndex);
        this.resize(t.getSize());
        t.setVisible();
    }
}

