/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control.ui.launch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ptp.core.elements.IPQueue;
import org.eclipse.ptp.core.util.CoreExceptionUtils;
import org.eclipse.ptp.launch.ui.extensions.RMLaunchValidation;
import org.eclipse.ptp.rm.jaxb.control.runnable.ScriptHandler;
import org.eclipse.ptp.rm.jaxb.control.ui.ICellEditorUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.IUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.JAXBControlUIConstants;
import org.eclipse.ptp.rm.jaxb.control.ui.JAXBControlUIPlugin;
import org.eclipse.ptp.rm.jaxb.control.ui.dialogs.ScrollingEditableMessageDialog;
import org.eclipse.ptp.rm.jaxb.control.ui.handlers.ValueUpdateHandler;
import org.eclipse.ptp.rm.jaxb.control.ui.launch.AbstractJAXBLaunchConfigurationTab;
import org.eclipse.ptp.rm.jaxb.control.ui.launch.JAXBControllerLaunchConfigurationTab;
import org.eclipse.ptp.rm.jaxb.control.ui.messages.Messages;
import org.eclipse.ptp.rm.jaxb.control.ui.model.ViewerUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.utils.LaunchTabBuilder;
import org.eclipse.ptp.rm.jaxb.control.ui.utils.WidgetActionUtils;
import org.eclipse.ptp.rm.jaxb.control.ui.variables.LCVariableMap;
import org.eclipse.ptp.rm.jaxb.core.IJAXBResourceManager;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.ptp.rm.jaxb.core.data.TabControllerType;
import org.eclipse.ptp.rm.jaxb.ui.JAXBUIPlugin;
import org.eclipse.ptp.rm.jaxb.ui.util.WidgetBuilderUtils;
import org.eclipse.ptp.rmsystem.IResourceManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBDynamicLaunchConfigurationTab
extends AbstractJAXBLaunchConfigurationTab
implements SelectionListener {
    private final TabControllerType controller;
    private final ValueUpdateHandler updateHandler;
    private final List<Viewer> viewers;
    private final Map<Object, IUpdateModel> localWidgets;
    private final String[] shared;
    private final Collection<IUpdateModel> sharedModels;
    private ILaunchConfiguration listenerConfiguration;

    public JAXBDynamicLaunchConfigurationTab(IJAXBResourceManager rm, ILaunchConfigurationDialog dialog, TabControllerType controller, JAXBControllerLaunchConfigurationTab parentTab) {
        super(parentTab, dialog);
        this.controller = controller;
        String s = controller.getIncludeWidgetValuesFrom();
        this.shared = s == null ? new String[0] : s.split(",");
        this.sharedModels = new ArrayList<IUpdateModel>();
        String title = controller.getTitle();
        if (title != null) {
            this.title = title;
        }
        this.updateHandler = parentTab.getUpdateHandler();
        this.localWidgets = new HashMap<Object, IUpdateModel>();
        this.viewers = new ArrayList<Viewer>();
    }

    public RMLaunchValidation canSave(Control control, IResourceManager rm, IPQueue queue) {
        return this.validateWidgets();
    }

    public void createControl(Composite parent, IResourceManager rm, IPQueue queue) throws CoreException {
        this.control = WidgetBuilderUtils.createComposite((Composite)parent, (Integer)1);
        try {
            LaunchTabBuilder builder = new LaunchTabBuilder(this);
            builder.build(this.control);
        }
        catch (Throwable t) {
            CoreExceptionUtils.newException((String)Messages.CreateControlConfigurableError, (Throwable)t);
        }
        this.createViewScriptGroup(this.control);
        this.size = this.control.computeSize(-1, -1, true);
    }

    public Control getControl() {
        return this.control;
    }

    public TabControllerType getController() {
        return this.controller;
    }

    @Override
    public Image getImage() {
        return null;
    }

    public Map<Object, IUpdateModel> getLocalWidgets() {
        return this.localWidgets;
    }

    public JAXBControllerLaunchConfigurationTab getParent() {
        return this.parentTab;
    }

    @Override
    public String getText() {
        return this.title;
    }

    public RMLaunchValidation initializeFrom(Control control, IResourceManager rm, IPQueue queue, ILaunchConfiguration configuration) {
        try {
            ValueUpdateHandler handler = this.getParent().getUpdateHandler();
            this.listenerConfiguration = configuration;
            this.viewers.clear();
            for (Map.Entry<Object, IUpdateModel> e : this.localWidgets.entrySet()) {
                Object key = e.getKey();
                if (key instanceof Viewer) {
                    Viewer viewer = (Viewer)key;
                    this.viewers.add(viewer);
                }
                handler.addUpdateModelEntry(key, e.getValue());
            }
            LCVariableMap lcMap = this.parentTab.getLCMap();
            lcMap.updateGlobal(configuration);
            for (IUpdateModel m : this.localWidgets.values()) {
                m.initialize(lcMap);
            }
            for (IUpdateModel m : this.localWidgets.values()) {
                if (!(m instanceof ViewerUpdateModel)) continue;
                ((ViewerUpdateModel)m).initializeChecked();
            }
            for (Viewer v : this.viewers) {
                v.refresh();
            }
        }
        catch (Throwable t) {
            JAXBControlUIPlugin.log(t);
            return new RMLaunchValidation(false, t.getMessage());
        }
        return new RMLaunchValidation(true, null);
    }

    public RMLaunchValidation isValid(ILaunchConfiguration launchConfig, IResourceManager rm, IPQueue queue) {
        return this.validateWidgets();
    }

    @Override
    public RMLaunchValidation performApply(ILaunchConfigurationWorkingCopy configuration, IResourceManager rm, IPQueue queue) {
        RMLaunchValidation v;
        if (this.control.isVisible() && !(v = this.validateWidgets()).isSuccess()) {
            return v;
        }
        return super.performApply(configuration, rm, queue);
    }

    public RMLaunchValidation setDefaults(ILaunchConfigurationWorkingCopy configuration, IResourceManager rm, IPQueue queue) {
        return new RMLaunchValidation(true, null);
    }

    @Override
    public void setUpSharedEnvironment(Map<String, AbstractJAXBLaunchConfigurationTab> controllers) {
        this.sharedModels.clear();
        String[] stringArray = this.shared;
        int n = this.shared.length;
        int n2 = 0;
        while (n2 < n) {
            String title = stringArray[n2];
            AbstractJAXBLaunchConfigurationTab tab = controllers.get(title);
            if (tab instanceof JAXBDynamicLaunchConfigurationTab) {
                this.sharedModels.addAll(((JAXBDynamicLaunchConfigurationTab)tab).localWidgets.values());
            }
            ++n2;
        }
    }

    @Override
    public void setVisible() {
        try {
            String lastVisited = this.parentTab.getLastVisited();
            if (this.title.equals(lastVisited)) {
                return;
            }
            this.parentTab.setLastVisited(this.title);
            this.listenerConfiguration.getWorkingCopy().setAttribute("visible", ((Object)((Object)this)).toString());
            this.fireContentsChanged();
        }
        catch (CoreException t) {
            JAXBUIPlugin.log((Throwable)t);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        Button b = (Button)e.getSource();
        Shell shell = Display.getDefault().getActiveShell();
        String title = "";
        try {
            String text = "";
            if (Messages.ViewConfig.equals(b.getText())) {
                text = this.displayConfigurationContents(this.listenerConfiguration);
                title = Messages.DisplayConfig;
            } else {
                if (!this.parentTab.hasScript()) {
                    MessageDialog.openWarning((Shell)shell, (String)Messages.ScriptNotSupportedWarning_title, (String)(String.valueOf(Messages.ScriptNotSupportedWarning) + JAXBControlUIConstants.LINE_SEP));
                    return;
                }
                text = this.realizeLocalScript(this.listenerConfiguration);
                title = Messages.DisplayScript;
            }
            new ScrollingEditableMessageDialog(shell, title, text, true).open();
        }
        catch (Throwable t) {
            WidgetActionUtils.errorMessage(shell, t, Messages.DisplayError, Messages.DisplayErrorTitle, false);
        }
    }

    @Override
    protected void doRefreshLocal() {
        Object value = null;
        ArrayList<ViewerUpdateModel> viewerModels = new ArrayList<ViewerUpdateModel>();
        for (IUpdateModel iUpdateModel : this.getModels()) {
            if (!iUpdateModel.isWritable()) continue;
            if (iUpdateModel instanceof ViewerUpdateModel) {
                viewerModels.add((ViewerUpdateModel)iUpdateModel);
                continue;
            }
            if (iUpdateModel instanceof ICellEditorUpdateModel) {
                if (!((ICellEditorUpdateModel)iUpdateModel).isChecked() || (value = iUpdateModel.getValueFromControl()) == null) continue;
                this.localMap.put(iUpdateModel.getName(), value);
                continue;
            }
            value = iUpdateModel.getValueFromControl();
            if (value == null) continue;
            this.localMap.put(iUpdateModel.getName(), value);
        }
        for (ViewerUpdateModel viewerUpdateModel : viewerModels) {
            value = viewerUpdateModel.getValueFromControl();
            if (value != null) {
                this.localMap.put(viewerUpdateModel.getName(), value);
            }
            viewerUpdateModel.putCheckedSettings(this.localMap);
        }
    }

    private void createViewScriptGroup(Composite control) {
        GridLayout layout = WidgetBuilderUtils.createGridLayout((Integer)3, (Boolean)true, (Integer)5, (Integer)5, (Integer)2, (Integer)2);
        GridData gd = WidgetBuilderUtils.createGridData((Integer)0, (Integer)3);
        Group grp = WidgetBuilderUtils.createGroup((Composite)control, (Integer)0, (Layout)layout, (Object)gd);
        if (this.parentTab.hasScript()) {
            WidgetBuilderUtils.createPushButton((Composite)grp, (String)Messages.ViewScript, (SelectionListener)this);
        }
        WidgetBuilderUtils.createPushButton((Composite)grp, (String)Messages.ViewConfig, (SelectionListener)this);
        WidgetBuilderUtils.createPushButton((Composite)grp, (String)Messages.DefaultValues, (SelectionListener)new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                JAXBDynamicLaunchConfigurationTab.this.resetDefaults();
            }
        });
    }

    private synchronized String displayConfigurationContents(final ILaunchConfiguration config) throws Throwable {
        final StringBuffer buffer = new StringBuffer();
        this.refreshLocal(config);
        Job job = new Job(""){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Map attr = config.getAttributes();
                    for (Map.Entry e : attr.entrySet()) {
                        Object v = e.getValue();
                        if (v == null || "".equals(v)) continue;
                        buffer.append(e.getKey()).append("=").append(v).append(JAXBControlUIConstants.LINE_SEP);
                    }
                }
                catch (CoreException t) {
                    return CoreExceptionUtils.getErrorStatus((String)t.getMessage(), (Throwable)t);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {}
        return buffer.toString();
    }

    private Collection<IUpdateModel> getModels() {
        ArrayList<IUpdateModel> models = new ArrayList<IUpdateModel>();
        models.addAll(this.sharedModels);
        models.addAll(this.localWidgets.values());
        return models;
    }

    private synchronized String realizeLocalScript(ILaunchConfiguration config) throws Throwable {
        String value = "";
        this.refreshLocal(config);
        LCVariableMap lcMap = this.parentTab.getLCMap();
        Map<String, Object> current = lcMap.swapVariables(this.localMap);
        Map env = config.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null);
        ScriptHandler job = new ScriptHandler(null, this.parentTab.getScript(), (IVariableMap)lcMap, env, true);
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {}
        value = job.getScriptValue();
        lcMap.swapVariables(current);
        return value;
    }

    private synchronized void resetDefaults() {
        Collection<IUpdateModel> models = this.localWidgets.values();
        for (IUpdateModel m : models) {
            if (m instanceof ICellEditorUpdateModel) {
                if (!((ICellEditorUpdateModel)m).isChecked()) continue;
                m.restoreDefault();
                continue;
            }
            m.restoreDefault();
        }
        for (IUpdateModel m : models) {
            if (!(m instanceof ViewerUpdateModel)) continue;
            ((ViewerUpdateModel)m).storeValue();
        }
        this.updateHandler.handleUpdate(null, null);
        for (Viewer v : this.viewers) {
            v.refresh();
        }
    }

    private RMLaunchValidation validateWidgets() {
        for (IUpdateModel m : this.localWidgets.values()) {
            String error = m.validate();
            if (error == null) continue;
            return new RMLaunchValidation(false, error);
        }
        return new RMLaunchValidation(true, null);
    }
}

