/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.core.rtsystem;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.ModelManager;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.util.DebugUtil;
import org.eclipse.ptp.proxy.runtime.client.AbstractProxyRuntimeClient;
import org.eclipse.ptp.proxy.runtime.command.IProxyRuntimeCommandFactory;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeEventFactory;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionChangeEvent;
import org.eclipse.ptp.remote.core.IRemoteConnectionChangeListener;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;
import org.eclipse.ptp.rm.core.RMCorePlugin;
import org.eclipse.ptp.rm.core.messages.Messages;
import org.eclipse.ptp.rm.core.rmsystem.IRemoteResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.AbstractResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.IResourceManager;

public abstract class AbstractRemoteProxyRuntimeClient
extends AbstractProxyRuntimeClient {
    private IProgressMonitor fStartupMonitor = null;
    private IRemoteConnection fRemoteConnection = null;
    private final IRemoteResourceManagerConfiguration fConfig;
    private final ConnectionChangeHandler fConnectionChangeHandler = new ConnectionChangeHandler();

    public AbstractRemoteProxyRuntimeClient(IRemoteResourceManagerConfiguration config, int baseModelId) {
        super(config.getName(), baseModelId);
        this.fConfig = config;
        this.initDebugOptions();
    }

    public AbstractRemoteProxyRuntimeClient(IRemoteResourceManagerConfiguration config, int baseModelId, IProxyRuntimeCommandFactory cmdFactory, IProxyRuntimeEventFactory eventFactory) {
        super(config.getName(), baseModelId, cmdFactory, eventFactory);
        this.fConfig = config;
        this.initDebugOptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws IOException {
        if (this.fRemoteConnection != null) {
            this.fRemoteConnection.removeConnectionChangeListener((IRemoteConnectionChangeListener)this.fConnectionChangeHandler);
        }
        super.shutdown();
        try {
            this.sessionFinish();
        }
        catch (IOException e) {
            PTPCorePlugin.log((Throwable)e);
        }
        AbstractRemoteProxyRuntimeClient abstractRemoteProxyRuntimeClient = this;
        synchronized (abstractRemoteProxyRuntimeClient) {
            if (this.fStartupMonitor != null) {
                this.fStartupMonitor.setCanceled(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void startup(IProgressMonitor monitor) throws IOException {
        block65: {
            block64: {
                block63: {
                    block67: {
                        block62: {
                            block61: {
                                subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)16);
                                if (this.getDebugOptions().CLIENT_TRACING) {
                                    System.out.println(String.valueOf(this.toString()) + " - firing up proxy, waiting for connection.  Please wait!  This can take a minute . . .");
                                    System.out.println("PROXY_SERVER path = '" + this.getConfiguration().getName() + "'");
                                }
                                var3_3 = this;
                                synchronized (var3_3) {
                                    this.fStartupMonitor = subMon;
                                }
                                subMon.subTask(Messages.AbstractRemoteProxyRuntimeClient_1);
                                remoteServices = PTPRemoteCorePlugin.getDefault().getRemoteServices(this.getConfiguration().getRemoteServicesId(), (IProgressMonitor)subMon.newChild(4));
                                if (remoteServices == null) {
                                    throw new IOException(NLS.bind((String)Messages.AbstractRemoteProxyRuntimeClient_10, (Object)this.getConfiguration().getRemoteServicesId()));
                                }
                                connMgr = remoteServices.getConnectionManager();
                                this.fRemoteConnection = connMgr.getConnection(this.getConfiguration().getConnectionName());
                                if (this.fRemoteConnection == null) {
                                    throw new IOException(NLS.bind((String)Messages.AbstractRemoteProxyRuntimeClient_11, (Object)this.getConfiguration().getConnectionName()));
                                }
                                subMon.worked(5);
                                if (!this.getConfiguration().testOption(4)) ** GOTO lbl91
                                subMon.subTask(Messages.AbstractRemoteProxyRuntimeClient_2);
                                this.sessionCreate();
                                subMon.worked(5);
                                args = new ArrayList<String>();
                                args.add(this.getConfiguration().getProxyServerPath());
                                args.add("--proxy=tcp");
                                if (!this.getConfiguration().testOption(2)) ** GOTO lbl74
                                subMon.subTask(Messages.AbstractRemoteProxyRuntimeClient_4);
                                if (!this.fRemoteConnection.isOpen()) {
                                    this.fRemoteConnection.open((IProgressMonitor)subMon.newChild(4));
                                }
                                if (!subMon.isCanceled()) break block61;
                                this.fRemoteConnection.close();
                                var13_10 = this;
                                synchronized (var13_10) {
                                    this.fStartupMonitor = null;
                                }
                                if (monitor != null) {
                                    monitor.done();
                                }
                                return;
                            }
                            subMon.subTask(Messages.AbstractRemoteProxyRuntimeClient_5);
                            try {
                                remotePort = this.fRemoteConnection.forwardRemotePort("localhost", this.getSessionPort(), (IProgressMonitor)subMon.newChild(1));
                            }
                            catch (RemoteConnectionException e) {
                                throw new IOException(e.getMessage());
                            }
                            if (!subMon.isCanceled()) break block62;
                            this.sessionFinish();
                            var13_11 = this;
                            synchronized (var13_11) {
                                this.fStartupMonitor = null;
                            }
                            if (monitor != null) {
                                monitor.done();
                            }
                            return;
                        }
                        args.add("--host=localhost");
                        args.add("--port=" + remotePort);
                        break block67;
lbl74:
                        // 1 sources

                        args.add("--host=" + this.getConfiguration().getLocalAddress());
                        args.add("--port=" + this.getSessionPort());
                    }
                    if (this.getDebugOptions().SERVER_DEBUG_LEVEL > 0) {
                        args.add("--debug=" + this.getDebugOptions().SERVER_DEBUG_LEVEL);
                    }
                    args.addAll(this.getConfiguration().getInvocationOptions());
                    if (this.getDebugOptions().CLIENT_TRACING) {
                        System.out.println("Launch command: " + args.toString());
                    }
                    msg = NLS.bind((String)Messages.AbstractRemoteProxyRuntimeClient_3, (Object)args.toString());
                    subMon.subTask(msg);
                    info = new Status(1, PTPCorePlugin.getUniqueIdentifier(), 1, msg, null);
                    PTPCorePlugin.log((IStatus)info);
                    ** GOTO lbl189
lbl91:
                    // 1 sources

                    subMon.subTask(Messages.AbstractRemoteProxyRuntimeClient_4);
                    if (!this.fRemoteConnection.isOpen()) {
                        this.fRemoteConnection.open((IProgressMonitor)subMon.newChild(4));
                    }
                    if (!subMon.isCanceled()) break block63;
                    this.fRemoteConnection.close();
                    var13_12 = this;
                    synchronized (var13_12) {
                        this.fStartupMonitor = null;
                    }
                    if (monitor != null) {
                        monitor.done();
                    }
                    return;
                }
                subMon.subTask(Messages.AbstractRemoteProxyRuntimeClient_5);
                fileManager = remoteServices.getFileManager(this.fRemoteConnection);
                if (fileManager == null) {
                    throw new IOException(Messages.AbstractRemoteProxyRuntimeClient_9);
                }
                res = fileManager.getResource(this.getConfiguration().getProxyServerPath());
                try {
                    if (!res.fetchInfo(0, (IProgressMonitor)subMon.newChild(2)).exists()) {
                        throw new IOException(NLS.bind((String)Messages.AbstractRemoteProxyRuntimeClient_12, (Object)this.getConfiguration().getProxyServerPath()));
                    }
                }
                catch (CoreException v4) {
                    throw new IOException(NLS.bind((String)Messages.AbstractRemoteProxyRuntimeClient_12, (Object)this.getConfiguration().getProxyServerPath()));
                }
                if (!subMon.isCanceled()) break block64;
                this.fRemoteConnection.close();
                var13_13 = this;
                synchronized (var13_13) {
                    this.fStartupMonitor = null;
                }
                if (monitor != null) {
                    monitor.done();
                }
                return;
            }
            subMon.subTask(Messages.AbstractRemoteProxyRuntimeClient_6);
            this.sessionCreate();
            subMon.worked(1);
            args = new ArrayList<String>();
            args.add(this.getConfiguration().getProxyServerPath());
            args.add("--proxy=tcp");
            if (!this.getConfiguration().testOption(2)) ** GOTO lbl167
            try {
                remotePort = this.fRemoteConnection.forwardRemotePort("localhost", this.getSessionPort(), (IProgressMonitor)subMon.newChild(1));
            }
            catch (RemoteConnectionException e) {
                throw new IOException(e.getMessage());
            }
            if (!subMon.isCanceled()) break block65;
            this.sessionFinish();
            var13_14 = this;
            synchronized (var13_14) {
                this.fStartupMonitor = null;
            }
            if (monitor != null) {
                monitor.done();
            }
            return;
        }
        try {
            try {
                block68: {
                    args.add("--host=localhost");
                    args.add("--port=" + remotePort);
                    break block68;
lbl167:
                    // 1 sources

                    args.add("--host=" + this.getConfiguration().getLocalAddress());
                    args.add("--port=" + this.getSessionPort());
                }
                if (this.getDebugOptions().SERVER_DEBUG_LEVEL > 0) {
                    args.add("--debug=" + this.getDebugOptions().SERVER_DEBUG_LEVEL);
                }
                args.addAll(this.getConfiguration().getInvocationOptions());
                if (this.getDebugOptions().CLIENT_TRACING) {
                    System.out.println("Launch command: " + args.toString());
                }
                subMon.subTask(Messages.AbstractRemoteProxyRuntimeClient_7);
                processBuilder = remoteServices.getProcessBuilder(this.fRemoteConnection, args);
                process = processBuilder.start();
                subMon.worked(2);
                err_reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                out_reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                new Thread(new Runnable(){

                    public void run() {
                        try {
                            String output;
                            while ((output = out_reader.readLine()) != null) {
                                System.out.println(String.valueOf(AbstractRemoteProxyRuntimeClient.this.getConfiguration().getName()) + ": " + output);
                            }
                            out_reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                }, Messages.AbstractRemoteProxyRuntimeClient_15).start();
                new Thread(new Runnable(){

                    public void run() {
                        try {
                            String line;
                            while ((line = err_reader.readLine()) != null) {
                                System.err.println(String.valueOf(AbstractRemoteProxyRuntimeClient.this.getConfiguration().getName()) + ": " + line);
                            }
                            err_reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                }, Messages.AbstractRemoteProxyRuntimeClient_14).start();
                if (this.getDebugOptions().CLIENT_TRACING) {
                    System.out.println(String.valueOf(this.toString()) + ": Waiting on accept.");
                }
lbl189:
                // 4 sources

                subMon.subTask(Messages.AbstractRemoteProxyRuntimeClient_8);
                super.startup();
                subMon.worked(2);
                this.fRemoteConnection.addConnectionChangeListener((IRemoteConnectionChangeListener)this.fConnectionChangeHandler);
            }
            catch (IOException e) {
                try {
                    this.sessionFinish();
                }
                catch (IOException e1) {
                    PTPCorePlugin.log((Throwable)e1);
                }
                throw new IOException(NLS.bind((String)Messages.AbstractRemoteProxyRuntimeClient_13, (Object)e.getMessage()));
            }
            catch (RemoteConnectionException e) {
                throw new IOException(NLS.bind((String)Messages.AbstractRemoteProxyRuntimeClient_13, (Object)e.getMessage()));
            }
        }
        catch (Throwable var12_29) {
            var13_15 = this;
            synchronized (var13_15) {
                this.fStartupMonitor = null;
            }
            if (monitor != null) {
                monitor.done();
            }
            throw var12_29;
        }
        var13_16 = this;
        synchronized (var13_16) {
            this.fStartupMonitor = null;
        }
        if (monitor != null) {
            monitor.done();
        }
    }

    private void initDebugOptions() {
        this.getDebugOptions().PROTOCOL_TRACING = DebugUtil.PROTOCOL_TRACING;
        this.getDebugOptions().CLIENT_TRACING = DebugUtil.PROXY_CLIENT_TRACING;
        this.getDebugOptions().SERVER_DEBUG_LEVEL = DebugUtil.PROXY_SERVER_DEBUG_LEVEL;
    }

    protected IRemoteResourceManagerConfiguration getConfiguration() {
        return this.fConfig;
    }

    private class ConnectionChangeHandler
    implements IRemoteConnectionChangeListener {
        public void connectionChanged(IRemoteConnectionChangeEvent event) {
            IRemoteResourceManagerConfiguration config;
            if ((event.getType() == 4 || event.getType() == 1) && (config = AbstractRemoteProxyRuntimeClient.this.getConfiguration()) instanceof AbstractResourceManagerConfiguration) {
                IResourceManager rm = ModelManager.getInstance().getResourceManagerFromUniqueName(((AbstractResourceManagerConfiguration)config).getUniqueName());
                try {
                    rm.stop();
                }
                catch (CoreException e) {
                    RMCorePlugin.log(e);
                }
            }
        }
    }
}

