/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.core;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.rm.lml.core.JobStatusData;
import org.eclipse.ptp.rm.lml.core.LMLCorePlugin;
import org.eclipse.ptp.rm.lml.core.listeners.ILMLListener;
import org.eclipse.ptp.rm.lml.core.listeners.IViewListener;
import org.eclipse.ptp.rm.lml.core.model.ILguiItem;
import org.eclipse.ptp.rm.lml.internal.core.events.JobListSortedEvent;
import org.eclipse.ptp.rm.lml.internal.core.events.LguiAddedEvent;
import org.eclipse.ptp.rm.lml.internal.core.events.LguiRemovedEvent;
import org.eclipse.ptp.rm.lml.internal.core.events.LguiSelectedEvent;
import org.eclipse.ptp.rm.lml.internal.core.events.MarkObjectEvent;
import org.eclipse.ptp.rm.lml.internal.core.events.SelectedObjectChangeEvent;
import org.eclipse.ptp.rm.lml.internal.core.events.TableColumnChangeEvent;
import org.eclipse.ptp.rm.lml.internal.core.events.UnmarkObjectEvent;
import org.eclipse.ptp.rm.lml.internal.core.events.UnselectObjectEvent;
import org.eclipse.ptp.rm.lml.internal.core.events.ViewAddedEvent;
import org.eclipse.ptp.rm.lml.internal.core.events.ViewDisposedEvent;
import org.eclipse.ptp.rm.lml.internal.core.events.ViewUpdateEvent;
import org.eclipse.ptp.rm.lml.internal.core.model.LguiItem;
import org.eclipse.ui.IMemento;

public class LMLManager {
    protected final Map<String, ILguiItem> LGUIS = new HashMap<String, ILguiItem>();
    private ILguiItem fLguiItem = null;
    private final ListenerList lmlListeners = new ListenerList();
    private final ListenerList viewListeners = new ListenerList();
    private static LMLManager manager;
    private boolean isDisplayed = false;

    public static LMLManager getInstance() {
        if (manager == null) {
            manager = new LMLManager();
        }
        return manager;
    }

    private LMLManager() {
        manager = this;
    }

    public void addComponent(String gid) {
        if (this.fLguiItem.getLayoutAccess() != null) {
            String type = this.fLguiItem.getLayoutAccess().setComponentActive(gid, true);
            this.fireAddView(gid, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addLgui(URI xmlFile) {
        if (!this.LGUIS.containsKey(xmlFile.getPath())) {
            this.fLguiItem = new LguiItem(xmlFile);
            Map<String, ILguiItem> map = this.LGUIS;
            synchronized (map) {
                this.LGUIS.put(xmlFile.getPath(), this.fLguiItem);
            }
            this.fireNewLgui();
            return false;
        }
        this.fLguiItem = this.LGUIS.get(xmlFile);
        return true;
    }

    public void addListener(ILMLListener listener, String view) {
        this.lmlListeners.add((Object)listener);
    }

    public void addListener(IViewListener listener) {
        this.viewListeners.add((Object)listener);
    }

    public void addListener(IViewListener listener, String view) {
        this.viewListeners.add((Object)listener);
    }

    public void addUserJob(String name, String jobId, JobStatusData status) {
        ILguiItem item = this.LGUIS.get(name);
        if (item != null) {
            item.addUserJob(jobId, status, true);
        }
        if (item == this.fLguiItem) {
            this.fireUpdatedLgui();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeLgui(String name, IMemento memento) {
        ILguiItem item = null;
        Map<String, ILguiItem> map = this.LGUIS;
        synchronized (map) {
            item = this.LGUIS.get(name);
            if (item != null) {
                this.LGUIS.remove(name);
            }
        }
        if (this.fLguiItem != null && this.fLguiItem == item) {
            this.fireRemovedLgui(item);
            this.fLguiItem = null;
        }
        this.saveJobStatusData(item, memento);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILguiItem[] getLguiItems() {
        Map<String, ILguiItem> map = this.LGUIS;
        synchronized (map) {
            Collection<ILguiItem> lguis = this.LGUIS.values();
            return lguis.toArray(new ILguiItem[lguis.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getLguis() {
        Map<String, ILguiItem> map = this.LGUIS;
        synchronized (map) {
            Set<String> lguis = this.LGUIS.keySet();
            return lguis.toArray(new String[lguis.size()]);
        }
    }

    public void getRequestXml() {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream("request.xml");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.fLguiItem.getRequestXml(os);
    }

    public int getSelectedLguiIndex(String title) {
        int index = 0;
        int i = 0;
        for (String key : this.LGUIS.keySet()) {
            if (title.equals(key)) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    public ILguiItem getSelectedLguiItem() {
        return this.fLguiItem;
    }

    public JobStatusData getUserJob(String name, String jobId) {
        ILguiItem item = this.LGUIS.get(name);
        if (item != null) {
            return item.getUserJob(jobId);
        }
        return null;
    }

    public void markObject(String oid) {
        this.fireMarkObject(oid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openLgui(String name, IMemento memento) {
        Map<String, ILguiItem> map = this.LGUIS;
        synchronized (map) {
            ILguiItem item = this.LGUIS.get(name);
            if (item == null) {
                item = new LguiItem(name);
                this.LGUIS.put(name, item);
            }
            this.fLguiItem = item;
        }
        this.restoreJobStatusData(this.fLguiItem, memento);
        if (!this.fLguiItem.isEmpty()) {
            this.fireNewLgui();
        }
    }

    public void removeComponent(String gid) {
        if (this.fLguiItem.getLayoutAccess() != null) {
            this.fLguiItem.getLayoutAccess().setComponentActive(gid, false);
            this.fireRemoveView(gid);
        }
    }

    public void removeLgui(String title) {
        this.LGUIS.remove(title);
        this.fLguiItem = this.LGUIS.isEmpty() ? null : this.LGUIS.get(this.getLguis()[0]);
        this.fireRemovedLgui(null);
    }

    public void removeListener(ILMLListener listener) {
        this.lmlListeners.remove((Object)listener);
    }

    public void removeListener(IViewListener listener) {
        this.viewListeners.remove((Object)listener);
    }

    public void removeUserJob(String name, String jobId) {
        ILguiItem lguiItem = this.LGUIS.get(name);
        if (lguiItem != null) {
            lguiItem.removeUserJob(jobId);
        }
        if (lguiItem == this.fLguiItem) {
            this.fireUpdatedLgui();
        }
    }

    public void selectLgui(String name) {
        ILguiItem item;
        this.fireRemovedLgui(null);
        if (name != null && (item = this.LGUIS.get(name)) != null) {
            this.fLguiItem = item;
            this.fireNewLgui();
            return;
        }
        this.fLguiItem = null;
    }

    public void selectLgui(URI xmlFile) {
        this.fLguiItem = this.LGUIS.get(xmlFile.getPath());
        this.fireSelectedLgui();
    }

    public void selectObject(String oid) {
        this.fireChangeSelectedObject(oid);
    }

    public void setTableColumnActive(String gid, String title) {
        if (this.fLguiItem.getTableHandler() != null) {
            this.fLguiItem.getTableHandler().setTableColumnActive(gid, title, true);
            this.fireChangeTableColumn();
        }
    }

    public void setTableColumnNonActive(String gid, String title) {
        if (this.fLguiItem.getTableHandler() != null) {
            this.fLguiItem.getTableHandler().setTableColumnActive(gid, title, false);
            this.fireChangeTableColumn();
        }
    }

    public void sortLgui() {
        this.fireSortedLgui();
    }

    public void unmarkObject(String oid) {
        this.fireUnmarkObject(oid);
    }

    public void unselectObject(String oid) {
        this.fireUnselectObject(oid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String name, InputStream input, OutputStream output) throws CoreException {
        ILguiItem lguiItem = null;
        Map<String, ILguiItem> map = this.LGUIS;
        synchronized (map) {
            lguiItem = this.LGUIS.get(name);
        }
        if (lguiItem != null) {
            try {
                lguiItem.getCurrentLayout(output);
            }
            catch (JAXBException e) {
                throw new CoreException((IStatus)new Status(4, LMLCorePlugin.getUniqueIdentifier(), e.getCause().getLocalizedMessage()));
            }
            try {
                lguiItem.update(input);
            }
            catch (JAXBException e) {
                throw new CoreException((IStatus)new Status(4, LMLCorePlugin.getUniqueIdentifier(), e.getCause().getLocalizedMessage()));
            }
            if (this.fLguiItem == lguiItem) {
                if (!this.isDisplayed) {
                    this.fireNewLgui();
                } else {
                    this.fireUpdatedLgui();
                }
            }
        }
    }

    public void updateUserJob(String name, String jobId, String status, String detail) {
        ILguiItem lguiItem = this.LGUIS.get(name);
        if (lguiItem != null) {
            lguiItem.updateUserJob(jobId, status, detail);
        }
        if (lguiItem == this.fLguiItem) {
            this.fireUpdatedLgui();
        }
    }

    private void fireAddView(String gid, String type) {
        ViewAddedEvent event = new ViewAddedEvent(gid, type);
        Object[] objectArray = this.viewListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IViewListener)listener).handleEvent(event);
            ++n2;
        }
    }

    private void fireChangeSelectedObject(String oid) {
        SelectedObjectChangeEvent event = new SelectedObjectChangeEvent(oid);
        Object[] objectArray = this.lmlListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ILMLListener)listener).handleEvent(event);
            ++n2;
        }
    }

    private void fireChangeTableColumn() {
        TableColumnChangeEvent event = new TableColumnChangeEvent(this, this.fLguiItem);
        Object[] objectArray = this.lmlListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ILMLListener)listener).handleEvent(event);
            ++n2;
        }
    }

    private void fireMarkObject(String oid) {
        MarkObjectEvent event = new MarkObjectEvent(oid);
        Object[] objectArray = this.lmlListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ILMLListener)listener).handleEvent(event);
            ++n2;
        }
    }

    private void fireNewLgui() {
        LguiAddedEvent event = new LguiAddedEvent();
        Object[] objectArray = this.lmlListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ILMLListener)listener).handleEvent(event);
            ++n2;
        }
        this.isDisplayed = true;
    }

    private void fireRemovedLgui(ILguiItem title) {
        LguiRemovedEvent event = new LguiRemovedEvent();
        Object[] objectArray = this.lmlListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ILMLListener)listener).handleEvent(event);
            ++n2;
        }
        this.isDisplayed = false;
    }

    private void fireRemoveView(String gid) {
        ViewDisposedEvent event = new ViewDisposedEvent();
        Object[] objectArray = this.viewListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IViewListener)listener).handleEvent(event);
            ++n2;
        }
    }

    private void fireSelectedLgui() {
        LguiSelectedEvent event = new LguiSelectedEvent(this, this.fLguiItem);
        Object[] objectArray = this.viewListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IViewListener)listener).handleEvent(event);
            ++n2;
        }
    }

    private void fireSortedLgui() {
        JobListSortedEvent event = new JobListSortedEvent(this, this.fLguiItem);
        Object[] objectArray = this.lmlListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ILMLListener)listener).handleEvent(event);
            ++n2;
        }
    }

    private void fireUnmarkObject(String oid) {
        UnmarkObjectEvent event = new UnmarkObjectEvent(oid);
        Object[] objectArray = this.lmlListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ILMLListener)listener).handleEvent(event);
            ++n2;
        }
    }

    private void fireUnselectObject(String oid) {
        UnselectObjectEvent event = new UnselectObjectEvent(oid);
        Object[] objectArray = this.lmlListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ILMLListener)listener).handleEvent(event);
            ++n2;
        }
    }

    private void fireUpdatedLgui() {
        ViewUpdateEvent event = new ViewUpdateEvent();
        Object[] objectArray = this.lmlListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ILMLListener)listener).handleEvent(event);
            ++n2;
        }
    }

    private void restoreJobStatusData(ILguiItem item, IMemento memento) {
        if (memento != null) {
            for (JobStatusData status : JobStatusData.reload(memento)) {
                item.addUserJob(status.getJobId(), status, false);
            }
        }
    }

    private void saveJobStatusData(ILguiItem item, IMemento memento) {
        JobStatusData[] jobStatusDataArray = item.getUserJobs();
        int n = jobStatusDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            JobStatusData status = jobStatusDataArray[n2];
            if (!status.isRemoved()) {
                status.save(memento);
            }
            ++n2;
        }
    }
}

