/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.ptp.debug.core.messages.Messages;
import org.eclipse.ptp.debug.core.model.IPValue;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.model.IPDIArgumentDescriptor;
import org.eclipse.ptp.debug.core.pdi.model.IPDILocalVariableDescriptor;
import org.eclipse.ptp.debug.core.pdi.model.IPDIVariable;
import org.eclipse.ptp.debug.core.pdi.model.IPDIVariableDescriptor;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIF;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeArray;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeRange;
import org.eclipse.ptp.debug.internal.core.model.AbstractPValue;
import org.eclipse.ptp.debug.internal.core.model.PDebugElement;
import org.eclipse.ptp.debug.internal.core.model.PStackFrame;
import org.eclipse.ptp.debug.internal.core.model.PValueFactory;
import org.eclipse.ptp.debug.internal.core.model.PVariable;

public class PLocalVariable
extends PVariable {
    public PLocalVariable(PDebugElement parent, IPDIVariableDescriptor pdiVariableObject) {
        super(parent, pdiVariableObject);
    }

    public PLocalVariable(PDebugElement parent, IPDIVariableDescriptor pdiVariableObject, String errorMessage) {
        super(parent, pdiVariableObject, errorMessage);
    }

    public IAIF getAIF() throws DebugException {
        return this.getValue().getAIF();
    }

    protected void createOriginal(IPDIVariableDescriptor vo) {
        if (vo != null) {
            this.setName(vo.getName());
            this.setOriginal(new InternalVariable(this, vo));
        }
    }

    private class InternalVariable
    implements PVariable.IInternalVariable {
        private boolean fChanged = false;
        private IPDIVariable fPDIVariable;
        private IPDIVariableDescriptor fPDIVariableObject;
        private String fQualifiedName;
        private IPValue fValue = PValueFactory.NULL_VALUE;
        private PVariable fVariable;

        InternalVariable(PVariable var, IPDIVariableDescriptor varObject) {
            this.setVariable(var);
            this.setPDIVariableObject(varObject);
            this.setPDIVariable(varObject instanceof IPDIVariable ? (IPDIVariable)varObject : null);
        }

        public PVariable.IInternalVariable createShadow(int start, int length) throws DebugException {
            InternalVariable iv = null;
            try {
                iv = new InternalVariable(this.getVariable(), this.getPDIVariableObject().getVariableDescriptorAsArray(start, length));
            }
            catch (PDIException e) {
                PLocalVariable.requestFailed(e.getMessage(), null);
            }
            return iv;
        }

        public PVariable.IInternalVariable createShadow(String type) throws DebugException {
            InternalVariable iv = null;
            try {
                iv = new InternalVariable(this.getVariable(), this.getPDIVariableObject().getVariableDescriptorAsType(type));
            }
            catch (PDIException e) {
                PLocalVariable.requestFailed(e.getMessage(), null);
            }
            return iv;
        }

        public void dispose(boolean destroy) {
            this.invalidate(destroy);
        }

        public boolean equals(Object obj) {
            if (obj instanceof InternalVariable) {
                return this.getPDIVariableObject().equals(((InternalVariable)obj).getPDIVariableObject());
            }
            return false;
        }

        public String getQualifiedName() throws DebugException {
            if (this.fQualifiedName == null) {
                try {
                    this.fQualifiedName = this.fPDIVariableObject != null ? this.fPDIVariableObject.getQualifiedName() : null;
                }
                catch (PDIException e) {
                    PLocalVariable.requestFailed(e.getMessage(), null);
                }
            }
            return this.fQualifiedName;
        }

        public synchronized IPValue getValue() throws DebugException {
            IPDIVariable var;
            if (this.fValue.equals(PValueFactory.NULL_VALUE) && (var = this.getPDIVariable()) != null) {
                try {
                    IAIF aif = var.getAIF();
                    if (aif != null && aif.getType() instanceof IAIFTypeArray) {
                        IAIFTypeRange range = ((IAIFTypeArray)aif.getType()).getRange();
                        this.fValue = PValueFactory.createIndexedValue(this.getVariable(), var, 0, range.getSize());
                    } else {
                        this.fValue = PValueFactory.createValue(this.getVariable(), var);
                    }
                }
                catch (PDIException e) {
                    PLocalVariable.requestFailed(e.getMessage(), null);
                }
            }
            return this.fValue;
        }

        public void invalidateValue() {
            if (this.fValue instanceof AbstractPValue) {
                ((AbstractPValue)this.fValue).dispose();
                this.fValue = PValueFactory.NULL_VALUE;
                if (this.fPDIVariable != null) {
                    this.fPDIVariable.resetValue();
                }
            }
        }

        public boolean isArgument() {
            return this.getPDIVariableObject() instanceof IPDIArgumentDescriptor;
        }

        public boolean isChanged() {
            return this.fChanged;
        }

        public boolean isEditable() throws DebugException {
            IPDIVariable var = this.getPDIVariable();
            if (var != null) {
                try {
                    return var.isEditable();
                }
                catch (PDIException pDIException) {}
            }
            return false;
        }

        public boolean isSameDescriptor(IPDIVariableDescriptor desc) {
            return this.getPDIVariableObject().equals(desc);
        }

        public boolean isSameVariable(IPDIVariable pdiVar) {
            return this.fPDIVariable != null ? this.fPDIVariable.equals(pdiVar) : false;
        }

        public synchronized void preserve() {
            this.setChanged(false);
            if (this.fValue instanceof AbstractPValue) {
                ((AbstractPValue)this.fValue).preserve();
            }
        }

        public void resetValue() {
            if (this.fValue instanceof AbstractPValue) {
                ((AbstractPValue)this.fValue).reset();
            }
        }

        public synchronized void setChanged(boolean changed) {
            if (changed) {
                this.invalidateValue();
            }
            if (this.fValue instanceof AbstractPValue) {
                ((AbstractPValue)this.fValue).setChanged(changed);
            }
            this.fChanged = changed;
        }

        public void setValue(String expression) throws DebugException {
            IPDIVariable pdiVariable = null;
            try {
                pdiVariable = this.getPDIVariable();
                if (pdiVariable != null) {
                    pdiVariable.setValue(expression);
                } else {
                    PLocalVariable.requestFailed(Messages.PLocalVariable_0, null);
                }
            }
            catch (PDIException e) {
                PLocalVariable.targetRequestFailed(e.getMessage(), null);
            }
        }

        public int sizeof() {
            if (this.getPDIVariableObject() != null) {
                try {
                    return this.getPDIVariableObject().sizeof();
                }
                catch (PDIException pDIException) {}
            }
            return 0;
        }

        private synchronized IPDIVariable getPDIVariable() throws DebugException {
            if (this.fPDIVariable == null) {
                try {
                    this.fPDIVariable = ((PStackFrame)PLocalVariable.this.getStackFrame()).getPDIStackFrame().createLocalVariable((IPDILocalVariableDescriptor)this.getPDIVariableObject());
                }
                catch (PDIException e) {
                    PLocalVariable.requestFailed(e.getMessage(), null);
                }
            }
            return this.fPDIVariable;
        }

        private IPDIVariableDescriptor getPDIVariableObject() {
            if (this.fPDIVariable != null) {
                return this.fPDIVariable;
            }
            return this.fPDIVariableObject;
        }

        private synchronized void invalidate(boolean destroy) {
            try {
                if (destroy && this.fPDIVariable != null) {
                    this.fPDIVariable.dispose();
                }
            }
            catch (PDIException e) {
                PLocalVariable.this.logError(e.getMessage());
            }
            this.invalidateValue();
            this.setPDIVariable(null);
        }

        private void setPDIVariable(IPDIVariable variable) {
            this.fPDIVariable = variable;
        }

        private void setPDIVariableObject(IPDIVariableDescriptor variableObject) {
            this.fPDIVariableObject = variableObject;
        }

        private void setVariable(PVariable variable) {
            this.fVariable = variable;
        }

        private PVariable getVariable() {
            return this.fVariable;
        }
    }
}

