/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTArrayDeclarator;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTDeclarator;

public class CPPASTArrayDeclarator
extends CPPASTDeclarator
implements ICPPASTArrayDeclarator {
    private IASTArrayModifier[] arrayMods = null;
    private int arrayModsPos = -1;

    public CPPASTArrayDeclarator(IASTName name, IASTInitializer initializer) {
        super(name, initializer);
    }

    public CPPASTArrayDeclarator(IASTName name) {
        super(name);
    }

    public CPPASTArrayDeclarator() {
    }

    public CPPASTArrayDeclarator copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    public CPPASTArrayDeclarator copy(IASTNode.CopyStyle style) {
        CPPASTArrayDeclarator copy = new CPPASTArrayDeclarator();
        this.copyBaseDeclarator(copy, style);
        IASTArrayModifier[] iASTArrayModifierArray = this.getArrayModifiers();
        int n = iASTArrayModifierArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTArrayModifier modifier = iASTArrayModifierArray[n2];
            copy.addArrayModifier(modifier == null ? null : modifier.copy(style));
            ++n2;
        }
        if (style == IASTNode.CopyStyle.withLocations) {
            copy.setCopyLocation(this);
        }
        return copy;
    }

    public IASTArrayModifier[] getArrayModifiers() {
        if (this.arrayMods == null) {
            return IASTArrayModifier.EMPTY_ARRAY;
        }
        this.arrayMods = (IASTArrayModifier[])ArrayUtil.removeNullsAfter(IASTArrayModifier.class, this.arrayMods, this.arrayModsPos);
        return this.arrayMods;
    }

    public void addArrayModifier(IASTArrayModifier arrayModifier) {
        this.assertNotFrozen();
        if (arrayModifier != null) {
            this.arrayMods = (IASTArrayModifier[])ArrayUtil.append(IASTArrayModifier.class, this.arrayMods, ++this.arrayModsPos, arrayModifier);
            arrayModifier.setParent(this);
            arrayModifier.setPropertyInParent(ARRAY_MODIFIER);
        }
    }

    protected boolean postAccept(ASTVisitor action) {
        IASTArrayModifier[] mods = this.getArrayModifiers();
        int i = 0;
        while (i < mods.length) {
            if (!mods[i].accept(action)) {
                return false;
            }
            ++i;
        }
        return super.postAccept(action);
    }
}

