/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.indexer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMIndexer;
import org.eclipse.cdt.core.dom.IPDOMIndexerTask;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementVisitor;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.ExternalTranslationUnit;
import org.eclipse.cdt.internal.core.pdom.IndexerProgress;
import org.eclipse.cdt.internal.core.pdom.indexer.Messages;
import org.eclipse.cdt.internal.core.pdom.indexer.PDOMIndexerTask;
import org.eclipse.cdt.internal.core.pdom.indexer.TranslationUnitCollector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDOMUpdateTask
implements IPDOMIndexerTask {
    protected static final String TRUE = String.valueOf(true);
    protected static final ITranslationUnit[] NO_TUS = new ITranslationUnit[0];
    private final IPDOMIndexer fIndexer;
    private final IndexerProgress fProgress;
    private final int fUpdateOptions;
    private volatile IPDOMIndexerTask fDelegate;
    private ArrayList<ICElement> fFilesAndFolders = null;

    public PDOMUpdateTask(IPDOMIndexer indexer, int updateOptions) {
        this.fIndexer = indexer;
        this.fProgress = this.createProgress();
        this.fUpdateOptions = updateOptions;
    }

    private IndexerProgress createProgress() {
        IndexerProgress progress = new IndexerProgress();
        progress.fTimeEstimate = 1000;
        return progress;
    }

    @Override
    public IPDOMIndexer getIndexer() {
        return this.fIndexer;
    }

    @Override
    public void run(IProgressMonitor monitor) throws InterruptedException {
        monitor.subTask(NLS.bind((String)Messages.PDOMIndexerTask_collectingFilesTask, (Object)this.fIndexer.getProject().getElementName()));
        ICProject project = this.fIndexer.getProject();
        if (project.getProject().isOpen()) {
            try {
                if (!"org.eclipse.cdt.core.nullindexer".equals(this.fIndexer.getID())) {
                    this.createDelegate(project, monitor);
                }
            }
            catch (CoreException e) {
                CCorePlugin.log((Throwable)e);
            }
        }
        if (this.fDelegate != null) {
            this.fDelegate.run(monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDelegate(ICProject project, IProgressMonitor monitor) throws CoreException, InterruptedException {
        ITranslationUnit[] tus;
        IPDOMIndexerTask delegate;
        HashSet<ITranslationUnit> set = new HashSet<ITranslationUnit>();
        TranslationUnitCollector collector = new TranslationUnitCollector(set, set, monitor);
        boolean haveProject = false;
        if (this.fFilesAndFolders == null) {
            project.accept((ICElementVisitor)collector);
        } else {
            for (ICElement elem : this.fFilesAndFolders) {
                if (elem.getElementType() == 11) {
                    haveProject = true;
                }
                elem.accept((ICElementVisitor)collector);
            }
        }
        if (haveProject && (this.fUpdateOptions & 8) != 0) {
            String projectPrefix = String.valueOf(project.getProject().getFullPath().toString()) + '/';
            IIndex index = CCorePlugin.getIndexManager().getIndex(project);
            index.acquireReadLock();
            try {
                IIndexFile[] files;
                IIndexFile[] iIndexFileArray = files = index.getAllFiles();
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    ITranslationUnit tu;
                    IPath path;
                    IIndexFile indexFile = iIndexFileArray[n2];
                    IIndexFileLocation floc = indexFile.getLocation();
                    String fullPath = floc.getFullPath();
                    if (!(fullPath != null && fullPath.startsWith(projectPrefix) || (path = IndexLocationFactory.getAbsolutePath(floc)) == null || (tu = CoreModel.getDefault().createTranslationUnitFrom(project, path)) == null)) {
                        IResource file;
                        if (fullPath != null && tu instanceof ExternalTranslationUnit && (file = ResourcesPlugin.getWorkspace().getRoot().findMember(fullPath)) instanceof IFile) {
                            ((ExternalTranslationUnit)tu).setResource((IFile)file);
                        }
                        set.add(tu);
                    }
                    ++n2;
                }
            }
            finally {
                index.releaseReadLock();
            }
        }
        if ((delegate = this.fIndexer.createTask(NO_TUS, tus = set.toArray(new ITranslationUnit[set.size()]), NO_TUS)) instanceof PDOMIndexerTask) {
            PDOMIndexerTask task = (PDOMIndexerTask)delegate;
            task.setUpdateFlags(this.fUpdateOptions);
        }
        PDOMUpdateTask pDOMUpdateTask = this;
        synchronized (pDOMUpdateTask) {
            this.fDelegate = delegate;
        }
    }

    @Override
    public synchronized IndexerProgress getProgressInformation() {
        return this.fDelegate != null ? this.fDelegate.getProgressInformation() : this.fProgress;
    }

    @Override
    public synchronized boolean acceptUrgentTask(IPDOMIndexerTask task) {
        return this.fDelegate != null && this.fDelegate.acceptUrgentTask(task);
    }

    public void setTranslationUnitSelection(List<ICElement> filesAndFolders) {
        this.fFilesAndFolders = new ArrayList(filesAndFolders.size());
        this.fFilesAndFolders.addAll(filesAndFolders);
    }
}

