/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.core;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.ptp.rm.jaxb.core.JAXBCoreConstants;
import org.eclipse.ptp.rm.jaxb.core.JAXBCorePlugin;
import org.eclipse.ptp.rm.jaxb.core.data.AttributeType;
import org.eclipse.ptp.rm.jaxb.core.data.ControlType;
import org.eclipse.ptp.rm.jaxb.core.data.MonitorType;
import org.eclipse.ptp.rm.jaxb.core.data.PropertyType;
import org.eclipse.ptp.rm.jaxb.core.data.ResourceManagerData;
import org.eclipse.ptp.rm.jaxb.core.messages.Messages;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBInitializationUtils {
    private static Unmarshaller unmarshaller;
    private static Validator validator;

    private JAXBInitializationUtils() {
    }

    public static String getRMConfigurationXML(URL url) throws IOException {
        StringBuffer buffer = new StringBuffer();
        if (url != null) {
            InputStreamReader reader = new InputStreamReader(url.openStream());
            char[] chars = new char[4096];
            int read = 0;
            while (true) {
                try {
                    read = reader.read(chars, 0, chars.length);
                }
                catch (EOFException eOFException) {
                    break;
                }
                if (read <= 0) break;
                buffer.append(chars, 0, read);
            }
            return buffer.toString();
        }
        return null;
    }

    public static void initializeMap(ResourceManagerData rmData, IVariableMap instance) {
        ControlType control = rmData.getControlData();
        instance.clear();
        Map<String, Object> env = instance.getVariables();
        JAXBInitializationUtils.addProperties(env, control);
        JAXBInitializationUtils.addAttributes(env, control);
        instance.setInitialized(true);
    }

    public static ResourceManagerData initializeRMData(String xml) throws IOException, SAXException, URISyntaxException, JAXBException {
        return JAXBInitializationUtils.unmarshalResourceManagerData(xml);
    }

    public static ResourceManagerData initializeRMData(URL url) throws IOException, SAXException, URISyntaxException, JAXBException {
        return JAXBInitializationUtils.initializeRMData(JAXBInitializationUtils.getRMConfigurationXML(url));
    }

    public static void validate(URL url) throws SAXException, IOException, URISyntaxException {
        JAXBInitializationUtils.validate(new StreamSource(url.openStream()));
    }

    private static void addAttributes(Map<String, Object> env, ControlType control) {
        if (control == null) {
            return;
        }
        List<AttributeType> jobAttributes = control.getAttribute();
        for (AttributeType jobAttribute : jobAttributes) {
            env.put(jobAttribute.getName(), jobAttribute);
            if (jobAttribute.getValue() != null) continue;
            jobAttribute.setValue(jobAttribute.getDefault());
        }
    }

    private static void addProperties(Map<String, Object> env, ControlType control) {
        if (control == null) {
            return;
        }
        List<PropertyType> properties = control.getProperty();
        for (PropertyType property : properties) {
            env.put(property.getName(), property);
            if (property.getValue() != null) continue;
            property.setValue(property.getDefault());
        }
    }

    private static synchronized Unmarshaller getUnmarshaller() throws JAXBException {
        if (unmarshaller == null) {
            JAXBContext jc = JAXBContext.newInstance((String)"org.eclipse.ptp.rm.jaxb.core.data", (ClassLoader)JAXBInitializationUtils.class.getClassLoader());
            unmarshaller = jc.createUnmarshaller();
        }
        return unmarshaller;
    }

    private static synchronized Validator getValidator() throws IOException, SAXException {
        if (validator == null) {
            URL xsd = JAXBCorePlugin.getResource("data/resource_manager_type.xsd");
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = factory.newSchema(xsd);
            validator = schema.newValidator();
        }
        return validator;
    }

    private static String printInfo(SAXParseException e) {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(Messages.PublicId) + e.getPublicId()).append(JAXBCoreConstants.LINE_SEP);
        sb.append(String.valueOf(Messages.SystemId) + e.getSystemId()).append(JAXBCoreConstants.LINE_SEP);
        sb.append(String.valueOf(Messages.LineNumber) + e.getLineNumber()).append(JAXBCoreConstants.LINE_SEP);
        sb.append(String.valueOf(Messages.ColumnNumber) + e.getColumnNumber()).append(JAXBCoreConstants.LINE_SEP);
        sb.append(String.valueOf(Messages.Message) + e.getMessage()).append(JAXBCoreConstants.LINE_SEP);
        return sb.toString();
    }

    private static ResourceManagerData unmarshalResourceManagerData(String xml) throws JAXBException, IOException, SAXException, URISyntaxException {
        StreamSource source = new StreamSource(new StringReader(xml));
        JAXBInitializationUtils.validate(source);
        source = new StreamSource(new StringReader(xml));
        JAXBElement o = (JAXBElement)JAXBInitializationUtils.getUnmarshaller().unmarshal((Source)source);
        ResourceManagerData rmdata = (ResourceManagerData)o.getValue();
        if (rmdata != null) {
            if (rmdata.getControlData() == null) {
                rmdata.setControlData(new ControlType());
            }
            if (rmdata.getMonitorData() == null) {
                rmdata.setMonitorData(new MonitorType());
            }
        }
        return rmdata;
    }

    private static void validate(Source source) throws SAXException, IOException, URISyntaxException {
        try {
            JAXBInitializationUtils.getValidator().validate(source);
        }
        catch (SAXParseException sax) {
            JAXBCorePlugin.log(JAXBInitializationUtils.printInfo(sax));
            throw sax;
        }
    }
}

