/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.ptp.core.events.IJobChangedEvent;
import org.eclipse.ptp.core.listeners.IJobListener;
import org.eclipse.ptp.debug.core.launch.IPLaunch;
import org.eclipse.ptp.launch.PTPLaunchPlugin;
import org.eclipse.ptp.launch.messages.Messages;
import org.eclipse.ptp.rmsystem.IJobStatus;
import org.eclipse.ptp.rmsystem.IResourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeProcess
implements IProcess,
IJobListener {
    private IPLaunch fLaunch = null;
    private final IResourceManager fResourceManager;
    private String fJobId = null;
    private Map<String, String> fAttributes;
    private int fExitValue = -1;
    private boolean fTerminated = false;

    public RuntimeProcess(IPLaunch launch, IResourceManager rm, String jobId, Map<String, String> attributes) {
        this.fLaunch = launch;
        this.fResourceManager = rm;
        this.fJobId = jobId;
        rm.addJobListener((IJobListener)this);
        this.initializeAttributes(attributes);
        this.fTerminated = rm.getJobStatus(jobId, null).getState().equals("COMPLETED");
        launch.addProcess((IProcess)this);
    }

    private void initializeAttributes(Map<String, String> attributes) {
        if (attributes != null) {
            for (String key : attributes.keySet()) {
                this.setAttribute(key, attributes.get(key));
            }
        }
    }

    public String getLabel() {
        return String.valueOf(this.fResourceManager.getName()) + ": job_" + this.fJobId;
    }

    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    public IStreamsProxy getStreamsProxy() {
        return this.fResourceManager.getJobStatus(this.fJobId, null).getStreamsProxy();
    }

    public void setAttribute(String key, String value) {
        String origVal;
        if (this.fAttributes == null) {
            this.fAttributes = new HashMap<String, String>(5);
        }
        if ((origVal = this.fAttributes.get(key)) != null && origVal.equals(value)) {
            return;
        }
        this.fAttributes.put(key, value);
    }

    public String getAttribute(String key) {
        if (this.fAttributes == null) {
            return null;
        }
        return this.fAttributes.get(key);
    }

    public int getExitValue() throws DebugException {
        if (this.isTerminated()) {
            return this.fExitValue;
        }
        throw new DebugException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), 4, Messages.RuntimeProcess_0, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void terminated() {
        RuntimeProcess runtimeProcess = this;
        synchronized (runtimeProcess) {
            this.fTerminated = true;
        }
        this.fExitValue = 0;
        this.fireTerminateEvent();
    }

    public synchronized boolean canTerminate() {
        return !this.fTerminated;
    }

    public synchronized boolean isTerminated() {
        return this.fTerminated;
    }

    public void terminate() throws DebugException {
        if (!this.isTerminated()) {
            try {
                this.fResourceManager.control(this.fJobId, "TERMINATE", null);
            }
            catch (CoreException e) {
                throw new DebugException(e.getStatus());
            }
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IProcess.class)) {
            return this;
        }
        if (adapter.equals(ILaunch.class)) {
            return this.getLaunch();
        }
        return null;
    }

    public void handleEvent(IJobChangedEvent e) {
        IResourceManager rm = e.getSource();
        IJobStatus status = rm.getJobStatus(e.getJobId(), null);
        if (status.getState().equals("COMPLETED")) {
            this.terminated();
        }
    }

    protected void fireEvent(DebugEvent event) {
        DebugPlugin manager = DebugPlugin.getDefault();
        if (manager != null) {
            manager.fireDebugEventSet(new DebugEvent[]{event});
        }
    }

    protected void fireTerminateEvent() {
        this.fireEvent(new DebugEvent((Object)this, 8));
    }
}

