/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.internal.core.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.eclipse.ptp.rm.lml.internal.core.elements.DataElement;
import org.eclipse.ptp.rm.lml.internal.core.elements.DataElement1;
import org.eclipse.ptp.rm.lml.internal.core.elements.DataElement2;
import org.eclipse.ptp.rm.lml.internal.core.elements.DataElement3;
import org.eclipse.ptp.rm.lml.internal.core.elements.DataElement4;
import org.eclipse.ptp.rm.lml.internal.core.elements.DataElement5;
import org.eclipse.ptp.rm.lml.internal.core.elements.DataElement6;
import org.eclipse.ptp.rm.lml.internal.core.elements.DataElement7;
import org.eclipse.ptp.rm.lml.internal.core.elements.DataElement8;
import org.eclipse.ptp.rm.lml.internal.core.elements.DataElement9;
import org.eclipse.ptp.rm.lml.internal.core.elements.DataType;
import org.eclipse.ptp.rm.lml.internal.core.elements.GobjectType;
import org.eclipse.ptp.rm.lml.internal.core.elements.LayoutType;
import org.eclipse.ptp.rm.lml.internal.core.elements.LguiType;
import org.eclipse.ptp.rm.lml.internal.core.elements.Nodedisplay;
import org.eclipse.ptp.rm.lml.internal.core.elements.Nodedisplayelement;
import org.eclipse.ptp.rm.lml.internal.core.elements.Nodedisplayelement0;
import org.eclipse.ptp.rm.lml.internal.core.elements.Nodedisplayelement1;
import org.eclipse.ptp.rm.lml.internal.core.elements.Nodedisplayelement2;
import org.eclipse.ptp.rm.lml.internal.core.elements.Nodedisplayelement3;
import org.eclipse.ptp.rm.lml.internal.core.elements.Nodedisplayelement4;
import org.eclipse.ptp.rm.lml.internal.core.elements.Nodedisplayelement5;
import org.eclipse.ptp.rm.lml.internal.core.elements.Nodedisplayelement6;
import org.eclipse.ptp.rm.lml.internal.core.elements.Nodedisplayelement7;
import org.eclipse.ptp.rm.lml.internal.core.elements.Nodedisplayelement8;
import org.eclipse.ptp.rm.lml.internal.core.elements.Nodedisplayelement9;
import org.eclipse.ptp.rm.lml.internal.core.elements.NodedisplaylayoutType;
import org.eclipse.ptp.rm.lml.internal.core.elements.ObjectsType;
import org.eclipse.ptp.rm.lml.internal.core.elements.SchemeElement;
import org.eclipse.ptp.rm.lml.internal.core.elements.SchemeElement1;
import org.eclipse.ptp.rm.lml.internal.core.elements.SchemeElement2;
import org.eclipse.ptp.rm.lml.internal.core.elements.SchemeElement3;
import org.eclipse.ptp.rm.lml.internal.core.elements.SchemeElement4;
import org.eclipse.ptp.rm.lml.internal.core.elements.SchemeElement5;
import org.eclipse.ptp.rm.lml.internal.core.elements.SchemeElement6;
import org.eclipse.ptp.rm.lml.internal.core.elements.SchemeElement7;
import org.eclipse.ptp.rm.lml.internal.core.elements.SchemeElement8;
import org.eclipse.ptp.rm.lml.internal.core.elements.SchemeElement9;
import org.eclipse.ptp.rm.lml.internal.core.elements.SchemeType;
import org.eclipse.ptp.rm.lml.internal.core.model.ErrorList;
import org.eclipse.ptp.rm.lml.internal.core.model.Messages;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LMLCheck {
    private static final String line = "-----------------------------------";

    public static void addAllowedNames(ErrorList errlist, HashSet<String> names, Object schemeElement, String aname) {
        List els = LMLCheck.getLowerSchemeElements(schemeElement);
        if (els == null) {
            return;
        }
        int i = 0;
        while (i < els.size()) {
            SchemeElement el = (SchemeElement)els.get(i);
            if (el.getMin() != null) {
                int min;
                int max = min = el.getMin().intValue();
                if (el.getMax() != null) {
                    max = el.getMax().intValue();
                }
                int step = el.getStep().intValue();
                if (min > max) {
                    errlist.addError(String.valueOf(Messages.LMLCheck_1) + aname + Messages.LMLCheck_2 + min + Messages.LMLCheck_3 + max);
                }
                int j = min;
                while (j <= max) {
                    String thisname = String.valueOf(aname) + LMLCheck.getLevelName(el, j);
                    names.add(thisname);
                    LMLCheck.addAllowedNames(errlist, names, el, thisname);
                    j += step;
                }
            } else if (el.getList() != null) {
                int[] numbers;
                int[] nArray = numbers = LMLCheck.getNumbersFromNumberlist(el.getList());
                int n = numbers.length;
                int n2 = 0;
                while (n2 < n) {
                    int number = nArray[n2];
                    String thisname = String.valueOf(aname) + LMLCheck.getLevelName(el, number);
                    names.add(thisname);
                    LMLCheck.addAllowedNames(errlist, names, el, thisname);
                    ++n2;
                }
            }
            ++i;
        }
    }

    public static void checkDataNodesinScheme(ErrorList errl, Object datanode, ArrayList<Integer> upperlevelnumbers, Object scheme) {
        if (datanode == null) {
            return;
        }
        List els = LMLCheck.getLowerDataElements(datanode);
        if (els == null) {
            return;
        }
        int i = 0;
        while (i < els.size()) {
            String levelstring;
            SchemeAndData asad;
            DataElement dat = (DataElement)els.get(i);
            if (dat.getMin() != null) {
                int min;
                int max = min = dat.getMin().intValue();
                if (dat.getMax() != null) {
                    max = dat.getMax().intValue();
                }
                upperlevelnumbers.add(min);
                SchemeAndData first = LMLCheck.getSchemeAndDataByLevels(min, datanode, scheme);
                if (first == null) {
                    String levelstring2 = LMLCheck.getLevelString(upperlevelnumbers);
                    errl.addError(String.valueOf(Messages.LMLCheck_4) + levelstring2 + Messages.LMLCheck_5);
                } else {
                    LMLCheck.checkDataNodesinScheme(errl, dat, upperlevelnumbers, first.scheme);
                    int step = first.scheme.getStep().intValue();
                    int j = min + step;
                    while (j <= max) {
                        upperlevelnumbers.set(upperlevelnumbers.size() - 1, j);
                        asad = LMLCheck.getSchemeAndDataByLevels(j, datanode, scheme);
                        if (asad == null) {
                            levelstring = LMLCheck.getLevelString(upperlevelnumbers);
                            errl.addError(String.valueOf(Messages.LMLCheck_6) + levelstring + Messages.LMLCheck_7);
                        } else {
                            LMLCheck.checkDataNodesinScheme(errl, dat, upperlevelnumbers, asad.scheme);
                        }
                        j += step;
                    }
                }
                upperlevelnumbers.remove(upperlevelnumbers.size() - 1);
            } else if (dat.getList() != null) {
                int[] elements;
                upperlevelnumbers.add(0);
                int[] nArray = elements = LMLCheck.getNumbersFromNumberlist(dat.getList());
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    int number = nArray[n2];
                    upperlevelnumbers.set(upperlevelnumbers.size() - 1, number);
                    asad = LMLCheck.getSchemeAndDataByLevels(number, datanode, scheme);
                    if (asad == null) {
                        levelstring = LMLCheck.getLevelString(upperlevelnumbers);
                        errl.addError(String.valueOf(Messages.LMLCheck_8) + levelstring + Messages.LMLCheck_9);
                    } else {
                        LMLCheck.checkDataNodesinScheme(errl, dat, upperlevelnumbers, asad.scheme);
                    }
                    ++n2;
                }
                upperlevelnumbers.remove(upperlevelnumbers.size() - 1);
            }
            ++i;
        }
    }

    public static void checkNamesAllowed(ErrorList errlist, HashSet<String> names, Object datarefelement) {
        List els = LMLCheck.getLowerDataElements(datarefelement);
        if (els == null) {
            return;
        }
        int i = 0;
        while (i < els.size()) {
            DataElement el = (DataElement)els.get(i);
            String refname = el.getRefid();
            if (refname != null && !names.contains(refname)) {
                errlist.addError(String.valueOf(Messages.LMLCheck_10) + refname + Messages.LMLCheck_11);
            }
            LMLCheck.checkNamesAllowed(errlist, names, el);
            ++i;
        }
    }

    public static ErrorList checkNodedisplays(LguiType lgui) {
        ErrorList res = new ErrorList();
        List<GobjectType> gobjects = LMLCheck.getGraphicalObjects(lgui);
        for (GobjectType gobj : gobjects) {
            if (!(gobj instanceof Nodedisplay)) continue;
            Nodedisplay dis = (Nodedisplay)gobj;
            res.addMessage(String.valueOf(Messages.LMLCheck_12) + dis.getId());
            LMLCheck.checkDataNodesinScheme(res, dis.getData(), new ArrayList<Integer>(), dis.getScheme());
        }
        return res;
    }

    public static ArrayList<Integer> copyArrayList(ArrayList<Integer> orig) {
        ArrayList<Integer> res = new ArrayList<Integer>();
        int i = 0;
        while (i < orig.size()) {
            res.add(orig.get(i));
            ++i;
        }
        return res;
    }

    public static int getDataLevel(Object el) {
        if (el instanceof DataType) {
            return 0;
        }
        if (el instanceof DataElement1) {
            return 1;
        }
        if (el instanceof DataElement2) {
            return 2;
        }
        if (el instanceof DataElement3) {
            return 3;
        }
        if (el instanceof DataElement4) {
            return 4;
        }
        if (el instanceof DataElement5) {
            return 5;
        }
        if (el instanceof DataElement6) {
            return 6;
        }
        if (el instanceof DataElement7) {
            return 7;
        }
        if (el instanceof DataElement8) {
            return 8;
        }
        if (el instanceof DataElement9) {
            return 9;
        }
        if (el instanceof DataElement) {
            return 10;
        }
        return -1;
    }

    public static int getDeepestSchemeLevel(Object schemeEl) {
        if (schemeEl == null) {
            return 0;
        }
        List els = LMLCheck.getLowerSchemeElements(schemeEl);
        if (els == null) {
            return 1;
        }
        int max = 0;
        int i = 0;
        while (i < els.size()) {
            int aheight = LMLCheck.getDeepestSchemeLevel(els.get(i));
            if (aheight > max) {
                max = aheight;
            }
            ++i;
        }
        return max + (schemeEl instanceof SchemeType ? 0 : 1);
    }

    public static List<GobjectType> getGraphicalObjects(LguiType pmodell) {
        List<JAXBElement<?>> all = pmodell.getObjectsAndRelationsAndInformation();
        ArrayList<GobjectType> gobj = new ArrayList<GobjectType>();
        for (JAXBElement<?> aobj : all) {
            if (!(aobj.getValue() instanceof GobjectType)) continue;
            gobj.add((GobjectType)aobj.getValue());
        }
        return gobj;
    }

    public static String getImplicitName(ArrayList<Integer> ids, Object scheme) {
        if (ids == null || ids.size() == 0) {
            return "";
        }
        ArrayList<Integer> id = new ArrayList<Integer>();
        id.add(ids.get(0));
        SchemeElement subscheme = LMLCheck.getSchemeByLevels(LMLCheck.copyArrayList(id), scheme);
        if (subscheme == null) {
            return "";
        }
        String subname = LMLCheck.getLevelName(subscheme, id.get(0));
        ids.remove(0);
        return String.valueOf(subname) + LMLCheck.getImplicitName(ids, subscheme);
    }

    public static List<LayoutType> getLayouts(LguiType pmodell) {
        List<JAXBElement<?>> all = pmodell.getObjectsAndRelationsAndInformation();
        ArrayList<LayoutType> layouts = new ArrayList<LayoutType>();
        for (JAXBElement<?> aobj : all) {
            if (!(aobj.getValue() instanceof LayoutType)) continue;
            layouts.add((LayoutType)aobj.getValue());
        }
        return layouts;
    }

    public static String getLevelName(SchemeElement scheme, int levelid) {
        if (scheme.getMap() == null) {
            return String.format(scheme.getMask(), levelid);
        }
        String[] names = scheme.getMap().split(",");
        if (scheme.getMin() != null) {
            int step;
            int namespos;
            int min = scheme.getMin().intValue();
            if (scheme.getMax() != null) {
                scheme.getMax().intValue();
            }
            if ((namespos = (levelid - min) / (step = scheme.getStep().intValue())) < names.length) {
                return names[namespos];
            }
        } else {
            int[] nrs = LMLCheck.getNumbersFromNumberlist(scheme.getList());
            int i = 0;
            while (i < nrs.length) {
                if (nrs[i] == levelid) {
                    return names[i];
                }
                ++i;
            }
        }
        return "";
    }

    public static String getLevelString(ArrayList<Integer> levels) {
        String levelstring = "";
        int j = 1;
        while (j <= levels.size()) {
            levelstring = String.valueOf(levelstring) + "el" + j + "=" + levels.get(j - 1) + " ";
            ++j;
        }
        return levelstring;
    }

    public static List getLowerDataElements(Object el) {
        if (el instanceof DataType) {
            return ((DataType)el).getEl1();
        }
        if (el instanceof DataElement1) {
            return ((DataElement1)el).getEl2();
        }
        if (el instanceof DataElement2) {
            return ((DataElement2)el).getEl3();
        }
        if (el instanceof DataElement3) {
            return ((DataElement3)el).getEl4();
        }
        if (el instanceof DataElement4) {
            return ((DataElement4)el).getEl5();
        }
        if (el instanceof DataElement5) {
            return ((DataElement5)el).getEl6();
        }
        if (el instanceof DataElement6) {
            return ((DataElement6)el).getEl7();
        }
        if (el instanceof DataElement7) {
            return ((DataElement7)el).getEl8();
        }
        if (el instanceof DataElement8) {
            return ((DataElement8)el).getEl9();
        }
        if (el instanceof DataElement9) {
            return ((DataElement9)el).getEl10();
        }
        return new ArrayList();
    }

    public static List getLowerNodedisplayElements(Object el) {
        if (el instanceof NodedisplaylayoutType) {
            ArrayList<Nodedisplayelement0> justonelement = new ArrayList<Nodedisplayelement0>();
            justonelement.add(((NodedisplaylayoutType)el).getEl0());
            return justonelement;
        }
        if (el instanceof Nodedisplayelement0) {
            return ((Nodedisplayelement0)el).getEl1();
        }
        if (el instanceof Nodedisplayelement1) {
            return ((Nodedisplayelement1)el).getEl2();
        }
        if (el instanceof Nodedisplayelement2) {
            return ((Nodedisplayelement2)el).getEl3();
        }
        if (el instanceof Nodedisplayelement3) {
            return ((Nodedisplayelement3)el).getEl4();
        }
        if (el instanceof Nodedisplayelement4) {
            return ((Nodedisplayelement4)el).getEl5();
        }
        if (el instanceof Nodedisplayelement5) {
            return ((Nodedisplayelement5)el).getEl6();
        }
        if (el instanceof Nodedisplayelement6) {
            return ((Nodedisplayelement6)el).getEl7();
        }
        if (el instanceof Nodedisplayelement7) {
            return ((Nodedisplayelement7)el).getEl8();
        }
        if (el instanceof Nodedisplayelement8) {
            return ((Nodedisplayelement8)el).getEl9();
        }
        if (el instanceof Nodedisplayelement9) {
            return ((Nodedisplayelement9)el).getEl10();
        }
        return new ArrayList();
    }

    public static List getLowerSchemeElements(Object el) {
        if (el instanceof SchemeType) {
            return ((SchemeType)el).getEl1();
        }
        if (el instanceof SchemeElement1) {
            return ((SchemeElement1)el).getEl2();
        }
        if (el instanceof SchemeElement2) {
            return ((SchemeElement2)el).getEl3();
        }
        if (el instanceof SchemeElement3) {
            return ((SchemeElement3)el).getEl4();
        }
        if (el instanceof SchemeElement4) {
            return ((SchemeElement4)el).getEl5();
        }
        if (el instanceof SchemeElement5) {
            return ((SchemeElement5)el).getEl6();
        }
        if (el instanceof SchemeElement6) {
            return ((SchemeElement6)el).getEl7();
        }
        if (el instanceof SchemeElement7) {
            return ((SchemeElement7)el).getEl8();
        }
        if (el instanceof SchemeElement8) {
            return ((SchemeElement8)el).getEl9();
        }
        if (el instanceof SchemeElement9) {
            return ((SchemeElement9)el).getEl10();
        }
        return new ArrayList();
    }

    public static Nodedisplayelement getNodedisplayElementByLevels(ArrayList<Integer> numbers, Nodedisplayelement nodeel) {
        if (numbers == null || numbers.size() == 0) {
            return null;
        }
        if (nodeel == null) {
            return null;
        }
        int anum = numbers.get(0);
        numbers.remove(0);
        List schemeEls = LMLCheck.getLowerNodedisplayElements(nodeel);
        Nodedisplayelement scheme = null;
        int i = 0;
        while (i < schemeEls.size()) {
            Nodedisplayelement ascheme = (Nodedisplayelement)schemeEls.get(i);
            if (ascheme.getMin() != null) {
                int amin;
                int amax = amin = ascheme.getMin().intValue();
                if (ascheme.getMax() != null) {
                    amax = ascheme.getMax().intValue();
                }
                if (anum >= amin && anum <= amax) {
                    scheme = ascheme;
                    break;
                }
            } else if (ascheme.getList() != null) {
                int[] listels;
                int[] nArray = listels = LMLCheck.getNumbersFromNumberlist(ascheme.getList());
                int n = listels.length;
                int n2 = 0;
                while (n2 < n) {
                    int number = nArray[n2];
                    if (number == anum) {
                        scheme = ascheme;
                        break;
                    }
                    ++n2;
                }
                if (scheme != null) break;
            }
            ++i;
        }
        if (scheme == null) {
            return null;
        }
        if (numbers.size() == 0) {
            return scheme;
        }
        Nodedisplayelement res = LMLCheck.getNodedisplayElementByLevels(numbers, scheme);
        return res;
    }

    public static int[] getNumbersFromNumberlist(String numberlist) {
        String[] parts = numberlist.split(",");
        int[] res = new int[parts.length];
        int i = 0;
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            res[i++] = Integer.parseInt(part.trim());
            ++n2;
        }
        return res;
    }

    public static List<ObjectsType> getObjects(LguiType model) {
        List<JAXBElement<?>> all = model.getObjectsAndRelationsAndInformation();
        ArrayList<ObjectsType> objects = new ArrayList<ObjectsType>();
        for (JAXBElement<?> aobj : all) {
            if (!(aobj.getValue() instanceof ObjectsType)) continue;
            objects.add((ObjectsType)aobj.getValue());
        }
        return objects;
    }

    public static SchemeAndData getSchemeAndDataByLevels(ArrayList<Integer> numbers, Object dataEl, Object schemeEl) {
        if (numbers == null || numbers.size() == 0) {
            return null;
        }
        if (schemeEl == null) {
            return null;
        }
        int anum = numbers.get(0);
        numbers.remove(0);
        List els = LMLCheck.getLowerDataElements(dataEl);
        List schemeEls = LMLCheck.getLowerSchemeElements(schemeEl);
        int i = 0;
        while (i < els.size()) {
            block23: {
                DataElement ael;
                block22: {
                    int[] listels;
                    block21: {
                        int min;
                        ael = (DataElement)els.get(i);
                        if (ael.getMin() == null) break block21;
                        int max = min = ael.getMin().intValue();
                        if (ael.getMax() != null) {
                            max = ael.getMax().intValue();
                        }
                        if (min <= anum && max >= anum) break block22;
                        break block23;
                    }
                    if (ael.getList() == null) break block22;
                    boolean found = false;
                    int[] nArray = listels = LMLCheck.getNumbersFromNumberlist(ael.getList());
                    int n = listels.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int number = nArray[n2];
                        if (number == anum) {
                            found = true;
                            break;
                        }
                        ++n2;
                    }
                    if (!found) break block23;
                }
                SchemeElement scheme = null;
                int j = 0;
                while (j < schemeEls.size()) {
                    SchemeElement ascheme = (SchemeElement)schemeEls.get(j);
                    if (ascheme.getMin() != null) {
                        int amin;
                        int amax = amin = ascheme.getMin().intValue();
                        if (ascheme.getMax() != null) {
                            amax = ascheme.getMax().intValue();
                        }
                        int astep = ascheme.getStep().intValue();
                        if (anum >= amin && anum <= amax && (anum - amin) % astep == 0) {
                            scheme = ascheme;
                            break;
                        }
                    } else if (ascheme.getList() != null) {
                        int[] listels;
                        int[] nArray = listels = LMLCheck.getNumbersFromNumberlist(ascheme.getList());
                        int n = listels.length;
                        int n3 = 0;
                        while (n3 < n) {
                            int number = nArray[n3];
                            if (number == anum) {
                                scheme = ascheme;
                                break;
                            }
                            ++n3;
                        }
                        if (scheme != null) break;
                    }
                    ++j;
                }
                if (scheme != null) {
                    if (numbers.size() == 0) {
                        return new SchemeAndData(ael, scheme);
                    }
                    SchemeAndData res = LMLCheck.getSchemeAndDataByLevels(numbers, (Object)ael, scheme);
                    if (res != null) {
                        return res;
                    }
                }
            }
            ++i;
        }
        if (dataEl instanceof DataType) {
            return null;
        }
        return new SchemeAndData((DataElement)dataEl, (SchemeElement)schemeEl);
    }

    public static SchemeAndData getSchemeAndDataByLevels(int number, Object dataEl, Object schemeEl) {
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        numbers.add(number);
        return LMLCheck.getSchemeAndDataByLevels(numbers, dataEl, schemeEl);
    }

    public static SchemeElement getSchemeByLevels(ArrayList<Integer> numbers, Object schemeEl) {
        if (numbers == null || numbers.size() == 0) {
            return null;
        }
        if (schemeEl == null) {
            return null;
        }
        int anum = numbers.get(0);
        numbers.remove(0);
        List schemeEls = LMLCheck.getLowerSchemeElements(schemeEl);
        SchemeElement scheme = null;
        int i = 0;
        while (i < schemeEls.size()) {
            SchemeElement ascheme = (SchemeElement)schemeEls.get(i);
            if (ascheme.getMin() != null) {
                int amin;
                int amax = amin = ascheme.getMin().intValue();
                if (ascheme.getMax() != null) {
                    amax = ascheme.getMax().intValue();
                }
                int astep = ascheme.getStep().intValue();
                if (anum >= amin && anum <= amax && (anum - amin) % astep == 0) {
                    scheme = ascheme;
                    break;
                }
            } else if (ascheme.getList() != null) {
                int[] listels;
                int[] nArray = listels = LMLCheck.getNumbersFromNumberlist(ascheme.getList());
                int n = listels.length;
                int n2 = 0;
                while (n2 < n) {
                    int number = nArray[n2];
                    if (number == anum) {
                        scheme = ascheme;
                        break;
                    }
                    ++n2;
                }
                if (scheme != null) break;
            }
            ++i;
        }
        if (scheme == null) {
            return null;
        }
        if (numbers.size() == 0) {
            return scheme;
        }
        SchemeElement res = LMLCheck.getSchemeByLevels(numbers, scheme);
        return res;
    }

    public static int getSchemeLevel(Object el) {
        if (el instanceof SchemeType) {
            return 0;
        }
        if (el instanceof SchemeElement1) {
            return 1;
        }
        if (el instanceof SchemeElement2) {
            return 2;
        }
        if (el instanceof SchemeElement3) {
            return 3;
        }
        if (el instanceof SchemeElement4) {
            return 4;
        }
        if (el instanceof SchemeElement5) {
            return 5;
        }
        if (el instanceof SchemeElement6) {
            return 6;
        }
        if (el instanceof SchemeElement7) {
            return 7;
        }
        if (el instanceof SchemeElement8) {
            return 8;
        }
        if (el instanceof SchemeElement9) {
            return 9;
        }
        if (el instanceof SchemeElement) {
            return 10;
        }
        return -1;
    }

    public static DataElement isSchemenodeInThisData(int number, Object dataEl) {
        List els = LMLCheck.getLowerDataElements(dataEl);
        if (els == null) {
            return null;
        }
        int i = 0;
        while (i < els.size()) {
            DataElement ael = (DataElement)els.get(i);
            if (ael.getMin() != null) {
                int min;
                int max = min = ael.getMin().intValue();
                if (ael.getMax() != null) {
                    max = ael.getMax().intValue();
                }
                if (number >= min && number <= max) {
                    return ael;
                }
            } else if (ael.getList() != null) {
                int[] listels;
                int[] nArray = listels = LMLCheck.getNumbersFromNumberlist(ael.getList());
                int n = listels.length;
                int n2 = 0;
                while (n2 < n) {
                    int anum = nArray[n2];
                    if (anum == number) {
                        return ael;
                    }
                    ++n2;
                }
            }
            ++i;
        }
        return null;
    }

    public static LguiType parseLML(URL xml, URL xsd) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((String)"lml");
        Unmarshaller unmar = jc.createUnmarshaller();
        if (xsd != null) {
            Schema mySchema;
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            try {
                mySchema = sf.newSchema(xsd);
            }
            catch (SAXException sAXException) {
                mySchema = null;
            }
            unmar.setSchema(mySchema);
        }
        JAXBElement doc = (JAXBElement)unmar.unmarshal(xml);
        LguiType lml = (LguiType)doc.getValue();
        return lml;
    }

    public static class SchemeAndData {
        public DataElement data;
        public SchemeElement scheme;

        public SchemeAndData(DataElement pdata, SchemeElement pscheme) {
            this.data = pdata;
            this.scheme = pscheme;
        }
    }
}

