/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.sync.core;

import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ptp.rdt.sync.core.BuildConfigurationManager;
import org.eclipse.ptp.rdt.sync.core.RDTSyncCorePlugin;
import org.eclipse.ptp.rdt.sync.core.SyncFlag;
import org.eclipse.ptp.rdt.sync.core.messages.Messages;
import org.eclipse.ptp.rdt.sync.core.resources.RemoteSyncNature;
import org.eclipse.ptp.rdt.sync.core.serviceproviders.ISyncServiceProvider;
import org.eclipse.ptp.services.core.IService;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.IServiceModelManager;
import org.eclipse.ptp.services.core.ServiceModelManager;

public class ResourceChangeListener {
    private static final IServiceModelManager fServiceModel = ServiceModelManager.getInstance();
    private static final IService fSyncService = fServiceModel.getService("org.eclipse.ptp.rdt.sync.core.SyncService");
    private static IResourceChangeListener resourceListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta[] iResourceDeltaArray = event.getDelta().getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta delta = iResourceDeltaArray[n2];
                IProject project = delta.getResource().getProject();
                if (project != null && RemoteSyncNature.hasNature(project)) {
                    BuildConfigurationManager bcm = BuildConfigurationManager.getInstance();
                    if (!bcm.isInitialized(project)) {
                        return;
                    }
                    IConfiguration buildConfig = ManagedBuildManager.getBuildInfo((IResource)project).getDefaultConfiguration();
                    IServiceConfiguration serviceConfig = bcm.getConfigurationForBuildConfiguration(buildConfig);
                    if (serviceConfig != null) {
                        ISyncServiceProvider provider = (ISyncServiceProvider)serviceConfig.getServiceProvider(fSyncService);
                        if (provider != null) {
                            SynchronizeJob job = new SynchronizeJob(event.getDelta(), provider);
                            job.schedule();
                        }
                    } else {
                        RDTSyncCorePlugin.log(Messages.RCL_NoServiceConfigError);
                    }
                }
                ++n2;
            }
        }
    };

    private ResourceChangeListener() {
    }

    public static void startListening() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(resourceListener, 1);
    }

    public static void stopListening() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(resourceListener);
    }

    private static class SynchronizeJob
    extends Job {
        private final ISyncServiceProvider fSyncProvider;
        private final IResourceDelta fDelta;

        public SynchronizeJob(IResourceDelta delta, ISyncServiceProvider provider) {
            super(Messages.ResourceChangeListener_jobName);
            this.fDelta = delta;
            this.fSyncProvider = provider;
        }

        protected IStatus run(IProgressMonitor monitor) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            try {
                try {
                    this.fSyncProvider.synchronize(this.fDelta, (IProgressMonitor)progress.newChild(100), SyncFlag.NO_FORCE);
                }
                catch (CoreException e) {
                    System.out.println("sync failed: " + e.getLocalizedMessage());
                    e.printStackTrace();
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
            return Status.OK_STATUS;
        }
    }
}

