/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.index.IndexCPPSignatureUtil;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMOverloader;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBinding;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPTemplateParameterMap;
import org.eclipse.core.runtime.CoreException;

abstract class PDOMCPPSpecialization
extends PDOMCPPBinding
implements ICPPSpecialization,
IPDOMOverloader {
    private static final int ARGMAP = 28;
    private static final int SIGNATURE_HASH = 32;
    private static final int SPECIALIZED = 36;
    protected static final int RECORD_SIZE = 40;
    private volatile IBinding fSpecializedCache = null;
    private volatile ICPPTemplateParameterMap fArgMap;

    public PDOMCPPSpecialization(PDOMLinkage linkage, PDOMNode parent, ICPPSpecialization spec, IPDOMBinding specialized) throws CoreException {
        super(linkage, parent, spec.getNameCharArray());
        this.getDB().putRecPtr(this.record + 36L, specialized.getRecord());
        if (this instanceof ICPPTemplateInstance) {
            long rec = PDOMCPPTemplateParameterMap.putMap(this, spec.getTemplateParameterMap());
            this.getDB().putRecPtr(this.record + 28L, rec);
        }
        try {
            Integer sigHash = IndexCPPSignatureUtil.getSignatureHash(spec);
            this.getDB().putInt(this.record + 32L, sigHash != null ? sigHash : 0);
        }
        catch (DOMException dOMException) {}
    }

    public PDOMCPPSpecialization(PDOMLinkage linkage, long bindingRecord) {
        super(linkage, bindingRecord);
    }

    public IBinding getSpecializedBinding() {
        if (this.fSpecializedCache == null) {
            try {
                long specializedRec = this.getDB().getRecPtr(this.record + 36L);
                this.fSpecializedCache = this.loadSpecializedBinding(specializedRec);
            }
            catch (CoreException e) {
                CCorePlugin.log((Throwable)e);
            }
        }
        return this.fSpecializedCache;
    }

    protected IPDOMBinding loadSpecializedBinding(long specializedRec) throws CoreException {
        return (IPDOMBinding)((Object)((PDOMLinkage)this.getLinkage()).getNode(specializedRec));
    }

    @Deprecated
    public ObjectMap getArgumentMap() {
        return CPPTemplates.getArgumentMap(this, this.getTemplateParameterMap());
    }

    public ICPPTemplateParameterMap getTemplateParameterMap() {
        if (this.fArgMap == null) {
            try {
                if (this instanceof ICPPTemplateInstance) {
                    this.fArgMap = PDOMCPPTemplateParameterMap.getMap(this, this.getDB().getRecPtr(this.record + 28L));
                } else {
                    IIndexBinding owner = this.getOwner();
                    if (owner instanceof ICPPSpecialization) {
                        this.fArgMap = ((ICPPSpecialization)((Object)owner)).getTemplateParameterMap();
                    }
                }
            }
            catch (CoreException e) {
                CCorePlugin.log((Throwable)e);
            }
        }
        return this.fArgMap;
    }

    public int getSignatureHash() throws CoreException {
        return this.getDB().getInt(this.record + 32L);
    }
}

