/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.ui.utils;

import org.eclipse.ptp.rm.ui.utils.DebugUtil;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

public abstract class DataSource {
    private ValidationException fFirstException = null;
    private boolean fCanSave = false;
    private boolean fCanAccept = false;
    protected static final String EMPTY_STRING = "";

    protected abstract void setErrorMessage(ValidationException var1);

    protected String extractText(Text text) {
        assert (text != null);
        String s = text.getText().trim();
        return s.length() == 0 ? null : s;
    }

    protected String extractText(Combo text) {
        assert (text != null);
        String s = text.getText().trim();
        return s.length() == 0 ? null : s;
    }

    protected void applyText(Text t, String s) {
        assert (t != null);
        if (s == null) {
            t.setText(EMPTY_STRING);
        } else {
            t.setText(s);
        }
    }

    protected void applyText(Combo t, String s) {
        assert (t != null);
        if (s == null) {
            t.setText(EMPTY_STRING);
        } else {
            t.setText(s);
        }
    }

    protected abstract void validateLocal() throws ValidationException;

    protected void validateGlobal() throws ValidationException {
    }

    protected abstract void copyToStorage();

    protected abstract void loadFromStorage();

    protected abstract void loadDefault();

    protected abstract void copyToFields();

    protected abstract void copyFromFields() throws ValidationException;

    protected abstract void update();

    protected void addException(ValidationException e) {
        DebugUtil.trace(DebugUtil.DATASOURCE_TRACING, "DataSource: Add Exception: {0}", e.getMessage());
        if (this.fFirstException == null) {
            this.fFirstException = e;
            this.fCanAccept = e.canAccept();
            this.fCanSave = e.canSave();
        } else {
            if (this.fCanSave && !e.canSave()) {
                this.fFirstException = e;
            }
            this.fCanAccept = this.fCanAccept && e.canAccept();
            this.fCanSave = this.fCanSave && e.canSave();
        }
    }

    protected void resetExceptions() {
        DebugUtil.trace(DebugUtil.DATASOURCE_TRACING, "DataSource: Reset exceptions");
        this.fFirstException = null;
        this.fCanAccept = true;
        this.fCanSave = true;
    }

    public boolean canAccept() {
        DebugUtil.trace(DebugUtil.DATASOURCE_TRACING, "DataSource: fCanAccept={0}", Boolean.toString(this.fCanAccept));
        return this.fCanAccept;
    }

    public boolean canSave() {
        DebugUtil.trace(DebugUtil.DATASOURCE_TRACING, "DataSource: fCanSave={0}", Boolean.toString(this.fCanSave));
        return this.fCanSave;
    }

    public boolean summarizeExceptions() {
        if (!this.fCanAccept || !this.fCanSave) {
            this.setErrorMessage(this.fFirstException);
            return false;
        }
        return true;
    }

    public String getErrorMessage() {
        if (this.fFirstException == null) {
            return null;
        }
        return this.fFirstException.getMessage();
    }

    public final boolean justValidate() {
        DebugUtil.trace(DebugUtil.DATASOURCE_TRACING, "DataSource: justValidate()");
        try {
            this.resetExceptions();
            this.copyFromFields();
            this.validateLocal();
        }
        catch (ValidationException e) {
            this.addException(e);
        }
        this.update();
        return this.summarizeExceptions();
    }

    public final void justUpdate() {
        DebugUtil.trace(DebugUtil.DATASOURCE_TRACING, "DataSource: justUpdate()");
        this.copyToFields();
        try {
            this.resetExceptions();
            this.validateLocal();
            this.validateGlobal();
            this.summarizeExceptions();
        }
        catch (ValidationException e) {
            this.addException(e);
            this.summarizeExceptions();
        }
        this.update();
    }

    public final boolean storeAndValidate() {
        DebugUtil.trace(DebugUtil.DATASOURCE_TRACING, "DataSource: storeAndValidate()");
        try {
            this.resetExceptions();
            this.copyFromFields();
            this.validateLocal();
            this.validateGlobal();
            this.copyToStorage();
        }
        catch (ValidationException e) {
            this.addException(e);
        }
        this.update();
        return this.summarizeExceptions();
    }

    public final void loadAndUpdate() {
        DebugUtil.trace(DebugUtil.DATASOURCE_TRACING, "DataSource: loadAndUpdate()");
        this.loadFromStorage();
        this.copyToFields();
        try {
            this.resetExceptions();
            this.validateLocal();
            this.validateGlobal();
            this.summarizeExceptions();
        }
        catch (ValidationException e) {
            this.addException(e);
            this.summarizeExceptions();
        }
        this.update();
    }

    public final void loadDefaultsAndUpdate() {
        DebugUtil.trace(DebugUtil.DATASOURCE_TRACING, "DataSource: loadDefaultsAndUpdate()");
        this.loadDefault();
        this.copyToFields();
        try {
            this.resetExceptions();
            this.validateLocal();
            this.validateGlobal();
            this.summarizeExceptions();
        }
        catch (ValidationException e) {
            this.addException(e);
            this.summarizeExceptions();
        }
        this.update();
    }

    public class ValidationException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private boolean canSave;
        private boolean canAccept;

        public ValidationException(String message) {
            super(message);
            this.canSave = false;
            this.canAccept = false;
            this.canSave = false;
            this.canAccept = false;
        }

        public ValidationException(String message, boolean canAccept, boolean canSave) {
            super(message);
            this.canSave = false;
            this.canAccept = false;
            this.canAccept = canAccept;
            this.canSave = canSave;
        }

        public boolean canAccept() {
            return this.canAccept;
        }

        public boolean canSave() {
            return this.canSave;
        }
    }
}

