/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.ui.wizards;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.TreeSet;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.ui.IRemoteUIConnectionManager;
import org.eclipse.ptp.remote.ui.PTPRemoteUIPlugin;
import org.eclipse.ptp.remote.ui.widgets.RemoteConnectionWidget;
import org.eclipse.ptp.rm.core.rmsystem.IRemoteResourceManagerConfiguration;
import org.eclipse.ptp.rm.ui.messages.Messages;
import org.eclipse.ptp.rm.ui.utils.DataSource;
import org.eclipse.ptp.rm.ui.wizards.AbstractConfigurationWizardPage;
import org.eclipse.ptp.rm.ui.wizards.WizardPageDataSource;
import org.eclipse.ptp.rm.ui.wizards.WizardPageWidgetListener;
import org.eclipse.ptp.ui.preferences.ScrolledPageContent;
import org.eclipse.ptp.ui.wizards.IRMConfigurationWizard;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public abstract class AbstractRemoteResourceManagerConfigurationWizardPage
extends AbstractConfigurationWizardPage {
    public static final String EMPTY_STRING = "";
    private final IRemoteUIConnectionManager fUIConnectionManager = null;
    private boolean fEnableUseDefault = false;
    private String fUseDefaultMessage;
    protected Button noneButton = null;
    protected Button portForwardingButton = null;
    protected Button useDefaultButton = null;
    protected WidgetListener listener = new WidgetListener();
    protected Combo localAddrCombo;
    protected RemoteConnectionWidget connectionWidget;
    protected ExpandableComposite advancedOptions;

    public AbstractRemoteResourceManagerConfigurationWizardPage(IRMConfigurationWizard wizard, String title) {
        super(wizard, title);
        this.setPageComplete(false);
    }

    public RMDataSource getDataSource() {
        return (RMDataSource)super.getDataSource();
    }

    public void updateControls() {
        boolean enabled = this.getWidgetListener().isEnabled();
        this.getWidgetListener().disable();
        boolean useDefault = this.getDataSource().getUseDefault();
        this.connectionWidget.setEnabled(!useDefault);
        this.advancedOptions.setExpanded(this.advancedOptions.isExpanded() & !useDefault);
        this.advancedOptions.setEnabled(!useDefault);
        if (!useDefault) {
            boolean portFwd = this.getDataSource().getPortForward();
            IRemoteConnection conn = this.getDataSource().getConnection();
            this.setPageComplete(conn != null);
            this.updatePortForwarding(conn, portFwd);
        } else {
            this.setPageComplete(true);
        }
        this.getWidgetListener().setEnabled(enabled);
    }

    protected WizardPageDataSource createDataSource() {
        return new RMDataSource(this);
    }

    protected GridLayout createGridLayout(int columns, boolean isEqual, int mh, int mw) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = columns;
        gridLayout.makeColumnsEqualWidth = isEqual;
        gridLayout.marginHeight = mh;
        gridLayout.marginWidth = mw;
        return gridLayout;
    }

    protected WizardPageWidgetListener createListener() {
        return new WidgetListener();
    }

    protected Button createRadioButton(Composite parent, String label, String value, SelectionListener listener) {
        Button button = this.createButton(parent, label, 16400);
        button.setData((Object)(value == null ? label : value));
        GridData data = new GridData(768);
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        button.setLayoutData((Object)data);
        if (listener != null) {
            button.addSelectionListener(listener);
        }
        return button;
    }

    protected Composite doCreateContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        Composite pageContent = this.createContents(composite);
        pageContent.setLayoutData((Object)new GridData(4, 4, true, true));
        return composite;
    }

    protected String getFieldContent(String text) {
        if (text.trim().length() == 0 || text.equals(EMPTY_STRING)) {
            return null;
        }
        return text;
    }

    protected ScrolledPageContent getParentScrolledComposite(Control control) {
        Composite parent = control.getParent();
        while (!(parent instanceof ScrolledPageContent) && parent != null) {
            parent = parent.getParent();
        }
        if (parent instanceof ScrolledPageContent) {
            return (ScrolledPageContent)parent;
        }
        return null;
    }

    protected IRemoteConnection getRemoteConnection(IRemoteServices services, String name) {
        IRemoteConnectionManager manager = this.getRemoteConnectionManager(services);
        if (manager != null) {
            return manager.getConnection(name);
        }
        return null;
    }

    protected IRemoteConnectionManager getRemoteConnectionManager(IRemoteServices services) {
        if (services != null) {
            return services.getConnectionManager();
        }
        return null;
    }

    protected IRemoteServices getRemoteServices(String id) {
        if (id != null && !id.equals(EMPTY_STRING)) {
            IWizardContainer container = null;
            if (this.getControl().isVisible()) {
                container = this.getWizard().getContainer();
            }
            return PTPRemoteUIPlugin.getDefault().getRemoteServices(id, (IRunnableContext)container);
        }
        return null;
    }

    protected IRemoteUIConnectionManager getRemoteUIConnectionManager() {
        return this.fUIConnectionManager;
    }

    protected void handleConnectionSelected() {
        IRemoteConnection conn = this.connectionWidget.getConnection();
        if (conn != null) {
            this.updatePortForwarding(conn, conn.supportsTCPPortForwarding());
        }
        this.getDataSource().storeAndValidate();
        this.updateControls();
    }

    protected void initializeLocalHostCombo() {
        boolean enabled = this.getWidgetListener().isEnabled();
        this.getWidgetListener().disable();
        TreeSet<String> addrs = new TreeSet<String>();
        try {
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            while (netInterfaces.hasMoreElements()) {
                NetworkInterface ni = netInterfaces.nextElement();
                Enumeration<InetAddress> alladdr = ni.getInetAddresses();
                while (alladdr.hasMoreElements()) {
                    InetAddress ip = alladdr.nextElement();
                    if (!(ip instanceof Inet4Address)) continue;
                    addrs.add(this.fixHostName(ip.getCanonicalHostName()));
                }
            }
        }
        catch (Exception exception) {}
        if (addrs.size() == 0) {
            addrs.add("localhost");
        }
        this.localAddrCombo.removeAll();
        int index = 0;
        int selection = -1;
        for (String addr : addrs) {
            this.localAddrCombo.add(addr);
            if (addr.equals(this.getDataSource().getLocalAddr())) {
                selection = index;
            }
            ++index;
        }
        if (selection < 0) {
            if (!this.getDataSource().getLocalAddr().equals(EMPTY_STRING)) {
                this.localAddrCombo.add(this.getDataSource().getLocalAddr());
            }
            selection = this.localAddrCombo.getItemCount() - 1;
        }
        this.localAddrCombo.select(selection);
        this.getWidgetListener().setEnabled(enabled);
    }

    protected void setEnableUseDefault(String message) {
        this.fEnableUseDefault = true;
        this.fUseDefaultMessage = message;
    }

    protected GridData spanGridData(int style, int space) {
        GridData gd = null;
        gd = style == -1 ? new GridData() : new GridData(style);
        gd.horizontalSpan = space;
        return gd;
    }

    private Composite createContents(Composite parent) {
        ScrolledPageContent pageContent = new ScrolledPageContent(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Composite composite = pageContent.getBody();
        composite.setLayout((Layout)layout);
        if (this.fEnableUseDefault) {
            this.useDefaultButton = new Button(composite, 32);
            this.useDefaultButton.setSelection(true);
            this.useDefaultButton.setText(this.fUseDefaultMessage);
            this.useDefaultButton.addSelectionListener((SelectionListener)this.getWidgetListener());
        }
        this.connectionWidget = new RemoteConnectionWidget(composite, 0, null, (IRunnableContext)this.getWizard().getContainer());
        GridData gd = new GridData(768);
        this.connectionWidget.setLayoutData((Object)gd);
        this.connectionWidget.addSelectionListener((SelectionListener)this.getWidgetListener());
        this.advancedOptions = new ExpandableComposite(composite, 0, 18);
        this.advancedOptions.setText(Messages.AbstractRemoteResourceManagerConfigurationWizardPage_AdvancedOptions);
        this.advancedOptions.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                ScrolledPageContent parent = AbstractRemoteResourceManagerConfigurationWizardPage.this.getParentScrolledComposite((Control)((ExpandableComposite)e.getSource()));
                if (parent != null) {
                    parent.reflow(true);
                }
            }
        });
        this.advancedOptions.setLayoutData((Object)this.spanGridData(768, 2));
        Group mxGroup = new Group((Composite)this.advancedOptions, 16);
        this.advancedOptions.setClient((Control)mxGroup);
        mxGroup.setLayout((Layout)this.createGridLayout(1, true, 10, 10));
        mxGroup.setLayoutData((Object)this.spanGridData(768, 2));
        mxGroup.setText(Messages.AbstractRemoteResourceManagerConfigurationWizardPage_3);
        this.noneButton = this.createRadioButton((Composite)mxGroup, Messages.AbstractRemoteResourceManagerConfigurationWizardPage_4, "mxGroup", this.listener);
        this.noneButton.addSelectionListener((SelectionListener)this.getWidgetListener());
        Composite addrComp = new Composite((Composite)mxGroup, 0);
        GridLayout addrLayout = new GridLayout();
        addrLayout.numColumns = 2;
        addrLayout.marginWidth = 0;
        addrLayout.marginLeft = 15;
        addrComp.setLayout((Layout)addrLayout);
        gd = new GridData(768);
        addrComp.setLayoutData((Object)gd);
        Label label = new Label(addrComp, 0);
        label.setText(Messages.AbstractRemoteResourceManagerConfigurationWizardPage_5);
        gd = new GridData();
        gd.horizontalSpan = 1;
        label.setLayoutData((Object)gd);
        this.localAddrCombo = new Combo(addrComp, 4);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.localAddrCombo.setLayoutData((Object)gd);
        this.localAddrCombo.addModifyListener((ModifyListener)this.getWidgetListener());
        this.localAddrCombo.addSelectionListener((SelectionListener)this.getWidgetListener());
        this.portForwardingButton = this.createRadioButton((Composite)mxGroup, Messages.AbstractRemoteResourceManagerConfigurationWizardPage_6, "mxGroup", this.listener);
        this.portForwardingButton.addSelectionListener((SelectionListener)this.getWidgetListener());
        this.getDataSource().justValidate();
        this.updateControls();
        return pageContent;
    }

    private String fixHostName(String hostname) {
        try {
            if (hostname.endsWith(".in-addr.arpa")) {
                return InetAddress.getLocalHost().getHostAddress();
            }
        }
        catch (UnknownHostException unknownHostException) {}
        return hostname;
    }

    private void updatePortForwarding(IRemoteConnection conn, boolean forward) {
        boolean supportsPortForwarding = false;
        if (conn != null) {
            supportsPortForwarding = conn.supportsTCPPortForwarding();
        }
        if (this.localAddrCombo != null) {
            this.localAddrCombo.setEnabled(!forward);
        }
        if (this.portForwardingButton != null) {
            this.portForwardingButton.setEnabled(supportsPortForwarding);
            this.portForwardingButton.setSelection(supportsPortForwarding ? forward : false);
        }
        if (this.noneButton != null) {
            this.noneButton.setSelection(supportsPortForwarding ? !forward : true);
        }
    }

    protected class RMDataSource
    extends WizardPageDataSource {
        private IRemoteConnection fConnection;
        private boolean fPortForward;
        private String fLocalAddr;
        private boolean fUseDefault;

        protected RMDataSource(AbstractConfigurationWizardPage page) {
            super(page);
            this.fConnection = null;
            this.fPortForward = true;
            this.fLocalAddr = null;
            this.fUseDefault = false;
        }

        public IRemoteResourceManagerConfiguration getConfiguration() {
            return (IRemoteResourceManagerConfiguration)super.getConfiguration();
        }

        public IRemoteConnection getConnection() {
            return this.fConnection;
        }

        public String getLocalAddr() {
            return this.fLocalAddr;
        }

        public boolean getPortForward() {
            return this.fPortForward;
        }

        public boolean getUseDefault() {
            return this.fUseDefault;
        }

        public void setConnection(IRemoteConnection conn) {
            this.fConnection = conn;
        }

        public void setLocalAddr(String addr) {
            this.fLocalAddr = addr;
        }

        public void setPortForward(boolean portFwd) {
            this.fPortForward = portFwd;
        }

        public void setUseDefault(boolean flag) {
            this.fUseDefault = flag;
        }

        protected void copyFromFields() throws DataSource.ValidationException {
            if (AbstractRemoteResourceManagerConfigurationWizardPage.this.connectionWidget != null) {
                this.fConnection = AbstractRemoteResourceManagerConfigurationWizardPage.this.connectionWidget.getConnection();
            }
            if (AbstractRemoteResourceManagerConfigurationWizardPage.this.localAddrCombo != null) {
                this.fLocalAddr = this.extractText(AbstractRemoteResourceManagerConfigurationWizardPage.this.localAddrCombo);
            }
            if (AbstractRemoteResourceManagerConfigurationWizardPage.this.portForwardingButton != null) {
                this.fPortForward = AbstractRemoteResourceManagerConfigurationWizardPage.this.portForwardingButton.getSelection();
            }
            if (AbstractRemoteResourceManagerConfigurationWizardPage.this.useDefaultButton != null) {
                this.fUseDefault = AbstractRemoteResourceManagerConfigurationWizardPage.this.useDefaultButton.getSelection();
            }
        }

        protected void copyToFields() {
            if (AbstractRemoteResourceManagerConfigurationWizardPage.this.localAddrCombo != null) {
                this.applyText(AbstractRemoteResourceManagerConfigurationWizardPage.this.localAddrCombo, this.fLocalAddr);
            }
            if (AbstractRemoteResourceManagerConfigurationWizardPage.this.useDefaultButton != null) {
                AbstractRemoteResourceManagerConfigurationWizardPage.this.useDefaultButton.setSelection(this.fUseDefault);
            }
            if (AbstractRemoteResourceManagerConfigurationWizardPage.this.connectionWidget != null) {
                AbstractRemoteResourceManagerConfigurationWizardPage.this.connectionWidget.setConnection(this.fConnection);
            }
            AbstractRemoteResourceManagerConfigurationWizardPage.this.updateControls();
        }

        protected void copyToStorage() {
            if (this.fConnection != null) {
                this.getConfiguration().setRemoteServicesId(this.fConnection.getRemoteServices().getId());
                this.getConfiguration().setConnectionName(this.fConnection.getName());
            }
            if (AbstractRemoteResourceManagerConfigurationWizardPage.this.localAddrCombo != null) {
                this.getConfiguration().setLocalAddress(this.fLocalAddr);
            }
            if (AbstractRemoteResourceManagerConfigurationWizardPage.this.portForwardingButton != null) {
                int options = this.getConfiguration().getOptions();
                options = this.fPortForward ? (options |= 2) : (options &= 0xFFFFFFFD);
                this.getConfiguration().setOptions(options);
            }
            if (AbstractRemoteResourceManagerConfigurationWizardPage.this.useDefaultButton != null) {
                this.getConfiguration().setUseDefault(this.fUseDefault);
            }
        }

        protected void loadDefault() {
        }

        protected void loadFromStorage() {
            String id = this.getConfiguration().getRemoteServicesId();
            if (id != null) {
                IRemoteServices services = AbstractRemoteResourceManagerConfigurationWizardPage.this.getRemoteServices(id);
                if (services != null) {
                    String name = this.getConfiguration().getConnectionName();
                    this.fConnection = AbstractRemoteResourceManagerConfigurationWizardPage.this.getRemoteConnection(services, name);
                }
            } else {
                this.fConnection = AbstractRemoteResourceManagerConfigurationWizardPage.this.connectionWidget.getConnection();
                this.copyToStorage();
            }
            this.fLocalAddr = this.getConfiguration().getLocalAddress();
            if (AbstractRemoteResourceManagerConfigurationWizardPage.this.localAddrCombo != null) {
                AbstractRemoteResourceManagerConfigurationWizardPage.this.initializeLocalHostCombo();
            }
            this.fPortForward = (this.getConfiguration().getOptions() & 2) == 2;
            this.fUseDefault = this.getConfiguration().getUseDefault();
        }

        protected void validateGlobal() throws DataSource.ValidationException {
        }

        protected void validateLocal() throws DataSource.ValidationException {
        }
    }

    protected class WidgetListener
    extends WizardPageWidgetListener {
        protected WidgetListener() {
        }

        protected void doModifyText(ModifyEvent evt) {
            Object source = evt.getSource();
            if (source == AbstractRemoteResourceManagerConfigurationWizardPage.this.localAddrCombo) {
                AbstractRemoteResourceManagerConfigurationWizardPage.this.resetErrorMessages();
                AbstractRemoteResourceManagerConfigurationWizardPage.this.getDataSource().storeAndValidate();
            } else assert (false);
        }

        protected void doWidgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == AbstractRemoteResourceManagerConfigurationWizardPage.this.connectionWidget) {
                AbstractRemoteResourceManagerConfigurationWizardPage.this.handleConnectionSelected();
            } else if (source == AbstractRemoteResourceManagerConfigurationWizardPage.this.noneButton || source == AbstractRemoteResourceManagerConfigurationWizardPage.this.portForwardingButton) {
                AbstractRemoteResourceManagerConfigurationWizardPage.this.resetErrorMessages();
                AbstractRemoteResourceManagerConfigurationWizardPage.this.getDataSource().storeAndValidate();
            } else if (source == AbstractRemoteResourceManagerConfigurationWizardPage.this.localAddrCombo) {
                AbstractRemoteResourceManagerConfigurationWizardPage.this.resetErrorMessages();
                AbstractRemoteResourceManagerConfigurationWizardPage.this.getDataSource().storeAndValidate();
            } else if (AbstractRemoteResourceManagerConfigurationWizardPage.this.useDefaultButton != null && source == AbstractRemoteResourceManagerConfigurationWizardPage.this.useDefaultButton) {
                AbstractRemoteResourceManagerConfigurationWizardPage.this.getDataSource().storeAndValidate();
                AbstractRemoteResourceManagerConfigurationWizardPage.this.updateControls();
            } else assert (false);
        }
    }
}

