/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control.ui.cell;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Spinner;

public class SpinnerCellEditor
extends CellEditor {
    private Spinner spinner;
    private static final int defaultStyle = 0;

    public SpinnerCellEditor() {
        this.setStyle(0);
    }

    public SpinnerCellEditor(Composite parent) {
        this(parent, 0);
    }

    public SpinnerCellEditor(Composite parent, int style) {
        this(parent, style, null, null);
    }

    public SpinnerCellEditor(Composite parent, int style, Integer min, Integer max) {
        super(parent, style);
        if (min != null && max == null) {
            max = Integer.MAX_VALUE;
        }
        if (max != null && min == null) {
            min = Integer.MIN_VALUE;
        }
        if (min != null && max != null) {
            this.spinner.setMinimum(min.intValue());
            this.spinner.setMaximum(max.intValue());
        }
    }

    public SpinnerCellEditor(Composite parent, Integer min, Integer max) {
        this(parent, 0, min, max);
    }

    public int getMin() {
        return this.spinner.getMinimum();
    }

    public Spinner getSpinner() {
        return this.spinner;
    }

    protected Control createControl(Composite parent) {
        this.spinner = new Spinner(parent, this.getStyle());
        return this.spinner;
    }

    protected Object doGetValue() {
        return this.spinner.getSelection();
    }

    protected void doSetFocus() {
        this.spinner.setFocus();
    }

    protected void doSetValue(Object value) {
        Assert.isTrue((boolean)(value instanceof Integer));
        this.spinner.setSelection(((Integer)value).intValue());
    }
}

