/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control.ui.model;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.RemoteServicesDelegate;
import org.eclipse.ptp.rm.jaxb.control.internal.variables.RMVariableMap;
import org.eclipse.ptp.rm.jaxb.control.ui.IUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.handlers.ValueUpdateHandler;
import org.eclipse.ptp.rm.jaxb.control.ui.launch.JAXBControllerLaunchConfigurationTab;
import org.eclipse.ptp.rm.jaxb.control.ui.utils.WidgetActionUtils;
import org.eclipse.ptp.rm.jaxb.control.ui.variables.LCVariableMap;
import org.eclipse.ptp.rm.jaxb.core.data.ValidatorType;
import org.eclipse.ui.progress.UIJob;

public abstract class AbstractUpdateModel
implements IUpdateModel {
    protected final Job validateJob;
    protected boolean canSave;
    protected String name;
    protected LCVariableMap lcMap;
    protected ValueUpdateHandler handler;
    protected boolean refreshing;
    protected ValidatorType validator;
    protected JAXBControllerLaunchConfigurationTab tab;
    protected String defaultValue;
    protected String[] booleanToString;
    protected Object mapValue;

    protected AbstractUpdateModel(String name, ValueUpdateHandler handler) {
        this.name = name;
        this.canSave = name != null && !"".equals(name);
        this.handler = handler;
        this.refreshing = false;
        this.validateJob = new ValidateJob();
    }

    public abstract Object getControl();

    public String getName() {
        return this.name;
    }

    public void initialize(RMVariableMap rmMap, LCVariableMap lcMap) {
        this.lcMap = lcMap;
        if (this.name != null) {
            this.defaultValue = lcMap.getDefault(this.name);
        }
        this.refreshValueFromMap();
        if (this.mapValue == null) {
            this.restoreDefault();
            this.refreshValueFromMap();
        }
    }

    public boolean isWritable() {
        return this.canSave;
    }

    public void restoreDefault() {
        this.lcMap.setDefault(this.name, this.defaultValue);
    }

    public void setValidator(ValidatorType validator, JAXBControllerLaunchConfigurationTab tab) {
        this.validator = validator;
        this.tab = tab;
    }

    public String validate() {
        if (this.validator != null) {
            try {
                WidgetActionUtils.validate(String.valueOf(this.getValueFromControl()), this.validator, this.getRemoteFileManager());
            }
            catch (Exception exception) {
                return this.validator.getErrorMessage();
            }
        }
        return null;
    }

    protected Object getBooleanValue(Boolean b) {
        if (this.booleanToString != null) {
            return b != false ? this.booleanToString[0] : this.booleanToString[1];
        }
        return b;
    }

    protected void handleUpdate(Object value) {
        this.handler.handleUpdate(this.getControl(), value);
    }

    protected boolean maybeGetBooleanFromString(Object mapValue) {
        boolean b = false;
        if (mapValue != null) {
            b = mapValue instanceof String ? (this.booleanToString != null ? mapValue.equals(this.booleanToString[0]) : Boolean.parseBoolean((String)mapValue)) : (Boolean)mapValue;
        }
        return b;
    }

    protected void setBooleanToString(String translateBooleanAs) {
        String[] pair;
        this.booleanToString = translateBooleanAs == null ? null : ((pair = translateBooleanAs.split(",")).length == 2 ? pair : null);
    }

    protected Object storeValue() {
        Object value = this.getValueFromControl();
        this.lcMap.put(this.name, value);
        return value;
    }

    private IRemoteFileManager getRemoteFileManager() {
        RemoteServicesDelegate d;
        if (this.tab != null && (d = this.tab.getDelegate()) != null) {
            return d.getRemoteFileManager();
        }
        return null;
    }

    protected class ValidateJob
    extends UIJob {
        public ValidateJob() {
            super("ValidateJob");
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            Object value = AbstractUpdateModel.this.storeValue();
            AbstractUpdateModel.this.handleUpdate(value);
            return Status.OK_STATUS;
        }
    }
}

