/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control.ui.model;

import java.util.List;
import org.eclipse.ptp.rm.jaxb.control.ui.handlers.ValueUpdateHandler;
import org.eclipse.ptp.rm.jaxb.control.ui.model.AbstractUpdateModel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ButtonGroupUpdateModel
extends AbstractUpdateModel
implements SelectionListener {
    private String selectedLabel;
    private final List<Button> buttons;
    private final Composite control;
    private Button lastSelected;

    public ButtonGroupUpdateModel(String name, ValueUpdateHandler handler, Composite control, List<Button> buttons) {
        super(name, handler);
        this.control = control;
        this.buttons = buttons;
        for (Button b : buttons) {
            b.addSelectionListener((SelectionListener)this);
        }
        this.lastSelected = null;
        this.selectedLabel = "";
    }

    @Override
    public Object getControl() {
        return this.control;
    }

    @Override
    public Object getValueFromControl() {
        return this.selectedLabel;
    }

    @Override
    public void refreshValueFromMap() {
        this.refreshing = true;
        this.mapValue = this.lcMap.get(this.name);
        this.selectedLabel = this.mapValue != null && !"".equals(this.mapValue) ? String.valueOf(this.mapValue) : "";
        for (Button b : this.buttons) {
            if (b.getText().equals(this.selectedLabel)) {
                b.setSelection(true);
                continue;
            }
            b.setSelection(false);
        }
        this.refreshing = false;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.refreshing) {
            return;
        }
        this.selectedLabel = "";
        Button selected = (Button)e.getSource();
        if (selected.getSelection()) {
            this.selectedLabel = selected.getText();
            if (this.lastSelected != null && this.lastSelected != selected) {
                this.lastSelected.setSelection(false);
            } else {
                for (Button b : this.buttons) {
                    if (b == selected) continue;
                    b.setSelection(false);
                }
            }
        }
        this.lastSelected = selected;
        Object value = this.storeValue();
        this.handleUpdate(value);
    }
}

