/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control.ui.variables;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.ptp.rm.jaxb.control.internal.variables.RMVariableMap;
import org.eclipse.ptp.rm.jaxb.control.ui.messages.Messages;
import org.eclipse.ptp.rm.jaxb.control.ui.variables.LCVariableResolver;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.ptp.rm.jaxb.core.JAXBCorePlugin;
import org.eclipse.ptp.rm.jaxb.core.data.AttributeType;
import org.eclipse.ptp.rm.jaxb.core.data.PropertyType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LCVariableMap
implements IVariableMap {
    private static final Object monitor = new Object();
    private final Map<String, Object> linkedTo;
    private final Map<String, Object> excluded;
    private final Map<String, Object> values = Collections.synchronizedMap(new TreeMap());
    private final Map<String, String> defaultValues;
    private final Map<String, Object> temp;
    private final Set<String> hidden;
    private String rmPrefix;

    public LCVariableMap() {
        this.excluded = Collections.synchronizedMap(new TreeMap());
        this.defaultValues = Collections.synchronizedMap(new TreeMap());
        this.linkedTo = Collections.synchronizedMap(new TreeMap());
        this.temp = Collections.synchronizedMap(new TreeMap());
        this.hidden = new HashSet<String>();
    }

    public void clear() {
        this.values.clear();
        this.defaultValues.clear();
        this.linkedTo.clear();
        this.temp.clear();
        this.excluded.clear();
        this.hidden.clear();
    }

    public void flush(ILaunchConfigurationWorkingCopy configuration) throws CoreException {
        for (String name : this.values.keySet()) {
            Object value = this.values.get(name);
            if (value instanceof Boolean) {
                configuration.setAttribute(name, ((Boolean)value).booleanValue());
                continue;
            }
            if (value instanceof Integer) {
                configuration.setAttribute(name, ((Integer)value).intValue());
                continue;
            }
            if (value instanceof List) {
                configuration.setAttribute(name, (List)value);
                continue;
            }
            if (value instanceof Set) {
                configuration.setAttribute(name, (Set)value);
                continue;
            }
            if (value instanceof Map) {
                configuration.setAttribute(name, (Map)value);
                continue;
            }
            configuration.setAttribute(name, (String)value);
        }
    }

    public Set<String> forControlState(String name, String statePrefix) {
        TreeSet<String> set = new TreeSet<String>();
        String state = (String)this.get(String.valueOf(statePrefix) + name);
        if (state != null) {
            String[] split;
            String[] stringArray = split = state.split(" ");
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                set.add(s);
                ++n2;
            }
        }
        return set;
    }

    public Object get(String name) {
        if (name == null) {
            return null;
        }
        return this.values.get(String.valueOf(this.rmPrefix) + name);
    }

    public Set<String> getChecked(String viewerName) {
        return this.forControlState(viewerName, "checked_attributes_");
    }

    public String getDefault(String name) {
        if (name == null) {
            return null;
        }
        return this.defaultValues.get(name);
    }

    public Map<String, Object> getDiscovered() {
        return null;
    }

    public Map<String, Object> getExcluded() {
        return this.excluded;
    }

    public Set<String> getHidden() {
        return this.hidden;
    }

    public String getString(String value) {
        try {
            value = value.replaceAll("ptp_rm:", "ptp_lc:");
            return this.dereference(value);
        }
        catch (CoreException t) {
            JAXBCorePlugin.log((Throwable)t);
            return value;
        }
    }

    public String getString(String jobId, String value) {
        return this.getString(value);
    }

    public Map<String, Object> getVariables() {
        return null;
    }

    public void initialize(IVariableMap rmVars, String rmId) throws Throwable {
        this.clear();
        this.rmPrefix = String.valueOf(rmId) + ".";
        for (String s : rmVars.getVariables().keySet()) {
            this.loadValues(s, rmVars.getVariables().get(s), false);
        }
        for (String s : rmVars.getDiscovered().keySet()) {
            this.loadValues(s, rmVars.getDiscovered().get(s), true);
        }
    }

    public void put(String name, Object value) {
        if (name == null || "".equals(name)) {
            return;
        }
        if (value != null) {
            this.values.put(String.valueOf(this.rmPrefix) + name, value);
        }
    }

    public void relinkConfigurationProperties(ILaunchConfiguration configuration) throws CoreException {
        Iterator<String> key = this.values.keySet().iterator();
        while (key.hasNext()) {
            String name = key.next();
            if (name.startsWith(this.rmPrefix)) continue;
            key.remove();
        }
        Map attributes = configuration.getAttributes();
        for (Object o : attributes.keySet()) {
            String key2 = (String)o;
            if (!RMVariableMap.isExternal((String)key2)) continue;
            this.values.put(key2, attributes.get(key2));
        }
        String cdir = (String)this.get("control.working.dir");
        String dir = (String)this.get("directory");
        if (dir == null || "".equals(dir)) {
            dir = cdir == null ? "" : cdir;
        }
        this.put("directory", configuration.getAttribute("org.eclipse.ptp.launch.WORKING_DIR_ATTR", dir));
        this.put("executablePath", configuration.getAttribute("org.eclipse.ptp.launch.ATTR_REMOTE_EXECUTABLE_PATH", ""));
        this.put("progArgs", configuration.getAttribute("org.eclipse.ptp.launch.ARGUMENT_ATTR", ""));
    }

    public void relinkHidden(String controller) {
        Set<String> valid = this.forControlState(controller, "valid_");
        for (String name : this.linkedTo.keySet()) {
            Object value = null;
            Object o = this.linkedTo.get(name);
            String link = null;
            if (o instanceof PropertyType) {
                PropertyType p = (PropertyType)o;
                link = p.getLinkValueTo();
            } else if (o instanceof AttributeType) {
                AttributeType a = (AttributeType)o;
                link = a.getLinkValueTo();
            }
            if (link != null && (valid.contains(link) || RMVariableMap.isExternal((String)link) || RMVariableMap.isFixedValid((String)link))) {
                value = this.get(link);
            }
            if (value == null || "".equals(value)) {
                value = this.defaultValues.get(name);
            }
            if (value == null) {
                value = "";
            }
            this.put(name, value);
        }
    }

    public Object remove(String name) {
        return null;
    }

    public void restoreGlobal() {
        this.values.clear();
        this.values.putAll(this.temp);
        this.temp.clear();
    }

    public void setDefault(String name, String defaultv) {
        if (defaultv == null) {
            this.values.remove(String.valueOf(this.rmPrefix) + name);
        } else {
            this.put(name, defaultv);
        }
    }

    public void setInitialized(boolean initialized) {
    }

    public void shiftToCurrent(String controller) {
        Set<String> valid = this.forControlState(controller, "valid_");
        this.temp.putAll(this.values);
        this.values.clear();
        for (String var : this.temp.keySet()) {
            Object value = this.temp.get(var);
            if ("".equals(value) || var == null) continue;
            if (var.startsWith(this.rmPrefix)) {
                if (!valid.contains(var = var.substring(this.rmPrefix.length())) && !RMVariableMap.isFixedValid((String)var)) continue;
                this.put(var, value);
                continue;
            }
            if (!RMVariableMap.isExternal((String)var)) continue;
            this.values.put(var, value);
        }
    }

    public void updateFromConfiguration(ILaunchConfiguration configuration) throws CoreException {
        Map attr = configuration.getAttributes();
        for (String key : attr.keySet()) {
            if (!key.startsWith(this.rmPrefix) && !RMVariableMap.isExternal((String)key)) continue;
            this.values.put(key, attr.get(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String dereference(String expression) throws CoreException {
        if (expression == null) {
            return null;
        }
        Object object = monitor;
        synchronized (object) {
            LCVariableResolver.setActive(this);
            return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(expression);
        }
    }

    private void loadValues(String key, Object value, boolean discovered) throws Throwable {
        String name = null;
        String defVal = null;
        boolean linked = false;
        boolean visible = true;
        Object o = null;
        if (value instanceof PropertyType) {
            PropertyType p = (PropertyType)value;
            name = p.getName();
            if (name == null) {
                return;
            }
            defVal = p.getDefault();
            visible = p.isVisible();
            if (!visible) {
                this.hidden.add(name);
                if (p.getLinkValueTo() != null) {
                    linked = true;
                    this.linkedTo.put(name, p);
                } else {
                    o = p.getValue();
                }
            } else {
                o = p.getValue();
            }
        } else if (value instanceof AttributeType) {
            AttributeType ja = (AttributeType)value;
            name = ja.getName();
            if (name == null) {
                return;
            }
            defVal = ja.getDefault();
            visible = ja.isVisible();
            if (!visible) {
                this.hidden.add(name);
                if (ja.getLinkValueTo() != null) {
                    linked = true;
                    this.linkedTo.put(name, ja);
                } else {
                    o = ja.getValue();
                }
            } else {
                o = ja.getValue();
            }
        } else {
            throw new ArrayStoreException(String.valueOf(Messages.IllegalVariableValueType) + value);
        }
        if (!discovered) {
            this.defaultValues.put(name, defVal);
            if (!linked) {
                if (o == null) {
                    this.setDefault(name, defVal);
                } else {
                    this.put(name, o);
                }
            }
        } else if (!visible) {
            this.hidden.add(name);
            this.excluded.put(name, o);
        } else {
            this.put(name, o);
        }
    }
}

