/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.ui.wizards;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.internal.core.envvar.EnvironmentVariableManager;
import org.eclipse.cdt.internal.ui.wizards.ICDTCommonProjectWizard;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.ui.wizards.MBSCustomPageManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ptp.rdt.sync.core.BuildConfigurationManager;
import org.eclipse.ptp.rdt.sync.core.BuildScenario;
import org.eclipse.ptp.rdt.sync.core.serviceproviders.ISyncServiceProvider;
import org.eclipse.ptp.rdt.sync.core.serviceproviders.SyncBuildServiceProvider;
import org.eclipse.ptp.rdt.sync.ui.ISynchronizeParticipant;
import org.eclipse.ptp.rdt.sync.ui.RDTSyncUIPlugin;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.services.core.IService;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.ptp.services.core.IServiceProviderDescriptor;
import org.eclipse.ptp.services.core.ServiceModelManager;
import org.eclipse.ui.statushandlers.StatusManager;

public class RemoteSyncWizardPageOperation
implements IRunnableWithProgress {
    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        IConfiguration[] allConfigs;
        monitor.beginTask("configure model services", 100);
        IWizard wizard = MBSCustomPageManager.getPageData((String)"org.eclipse.ptp.rdt.sync.ui.remoteSyncWizardPage").getWizardPage().getWizard();
        IProject project = ((ICDTCommonProjectWizard)wizard).getLastProject();
        ISynchronizeParticipant participant = (ISynchronizeParticipant)RemoteSyncWizardPageOperation.getMBSProperty("org.eclipse.ptp.rdt.sync.ui.remoteSyncWizardPage.serviceProvider");
        if (participant == null) {
            monitor.done();
            return;
        }
        ServiceModelManager smm = ServiceModelManager.getInstance();
        IServiceConfiguration serviceConfig = smm.newServiceConfiguration(this.getConfigName(project.getName()));
        IService syncService = smm.getService("org.eclipse.ptp.rdt.sync.core.SyncService");
        serviceConfig.setServiceProvider(syncService, (IServiceProvider)participant.getProvider(project));
        IService buildService = smm.getService("org.eclipse.ptp.rdt.core.BuildService");
        IServiceProviderDescriptor descriptor = buildService.getProviderDescriptor("org.eclipse.ptp.rdt.sync.BuildServiceProvider");
        SyncBuildServiceProvider rbsp = (SyncBuildServiceProvider)smm.getServiceProvider(descriptor);
        if (rbsp != null) {
            IRemoteConnection remoteConnection = participant.getProvider(project).getRemoteConnection();
            rbsp.setRemoteToolsConnection(remoteConnection);
            serviceConfig.setServiceProvider(buildService, (IServiceProvider)rbsp);
        }
        smm.addConfiguration(project, serviceConfig);
        try {
            smm.saveModelConfiguration();
        }
        catch (IOException e) {
            RDTSyncUIPlugin.log(e.toString(), e);
        }
        ISyncServiceProvider provider = participant.getProvider(project);
        BuildScenario buildScenario = new BuildScenario(provider.getName(), provider.getRemoteConnection(), provider.getLocation());
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        if (buildInfo == null) {
            throw new RuntimeException("Build information for project not found. Project name: " + project.getName());
        }
        IConfiguration[] iConfigurationArray = allConfigs = buildInfo.getManagedProject().getConfigurations();
        int n = allConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration config = iConfigurationArray[n2];
            IBuilder syncBuilder = ManagedBuildManager.getExtensionBuilder((String)"org.eclipse.ptp.rdt.sync.core.SyncBuilder");
            config.changeBuilder(syncBuilder, "org.eclipse.ptp.rdt.sync.core.SyncBuilder", "Sync Builder");
            ICConfigurationDescription c_mb_confgDes = ManagedBuildManager.getDescriptionForConfiguration((IConfiguration)config);
            if (c_mb_confgDes != null) {
                EnvironmentVariableManager.fUserSupplier.setAppendContributedEnvironment(false, (Object)c_mb_confgDes);
            }
            ++n2;
        }
        ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
        BuildConfigurationManager.getInstance().initProject(project, serviceConfig, buildScenario);
        try {
            BuildConfigurationManager.getInstance().saveConfigurationData();
        }
        catch (IOException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.ptp.rdt.sync.ui", e.getMessage(), (Throwable)e), 2);
        }
        monitor.done();
    }

    private static Object getMBSProperty(String propertyId) {
        return MBSCustomPageManager.getPageProperty((String)"org.eclipse.ptp.rdt.sync.ui.remoteSyncWizardPage", (String)propertyId);
    }

    private String getConfigName(String candidateName) {
        Set configs = ServiceModelManager.getInstance().getConfigurations();
        HashSet<String> existingNames = new HashSet<String>();
        for (IServiceConfiguration config : configs) {
            existingNames.add(config.getName());
        }
        int i = 2;
        String newConfigName = candidateName;
        while (existingNames.contains(newConfigName)) {
            newConfigName = String.valueOf(candidateName) + " (" + i++ + ")";
        }
        return newConfigName;
    }
}

