/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.ptp.debug.core.IPSession;
import org.eclipse.ptp.debug.core.IPSignalManager;
import org.eclipse.ptp.debug.core.PDebugModel;
import org.eclipse.ptp.debug.core.TaskSet;
import org.eclipse.ptp.debug.core.model.IPSignal;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.event.IPDIEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDIEventListener;
import org.eclipse.ptp.debug.core.pdi.model.IPDISignal;
import org.eclipse.ptp.debug.internal.core.model.PSignal;

public class PSignalManager
implements IAdaptable,
IPDIEventListener,
IPSignalManager {
    private final IPSession session;
    protected final Map<TaskSet, PSignalSet> fPSignalSetMap = new HashMap<TaskSet, PSignalSet>();

    public PSignalManager(IPSession session) {
        this.session = session;
    }

    public void dispose(TaskSet qTasks) {
        this.getSignalSet(qTasks).dispose();
    }

    public void dispose(IProgressMonitor monitor) {
        DebugPlugin.getDefault().asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Map<TaskSet, PSignalSet> map = PSignalManager.this.fPSignalSetMap;
                synchronized (map) {
                    Iterator<PSignalSet> it = PSignalManager.this.fPSignalSetMap.values().iterator();
                    while (it.hasNext()) {
                        it.next().dispose();
                    }
                    PSignalManager.this.fPSignalSetMap.clear();
                }
            }
        });
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IPDISession.class)) {
            return this.getSession();
        }
        if (adapter.equals(PSignalManager.class)) {
            return this;
        }
        return null;
    }

    public IPSignal[] getSignals(TaskSet qTasks) throws DebugException {
        return this.getSignalSet(qTasks).getSignals();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PSignalSet getSignalSet(TaskSet qTasks) {
        Map<TaskSet, PSignalSet> map = this.fPSignalSetMap;
        synchronized (map) {
            PSignalSet set = this.fPSignalSetMap.get(qTasks);
            if (set == null) {
                set = new PSignalSet(qTasks);
                this.fPSignalSetMap.put(qTasks, set);
            }
            return set;
        }
    }

    public void handleDebugEvents(IPDIEvent[] events) {
    }

    public void signalChanged(TaskSet qTasks, IPDISignal pdiSignal) {
        this.getSignalSet(qTasks).signalChanged(pdiSignal);
    }

    protected IPSession getSession() {
        return this.session;
    }

    protected void throwDebugException(String message, int code, Throwable exception) throws DebugException {
        throw new DebugException((IStatus)new Status(4, PDebugModel.getPluginIdentifier(), code, message, exception));
    }

    private class PSignalSet {
        private final TaskSet sTasks;
        private IPSignal[] fSignals = null;
        private boolean fIsDisposed = false;

        public PSignalSet(TaskSet sTasks) {
            this.sTasks = sTasks;
        }

        public synchronized void dispose() {
            if (this.fSignals != null) {
                int i = 0;
                while (i < this.fSignals.length) {
                    ((PSignal)this.fSignals[i]).dispose();
                    ++i;
                }
            }
            this.fSignals = null;
            this.fIsDisposed = true;
        }

        public PSignal find(IPDISignal pdiSignal) {
            try {
                IPSignal[] signals = this.getSignals();
                int i = 0;
                while (i < signals.length) {
                    if (signals[i].getName().equals(pdiSignal.getName())) {
                        return (PSignal)signals[i];
                    }
                    ++i;
                }
            }
            catch (DebugException debugException) {}
            return null;
        }

        public synchronized IPSignal[] getSignals() throws DebugException {
            if (!this.fIsDisposed && this.fSignals == null) {
                try {
                    IPDISignal[] pdiSignals = PSignalManager.this.session.getPDISession().getSignalManager().getSignals(this.sTasks);
                    ArrayList<PSignal> list = new ArrayList<PSignal>(pdiSignals.length);
                    int i = 0;
                    while (i < pdiSignals.length) {
                        list.add(new PSignal(PSignalManager.this.session, this.sTasks, pdiSignals[i]));
                        ++i;
                    }
                    this.fSignals = list.toArray(new IPSignal[list.size()]);
                }
                catch (PDIException e) {
                    PSignalManager.this.throwDebugException(e.getMessage(), 5010, e);
                }
            }
            return this.fSignals != null ? this.fSignals : new IPSignal[]{};
        }

        public void signalChanged(IPDISignal pdiSignal) {
            PSignal signal = this.find(pdiSignal);
            if (signal != null) {
                signal.fireChangeEvent(256);
            }
        }
    }
}

