/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control.internal.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ptp.core.util.CoreExceptionUtils;
import org.eclipse.ptp.rm.jaxb.control.internal.IAssign;
import org.eclipse.ptp.rm.jaxb.control.internal.IMatchable;
import org.eclipse.ptp.rm.jaxb.control.internal.data.MatchImpl;
import org.eclipse.ptp.rm.jaxb.control.internal.data.TestImpl;
import org.eclipse.ptp.rm.jaxb.control.internal.messages.Messages;
import org.eclipse.ptp.rm.jaxb.control.internal.utils.TokenizerLogger;
import org.eclipse.ptp.rm.jaxb.control.internal.variables.RMVariableMap;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.ptp.rm.jaxb.core.data.AttributeType;
import org.eclipse.ptp.rm.jaxb.core.data.MatchType;
import org.eclipse.ptp.rm.jaxb.core.data.PropertyType;
import org.eclipse.ptp.rm.jaxb.core.data.TargetType;
import org.eclipse.ptp.rm.jaxb.core.data.TestType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetImpl
implements IMatchable {
    private final IVariableMap rmVarMap;
    private final String uuid;
    private final String ref;
    private final String type;
    private final List<MatchImpl> matches;
    private final List<TestImpl> tests;
    private final List<Object> targets;
    private final boolean matchAll;
    private final boolean allowOverwrites;
    private Object refTarget;
    private boolean selected;

    public TargetImpl(String uuid, TargetType target, IVariableMap rmVarMap) {
        this.rmVarMap = rmVarMap;
        this.uuid = uuid;
        this.ref = target.getRef();
        this.type = target.getType();
        this.matchAll = target.isMatchAll();
        this.allowOverwrites = target.isAllowOverwrites();
        this.matches = new ArrayList<MatchImpl>();
        List mdata = target.getMatch();
        for (MatchType m : mdata) {
            this.matches.add(new MatchImpl(uuid, m, this, rmVarMap));
        }
        this.tests = new ArrayList<TestImpl>();
        List tdata = target.getTest();
        for (TestType t : tdata) {
            this.tests.add(new TestImpl(uuid, t, rmVarMap));
        }
        this.targets = new ArrayList<Object>();
        this.selected = false;
    }

    @Override
    public synchronized boolean doMatch(StringBuffer segment) throws Throwable {
        int matched = 0;
        boolean match = false;
        for (MatchImpl m : this.matches) {
            if (this.matchAll && m.getMatched()) {
                ++matched;
                continue;
            }
            int tail = m.doMatch(segment.toString());
            match = m.getMatched();
            if (!match) continue;
            segment.delete(0, tail);
            ++matched;
            this.selected = m.getMoveToTop();
            break;
        }
        if (!this.matchAll || matched == this.matches.size()) {
            for (MatchImpl m : this.matches) {
                m.reset();
            }
        }
        return match;
    }

    public Object getTarget(IAssign assign) throws CoreException {
        if (this.refTarget != null) {
            return this.refTarget;
        }
        Object target = null;
        if (this.ref != null) {
            String name = this.rmVarMap.getString(this.uuid, this.ref);
            target = this.rmVarMap.get(name);
            if (target == null) {
                throw CoreExceptionUtils.newException((String)(String.valueOf(Messages.StreamParserNoSuchVariableError) + name), null);
            }
            this.refTarget = target;
        } else {
            int i = assign.getIndex();
            if (i < this.targets.size()) {
                target = this.targets.get(i);
            }
            if (target == null) {
                if ("property".equals(this.type)) {
                    PropertyType p = new PropertyType();
                    target = p;
                    this.targets.add(target);
                } else if ("attribute".equals(this.type)) {
                    AttributeType ja = new AttributeType();
                    target = ja;
                    this.targets.add(target);
                } else {
                    throw CoreExceptionUtils.newException((String)(String.valueOf(Messages.StreamParserMissingTargetType) + this.ref), null);
                }
            }
        }
        return target;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public synchronized void postProcess() throws Throwable {
        if (this.refTarget == null) {
            if ("property".equals(this.type)) {
                TokenizerLogger.getLogger().logPropertyInfo(String.valueOf(Messages.TargetImpl_0) + this.targets.size() + Messages.TargetImpl_1);
                this.mergeProperties(this.targets);
            } else if ("attribute".equals(this.type)) {
                TokenizerLogger.getLogger().logPropertyInfo(String.valueOf(Messages.TargetImpl_2) + this.targets.size() + Messages.TargetImpl_3);
                this.mergeAttributes(this.targets);
            }
            if (this.rmVarMap instanceof RMVariableMap) {
                Map<String, Object> dmap = ((RMVariableMap)this.rmVarMap).getDiscovered();
                for (Object t : this.targets) {
                    for (TestImpl test : this.tests) {
                        test.setTarget(t);
                        test.doTest();
                    }
                    if ("property".equals(this.type)) {
                        PropertyType p = (PropertyType)t;
                        TokenizerLogger.getLogger().logPropertyInfo(String.valueOf(Messages.TargetImpl_4) + p.getName() + "," + " " + p.getValue());
                        dmap.put(p.getName(), p);
                        continue;
                    }
                    if (!"attribute".equals(this.type)) continue;
                    AttributeType a = (AttributeType)t;
                    TokenizerLogger.getLogger().logPropertyInfo(String.valueOf(Messages.TargetImpl_6) + a.getName() + "," + " " + a.getValue());
                    dmap.put(a.getName(), a);
                }
            }
            this.targets.clear();
        } else {
            for (TestImpl test : this.tests) {
                test.setTarget(this.refTarget);
                test.doTest();
            }
            this.refTarget = null;
        }
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    private void merge(AttributeType previous, AttributeType current) throws Throwable {
        previous.setValue(this.mergeObject(previous.getValue(), current.getValue()));
        previous.setDefault(this.mergeString(previous.getDefault(), current.getDefault()));
        previous.setType(this.mergeString(previous.getType(), current.getType()));
        previous.setReadOnly(this.mergeBoolean(previous.isReadOnly(), current.isReadOnly()));
        previous.setVisible(this.mergeBoolean(previous.isVisible(), current.isVisible()));
        previous.setStatus(this.mergeString(previous.getStatus(), current.getStatus()));
        previous.setMax(this.mergeInteger(previous.getMax(), current.getMax()));
        previous.setMin(this.mergeInteger(previous.getMin(), current.getMin()));
        previous.setDescription(this.mergeString(previous.getDescription(), current.getDescription()));
        previous.setTooltip(this.mergeString(previous.getTooltip(), current.getTooltip()));
        previous.setChoice(this.mergeString(previous.getChoice(), current.getChoice()));
    }

    private void merge(PropertyType previous, PropertyType current) throws Throwable {
        previous.setValue(this.mergeObject(previous.getValue(), current.getValue()));
        previous.setDefault(this.mergeString(previous.getDefault(), current.getDefault()));
        previous.setType(this.mergeString(previous.getType(), current.getType()));
        previous.setReadOnly(this.mergeBoolean(previous.isReadOnly(), current.isReadOnly()));
        previous.setVisible(this.mergeBoolean(previous.isVisible(), current.isVisible()));
    }

    private void mergeAttributes(List<Object> targets) throws Throwable {
        HashMap<String, AttributeType> hash = new HashMap<String, AttributeType>();
        Iterator<Object> i = targets.iterator();
        while (i.hasNext()) {
            AttributeType current = (AttributeType)i.next();
            String name = current.getName();
            if (current.getName() == null) {
                i.remove();
                continue;
            }
            AttributeType previous = (AttributeType)hash.get(name);
            if (previous != null) {
                this.merge(previous, current);
                i.remove();
                continue;
            }
            hash.put(name, current);
        }
    }

    private Boolean mergeBoolean(Boolean b0, Boolean b1) {
        if (this.allowOverwrites) {
            return b1;
        }
        if (!b0.booleanValue()) {
            return b1;
        }
        return b0;
    }

    private Integer mergeInteger(Integer i0, Integer i1) throws Throwable {
        if (i0 == null) {
            return i1;
        }
        if (i1 != null) {
            if (this.allowOverwrites) {
                return i1;
            }
            throw new Throwable(String.valueOf(Messages.StreamParserInconsistentPropertyWarning) + i0 + "," + " " + i1);
        }
        return i0;
    }

    private Object mergeObject(Object v0, Object v1) throws Throwable {
        if (v0 == null) {
            return v1;
        }
        if (v1 != null) {
            if (v0 instanceof Collection && v1 instanceof Collection) {
                ((Collection)v0).addAll((Collection)v1);
            } else if (v0 instanceof Map && v1 instanceof Map) {
                ((Map)v0).putAll((Map)v1);
            } else if (this.allowOverwrites) {
                return v1;
            }
            throw new Throwable(String.valueOf(Messages.StreamParserInconsistentPropertyWarning) + v0 + "," + " " + v1);
        }
        return v0;
    }

    private void mergeProperties(List<Object> targets) throws Throwable {
        HashMap<String, PropertyType> hash = new HashMap<String, PropertyType>();
        Iterator<Object> i = targets.iterator();
        while (i.hasNext()) {
            PropertyType current = (PropertyType)i.next();
            String name = current.getName();
            if (current.getName() == null) {
                i.remove();
                continue;
            }
            PropertyType previous = (PropertyType)hash.get(name);
            if (previous != null) {
                this.merge(previous, current);
                i.remove();
                continue;
            }
            hash.put(name, current);
        }
    }

    private String mergeString(String s0, String s1) throws Throwable {
        if (s0 == null) {
            return s1;
        }
        if (s1 != null) {
            if (this.allowOverwrites) {
                return s1;
            }
            throw new Throwable(String.valueOf(Messages.StreamParserInconsistentPropertyWarning) + s0 + "," + " " + s1);
        }
        return s0;
    }
}

